from flask import Flask, jsonify, redirect, request, url_for
from flask_cors import CORS

from model.board import Board
from model.cell import Cell
from model.difficulty import difficulties

app = Flask(__name__)
CORS(app, origins=["http://localhost:4200", "http://localhost:3000", "http://localhost:8080"])


@app.route("/")
def route_index():
    return redirect(url_for("get_difficulties"))


@app.route("/difficulties")
def get_difficulties():
    return jsonify(difficulties)


@app.route("/board")
def get_board():
    difficulty = request.args.get("difficulty", "")
    return jsonify(Board.load_board(difficulty))


@app.route("/verify", methods=["POST"])
def verify():
    json_cells = request.get_json()
    cells = list()
    for cell in json_cells:
        cells.append(Cell(dictionary=cell))
    board = Board(cells=cells)
    return {"result": board.verify()}


if __name__ == "__main__":
    app.debug = True
    app.name = "Sudoku"
    app.run(host="localhost", port=8081)
