/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datenklassen.Gruppe;
import datenklassen.Kurs;
import datenklassen.Schueler;
import gui.Eingabefehler;
import gui.Einstellungenfenster;
import gui.Kurslistefenster;
import gui.Schuelertauschen;
import gui.Vorschaufenster;
import gui.Zwangseinteilung;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import programm.Schuelerverwaltung;

public class Schuelerverwaltungfenster
extends Frame
implements ActionListener {
    JTable jTable1 = new JTable(41, 8);
    JPanel Gueteleiste = new JPanel();
    JLabel Fehlerpunkte = new JLabel();
    JTextField Anzahlfp = new JTextField();
    ScrollPane scrollpane = new ScrollPane();
    String[][] kurswahlTabelle;
    Schuelerverwaltung Programm;
    String[][] tabelle;
    boolean zuvieleSchueler = false;
    MenuBar Leiste = new MenuBar();
    Menu Datei = new Menu("Datei");
    Menu Bearbeiten = new Menu("Bearbeiten");
    Menu Ansicht = new Menu("Ansicht");
    Menu Info = new Menu("?");
    boolean berechnet;
    boolean belegunggeladen = false;
    MenuItem Berechnen = new MenuItem("Berechnen");
    MenuItem ZwangseinteilungVornehmen = new MenuItem("Zwangseinteilung vornehmen");
    MenuItem SchuelerTauschenItem = new MenuItem("Sch\u00fcler tauschen");
    MenuItem Vorschau = new MenuItem("Vorschau");
    MenuItem KurslistenAnzeigen = new MenuItem("Kurslisten anzeigen");
    MenuItem Aufschl\u00fcsselungFehlerpunkte = new MenuItem("Aufschl\u00fcsselung Fehlerpunkte");
    MenuItem Eingabefehler = new MenuItem("Eingabe Fehler");

    public Schuelerverwaltungfenster(Schuelerverwaltung Programm) {
        super("Sch\u00fclerverwaltung");
        this.Programm = Programm;
        this.setSize(1024, 786);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.berechnet = false;
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.Datei.add("Einlesen");
        this.Datei.add("Datei einlesen");
        this.Datei.add("Belegung laden");
        this.Datei.add("Speichern");
        this.Datei.add("Speichern unter");
        this.Datei.add("Einstellungen");
        this.Datei.add("Beenden");
        this.Bearbeiten.add(this.Berechnen);
        this.Bearbeiten.add(this.ZwangseinteilungVornehmen);
        this.Bearbeiten.add(this.SchuelerTauschenItem);
        this.Ansicht.add(this.Vorschau);
        this.Ansicht.add(this.Eingabefehler);
        this.Ansicht.add(this.KurslistenAnzeigen);
        this.Ansicht.add(this.Aufschl\u00fcsselungFehlerpunkte);
        this.Info.add("Info");
        this.Leiste.add(this.Datei);
        this.Leiste.add(this.Bearbeiten);
        this.Leiste.add(this.Ansicht);
        this.Leiste.add(this.Info);
        this.Datei.addActionListener(this);
        this.Bearbeiten.addActionListener(this);
        this.Ansicht.addActionListener(this);
        this.Info.addActionListener(this);
        this.Berechnen.setEnabled(false);
        this.ZwangseinteilungVornehmen.setEnabled(false);
        this.SchuelerTauschenItem.setEnabled(false);
        this.Vorschau.setEnabled(false);
        this.Eingabefehler.setEnabled(false);
        this.KurslistenAnzeigen.setEnabled(false);
        this.Aufschl\u00fcsselungFehlerpunkte.setEnabled(false);
        this.setMenuBar(this.Leiste);
        this.Fehlerpunkte.setText("Fehlerpunkte");
        this.Anzahlfp.setText("0");
        this.add((Component)this.scrollpane, "Center");
        this.scrollpane.add(this.jTable1);
        this.add((Component)this.Gueteleiste, "South");
        this.jTable1.setValueAt("Klasse", 0, 0);
        this.jTable1.setValueAt("Name", 0, 1);
        this.jTable1.setValueAt("Wahl1", 0, 2);
        this.jTable1.setValueAt("Wahl2", 0, 3);
        this.jTable1.setValueAt("Wahl3", 0, 4);
        this.jTable1.setValueAt("Gesetzt", 0, 5);
        this.jTable1.setValueAt("Geplant", 0, 6);
        this.jTable1.setValueAt("Gruppe", 0, 7);
        this.jTable1.setAutoResizeMode(0);
        TableColumnModel model = this.jTable1.getColumnModel();
        TableColumn column = model.getColumn(0);
        column.setMaxWidth(50);
        column = model.getColumn(1);
        column.setMinWidth(180);
        this.Gueteleiste.add(this.Fehlerpunkte);
        this.Gueteleiste.add(this.Anzahlfp);
        this.jTable1.setEnabled(false);
        this.tabelle = new String[0][6];
    }

    public void aktualisieren() {
        LinkedList<Schueler> schueler = this.Programm.getSchuelers();
        LinkedList<Kurs> kurse = this.Programm.getKurse();
        int j = 1;
        for (Schueler schueler2 : this.Programm.getSchuelers()) {
            if (schueler2.getGeplant() != null) {
                this.jTable1.setValueAt(schueler2.getGeplant().getNummer(), j, 6);
            }
            ++j;
        }
        this.Anzahlfp.setText("" + this.Programm.getBerechnungsg\u00fcte());
        this.Anzahlfp.setSize(10, 10);
        this.Anzahlfp.setEditable(false);
        this.setVisible(true);
        this.kurswahlTabelle = new String[kurse.size()][5 * schueler.size() + 2];
        j = 0;
        for (Kurs kurs : kurse) {
            int h = 3;
            String nummer = "" + kurs.getNummer();
            if (nummer.length() < 2) {
                nummer = "0" + nummer;
            }
            this.kurswahlTabelle[j][0] = String.valueOf(nummer) + ") " + kurs.getName();
            this.kurswahlTabelle[j][1] = "" + kurs.getMaximalbelegung();
            this.kurswahlTabelle[j][2] = kurs.getLeiter();
            LinkedList<Schueler> schuelergesvorne = new LinkedList<Schueler>();
            for (Schueler s : schueler) {
                if (s.getGesetzt() == null) continue;
                schuelergesvorne.add(s);
            }
            for (Schueler s : schueler) {
                if (schuelergesvorne.contains(s)) continue;
                schuelergesvorne.add(s);
            }
            int anzahlzwang = 0;
            int anzahleingeteilt = 0;
            for (Schueler s : schuelergesvorne) {
                if (s.getGeplant() == null || s.getGeplant().getNummer() != kurs.getNummer()) continue;
                ++anzahleingeteilt;
                this.kurswahlTabelle[j][h] = "" + s.getKlassenstufe();
                this.kurswahlTabelle[j][h + 1] = "" + s.getKlasse();
                this.kurswahlTabelle[j][h + 2] = s.getName();
                if (s.getGesetzt() != null) {
                    this.kurswahlTabelle[j][h + 3] = "Gesetzt";
                } else if (s.getGew\u00e4hlt()[0] == s.getGeplant()) {
                    this.kurswahlTabelle[j][h + 3] = "Erstwahl";
                } else if (s.getGew\u00e4hlt()[1] == s.getGeplant()) {
                    this.kurswahlTabelle[j][h + 3] = "Zweitwahl";
                } else if (s.getGew\u00e4hlt()[2] == s.getGeplant()) {
                    this.kurswahlTabelle[j][h + 3] = "Drittwahl";
                } else if (s.getGew\u00e4hlt()[0] == null) {
                    this.kurswahlTabelle[j][h + 3] = "Zwangwahl1";
                } else if (s.getGew\u00e4hlt()[1] == null) {
                    this.kurswahlTabelle[j][h + 3] = "Zwangwahl2";
                } else if (s.getGew\u00e4hlt()[2] == null) {
                    this.kurswahlTabelle[j][h + 3] = "Zwangwahl3";
                } else {
                    this.kurswahlTabelle[j][h + 3] = "Zwang";
                    ++anzahlzwang;
                }
                this.kurswahlTabelle[j][h + 4] = "";
                if (s.getGew\u00e4hlt()[0] != null) {
                    String[] stringArray = this.kurswahlTabelle[j];
                    int n = h + 4;
                    stringArray[n] = String.valueOf(stringArray[n]) + s.getGew\u00e4hlt()[0].getNummer() + "/";
                } else {
                    String[] stringArray = this.kurswahlTabelle[j];
                    int n = h + 4;
                    stringArray[n] = String.valueOf(stringArray[n]) + "-/";
                }
                if (s.getGew\u00e4hlt()[1] != null) {
                    String[] stringArray = this.kurswahlTabelle[j];
                    int n = h + 4;
                    stringArray[n] = String.valueOf(stringArray[n]) + s.getGew\u00e4hlt()[1].getNummer() + "/";
                } else {
                    String[] stringArray = this.kurswahlTabelle[j];
                    int n = h + 4;
                    stringArray[n] = String.valueOf(stringArray[n]) + "-/";
                }
                if (s.getGew\u00e4hlt()[2] != null) {
                    String[] stringArray = this.kurswahlTabelle[j];
                    int n = h + 4;
                    stringArray[n] = String.valueOf(stringArray[n]) + s.getGew\u00e4hlt()[2].getNummer();
                } else {
                    String[] stringArray = this.kurswahlTabelle[j];
                    int n = h + 4;
                    stringArray[n] = String.valueOf(stringArray[n]) + "-";
                }
                h += 5;
            }
            this.kurswahlTabelle[j][0] = String.valueOf(this.kurswahlTabelle[j][0]) + " (" + anzahleingeteilt + "/" + kurs.getMaximalbelegung() + "/" + anzahlzwang + ")";
            anzahleingeteilt = 0;
            anzahlzwang = 0;
            ++j;
        }
        this.berechnet();
    }

    private void eingelesen() {
        this.Vorschau.setEnabled(true);
        if (!this.zuvieleSchueler) {
            this.Berechnen.setEnabled(true);
        }
        this.Eingabefehler.setEnabled(true);
        this.ZwangseinteilungVornehmen.setEnabled(false);
        this.KurslistenAnzeigen.setEnabled(false);
        this.Aufschl\u00fcsselungFehlerpunkte.setEnabled(false);
        this.SchuelerTauschenItem.setEnabled(false);
    }

    private void berechnet() {
        this.ZwangseinteilungVornehmen.setEnabled(true);
        this.KurslistenAnzeigen.setEnabled(true);
        this.Aufschl\u00fcsselungFehlerpunkte.setEnabled(true);
        this.SchuelerTauschenItem.setEnabled(true);
    }

    public void actionPerformed(ActionEvent ae) {
        block45: {
            File file;
            Container fc;
            Frame frame;
            LinkedList<Kurs> kurse;
            LinkedList<Schueler> schueler;
            if (ae.getActionCommand().equals("Eingabe Fehler")) {
                new Eingabefehler(this.Programm.getKurse(), this.Programm.getSchuelersUngefiltert());
            }
            if (ae.getActionCommand().equals("Vorschau")) {
                schueler = this.Programm.getSchuelers();
                kurse = this.Programm.getKurse();
                if (schueler == null) {
                    return;
                }
                if (kurse == null) {
                    return;
                }
                frame = new Vorschaufenster(this.tabelle, this.Programm.getDateipfad());
            }
            if (ae.getActionCommand().equals("Berechnen")) {
                new Thread(new Runnable(){

                    public void run() {
                        Schuelerverwaltungfenster.this.Programm.berechnen();
                        Schuelerverwaltungfenster.this.berechnet = true;
                    }
                }).start();
            }
            if (ae.getActionCommand().equals("Kurslisten anzeigen")) {
                schueler = this.Programm.getSchuelers();
                kurse = this.Programm.getKurse();
                if (schueler == null) {
                    return;
                }
                if (kurse == null) {
                    return;
                }
                if (this.kurswahlTabelle != null) {
                    frame = new Kurslistefenster(this.kurswahlTabelle, kurse, schueler);
                }
            }
            if (ae.getActionCommand().equals("Speichern")) {
                this.speichern(this.Programm.getDateipfad());
            }
            if (ae.getActionCommand().equals("Speichern unter")) {
                fc = new JFileChooser();
                if (this.Programm.getDateipfad() != null) {
                    ((JFileChooser)fc).setCurrentDirectory(new File(this.Programm.getDateipfad()));
                }
                ((JFileChooser)fc).setFileSelectionMode(2);
                int returnVal = ((JFileChooser)fc).showSaveDialog(this);
                if (returnVal == 0) {
                    file = ((JFileChooser)fc).getSelectedFile();
                    String dateiname = file.getAbsolutePath();
                    if (!dateiname.endsWith(".xls")) {
                        dateiname = String.valueOf(dateiname) + ".xls";
                    }
                    this.speichern(dateiname);
                }
            }
            if (ae.getActionCommand().equals("Einstellungen")) {
                fc = new Einstellungenfenster(this.Programm);
            }
            if (ae.getActionCommand().equals("Beenden")) {
                System.exit(0);
            }
            if (ae.getActionCommand().equals("Info")) {
                String url = "http://wkm.de.gg";
                try {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (ae.getActionCommand().equals("Aufschl\u00fcsselung Fehlerpunkte")) {
                if (this.Programm.getAfp() != null) {
                    this.Programm.getAfp().sichtbar();
                }
                if (this.belegunggeladen) {
                    this.Programm.berechneFehlerpunkte(true);
                }
            }
            if (ae.getActionCommand().equals("Belegung laden")) {
                int returnVal;
                fc = new JFileChooser();
                ((JFileChooser)fc).setFileSelectionMode(2);
                if (this.Programm.getDateipfad() != null) {
                    ((JFileChooser)fc).setCurrentDirectory(new File(this.Programm.getDateipfad()));
                }
                if ((returnVal = ((JFileChooser)fc).showOpenDialog(this)) == 0) {
                    file = ((JFileChooser)fc).getSelectedFile();
                    String alterpfad = this.Programm.getDateipfad();
                    this.Programm.setDateipfad(file.getAbsolutePath());
                    try {
                        this.Programm.einlesen(true);
                        this.Programm.saveEinstellungen();
                        this.eingelesen();
                        this.berechnet();
                        this.belegunggeladen = true;
                        this.tabellezeichnen();
                        this.aktualisieren();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.Programm.setDateipfad(alterpfad);
                }
            }
            if (ae.getActionCommand().equals("Datei einlesen")) {
                int returnVal;
                fc = new JFileChooser();
                ((JFileChooser)fc).setFileSelectionMode(2);
                if (this.Programm.getDateipfad() != null) {
                    ((JFileChooser)fc).setCurrentDirectory(new File(this.Programm.getDateipfad()));
                }
                if ((returnVal = ((JFileChooser)fc).showOpenDialog(this)) == 0) {
                    file = ((JFileChooser)fc).getSelectedFile();
                    this.Programm.setDateipfad(file.getAbsolutePath());
                    try {
                        this.Programm.einlesen(false);
                        this.Programm.saveEinstellungen();
                        this.eingelesen();
                        this.tabellezeichnen();
                    }
                    catch (Exception alterpfad) {
                        // empty catch block
                    }
                }
            }
            if (ae.getActionCommand().equals("Einlesen")) {
                if (this.Programm.getDateipfad() == null) {
                    fc = new JFileChooser();
                    ((JFileChooser)fc).setFileSelectionMode(2);
                    int returnVal = ((JFileChooser)fc).showOpenDialog(this);
                    if (returnVal == 0) {
                        file = ((JFileChooser)fc).getSelectedFile();
                        this.Programm.setDateipfad(file.getAbsolutePath());
                        try {
                            this.Programm.einlesen(false);
                            this.Programm.saveEinstellungen();
                            this.eingelesen();
                            this.tabellezeichnen();
                        }
                        catch (Exception alterpfad) {}
                    }
                } else {
                    try {
                        this.Programm.einlesen(false);
                        this.eingelesen();
                        this.tabellezeichnen();
                    }
                    catch (Exception e) {
                        JFileChooser fc2 = new JFileChooser();
                        fc2.setFileSelectionMode(2);
                        int returnVal = fc2.showOpenDialog(this);
                        if (returnVal != 0) break block45;
                        File file2 = fc2.getSelectedFile();
                        this.Programm.setDateipfad(file2.getAbsolutePath());
                        try {
                            this.Programm.einlesen(false);
                            this.Programm.saveEinstellungen();
                            this.eingelesen();
                            this.tabellezeichnen();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (ae.getActionCommand().equals("Zwangseinteilung vornehmen")) {
            if (!this.berechnet && !this.belegunggeladen) {
                return;
            }
            Zwangseinteilung zwangseinteilung = new Zwangseinteilung(this.Programm, this);
        }
        if (ae.getActionCommand().equals("Sch\u00fcler tauschen")) {
            new Schuelertauschen(this.Programm.getKurse(), this.Programm.getSchuelers(), this);
        }
    }

    private int berechneauslastung(Kurs erstwahl) {
        LinkedList<Schueler> schuelers = this.Programm.getSchuelers();
        int counter = 0;
        for (Schueler s : schuelers) {
            if (s.getGew\u00e4hlt()[0] != erstwahl) continue;
            ++counter;
        }
        return counter;
    }

    private void speichern(String dateiname) {
        LinkedList<Schueler> schuelers = this.Programm.getSchuelers();
        LinkedList<Kurs> kurse = this.Programm.getKurse();
        LinkedList<Gruppe> gruppen = this.Programm.getGruppen();
        LinkedList<Schueler> schuelersUngefiltert = this.Programm.getSchuelersUngefiltert();
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem(new FileInputStream(this.Programm.getDateipfad()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HSSFWorkbook wb = null;
        try {
            wb = new HSSFWorkbook(fs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HSSFSheet s = wb.getSheetAt(1);
        HSSFRow row = null;
        HSSFCell cell = null;
        int reihe = 1;
        while (reihe < this.jTable1.getRowCount()) {
            row = s.getRow(reihe);
            cell = row.createCell((short)6);
            if (schuelers.get(reihe - 1).getGeplant() != null) {
                cell.setCellValue(schuelers.get(reihe - 1).getGeplant().getNummer());
            }
            ++reihe;
        }
        int i = 1000;
        while (i > 1) {
            try {
                wb.removeSheetAt(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            --i;
        }
        HSSFFont f = wb.createFont();
        f.setBoldweight((short)700);
        f.setFontHeightInPoints((short)14);
        HSSFCellStyle cs = wb.createCellStyle();
        cs.setFont(f);
        HSSFFont f2 = wb.createFont();
        f2.setBoldweight((short)700);
        HSSFCellStyle cs2 = wb.createCellStyle();
        cs2.setFont(f2);
        s = wb.createSheet();
        wb.setSheetName(2, "Vorschau", (short)0);
        row = null;
        cell = null;
        row = s.createRow(0);
        cell = row.createCell((short)0);
        cell.setCellValue("Nummer");
        cell.setCellStyle(cs2);
        cell = row.createCell((short)1);
        cell.setCellValue("Name");
        cell.setCellStyle(cs2);
        cell = row.createCell((short)2);
        cell.setCellValue("Wahl1");
        cell.setCellStyle(cs2);
        cell = row.createCell((short)3);
        cell.setCellValue("Wahl2");
        cell.setCellStyle(cs2);
        cell = row.createCell((short)4);
        cell.setCellValue("Wahl3");
        cell.setCellStyle(cs2);
        int i2 = 1;
        while (i2 <= this.tabelle.length) {
            row = s.createRow(i2);
            short j = 0;
            while (j < 5) {
                cell = row.createCell(j);
                cell.setCellValue(this.tabelle[i2 - 1][j]);
                j = (short)(j + 1);
            }
            i2 = (short)(i2 + 1);
        }
        s.setColumnWidth((short)1, (short)10000);
        LinkedList<Schueler> schuelerohneKurse = new LinkedList<Schueler>();
        for (Schueler i3 : schuelers) {
            if (i3.getGew\u00e4hlt()[0] != null && i3.getGew\u00e4hlt()[1] != null && i3.getGew\u00e4hlt()[2] != null) continue;
            schuelerohneKurse.add(i3);
        }
        s = wb.createSheet();
        s.setColumnWidth((short)0, (short)7000);
        s.setColumnWidth((short)1, (short)5000);
        s.setColumnWidth((short)2, (short)7000);
        s.setColumnWidth((short)3, (short)8500);
        s.setColumnWidth((short)4, (short)7000);
        s.setColumnWidth((short)5, (short)8500);
        s.setColumnWidth((short)6, (short)7000);
        s.setColumnWidth((short)7, (short)8500);
        s.setColumnWidth((short)8, (short)7000);
        wb.setSheetName(3, "Fehlt", (short)0);
        row = s.createRow(0);
        cell = row.createCell((short)0);
        cell.setCellValue("fehlende Wahlen");
        cell.setCellStyle(cs2);
        cell = row.createCell((short)1);
        cell.setCellValue("");
        cell.setCellStyle(cs2);
        cell = row.createCell((short)2);
        cell.setCellValue("nicht zul\u00e4ssige 1. Wahl");
        cell.setCellStyle(cs2);
        cell = row.createCell((short)4);
        cell.setCellValue("nicht zul\u00e4ssige 2. Wahl");
        cell.setCellStyle(cs2);
        cell = row.createCell((short)6);
        cell.setCellValue("nicht zul\u00e4ssige 3. Wahl");
        cell.setCellStyle(cs2);
        cell = row.createCell((short)8);
        cell.setCellValue("Guppe/Wahl Konflikt");
        cell.setCellStyle(cs2);
        row = s.createRow(1);
        cell = row.createCell((short)0);
        cell.setCellValue("");
        cell = row.createCell((short)1);
        cell.setCellValue("");
        cell = row.createCell((short)2);
        cell.setCellValue("");
        cell = row.createCell((short)3);
        cell.setCellValue("");
        cell = row.createCell((short)4);
        cell.setCellValue("");
        cell = row.createCell((short)5);
        cell.setCellValue("");
        cell = row.createCell((short)6);
        cell.setCellValue("");
        cell = row.createCell((short)7);
        cell.setCellValue("");
        cell = row.createCell((short)8);
        cell.setCellValue("");
        LinkedList<Schueler> fehlendeWahlangaben = new LinkedList<Schueler>();
        LinkedList<Schueler> fehlerhafteErsteWahl = new LinkedList<Schueler>();
        LinkedList<Schueler> fehlerhafteZweiteWahl = new LinkedList<Schueler>();
        LinkedList<Schueler> fehlerhafteDritteWahl = new LinkedList<Schueler>();
        LinkedList<Gruppe> fehlerhafteGruppenWahl = new LinkedList<Gruppe>();
        LinkedList<Schueler> schuelerMitGruppenKonflikt = new LinkedList<Schueler>();
        for (Schueler i4 : schuelersUngefiltert) {
            if (i4.getWahl1() != -1 && i4.getWahl2() != -1 && i4.getWahl3() != -1 || i4.getGesetzt() != null) continue;
            fehlendeWahlangaben.add(i4);
        }
        int counter = 0;
        for (Schueler schueler : schuelersUngefiltert) {
            for (Kurs k : kurse) {
                if (k.getNummer() == schueler.getWahl1() && k.getMaxklassenstufe() >= schueler.getKlassenstufe() && k.getMinklassenstufe() <= schueler.getKlassenstufe()) continue;
                ++counter;
            }
            if (counter == kurse.size() && schueler.getWahl1() != -1 && schueler.getGesetzt() == null) {
                fehlerhafteErsteWahl.add(schueler);
            }
            counter = 0;
        }
        counter = 0;
        for (Schueler schueler : schuelersUngefiltert) {
            for (Kurs k : kurse) {
                if (k.getNummer() == schueler.getWahl2() && k.getMaxklassenstufe() >= schueler.getKlassenstufe() && k.getMinklassenstufe() <= schueler.getKlassenstufe()) continue;
                ++counter;
            }
            if (counter == kurse.size() && schueler.getWahl2() != -1 && schueler.getGesetzt() == null) {
                fehlerhafteZweiteWahl.add(schueler);
            }
            counter = 0;
        }
        counter = 0;
        for (Schueler schueler : schuelersUngefiltert) {
            for (Kurs k : kurse) {
                if (k.getNummer() == schueler.getWahl3() && k.getMaxklassenstufe() >= schueler.getKlassenstufe() && k.getMinklassenstufe() <= schueler.getKlassenstufe()) continue;
                ++counter;
            }
            if (counter == kurse.size() && schueler.getWahl3() != -1 && schueler.getGesetzt() == null) {
                fehlerhafteDritteWahl.add(schueler);
            }
            counter = 0;
        }
        for (Gruppe gruppe : gruppen) {
            boolean checker2 = false;
            LinkedList<Schueler> gruppenSchueler = gruppe.getSchuelers();
            Kurs checkerErsteWahl = gruppenSchueler.getFirst().getGew\u00e4hlt()[0];
            Kurs checkerZweiteWahl = ((Schueler)gruppenSchueler.getFirst()).getGew\u00e4hlt()[1];
            Kurs checkerDritteWahl = ((Schueler)gruppenSchueler.getFirst()).getGew\u00e4hlt()[2];
            Iterator iterator = gruppenSchueler.iterator();
            while (iterator.hasNext()) {
                Schueler j = (Schueler)iterator.next();
                if (j.getGew\u00e4hlt()[0] == checkerErsteWahl && j.getGew\u00e4hlt()[1] == checkerZweiteWahl && j.getGew\u00e4hlt()[2] == checkerDritteWahl) continue;
                checker2 = true;
            }
            if (!checker2) continue;
            fehlerhafteGruppenWahl.add(gruppe);
        }
        while (!fehlerhafteGruppenWahl.isEmpty()) {
            Gruppe gruppe = (Gruppe)fehlerhafteGruppenWahl.getFirst();
            LinkedList<Schueler> schuelerInTempgruppe = gruppe.getSchuelers();
            for (Schueler i6 : schuelerInTempgruppe) {
                schuelerMitGruppenKonflikt.add(i6);
            }
            fehlerhafteGruppenWahl.removeFirst();
        }
        int n = Math.max(fehlendeWahlangaben.size(), fehlerhafteErsteWahl.size());
        int max2 = Math.max(n, fehlerhafteZweiteWahl.size());
        int maxAbsolut = Math.max(max2, fehlerhafteDritteWahl.size());
        row = s.createRow(1);
        cell = row.createCell((short)0);
        cell.setCellValue(String.valueOf(fehlendeWahlangaben.size()) + " Schueler");
        cell = row.createCell((short)2);
        cell.setCellValue(String.valueOf(fehlerhafteErsteWahl.size()) + " Schueler");
        cell = row.createCell((short)4);
        cell.setCellValue(String.valueOf(fehlerhafteZweiteWahl.size()) + " Schueler");
        cell = row.createCell((short)6);
        cell.setCellValue(String.valueOf(fehlerhafteDritteWahl.size()) + " Schueler");
        cell = row.createCell((short)8);
        cell.setCellValue(String.valueOf(fehlerhafteGruppenWahl.size()) + " Schueler");
        row = s.createRow(2);
        cell = row.createCell((short)1);
        cell.setCellValue("Es fehlt, ist ung\u00fcltig:");
        cell = row.createCell((short)3);
        cell.setCellValue("Fehler:");
        cell = row.createCell((short)5);
        cell.setCellValue("Fehler:");
        cell = row.createCell((short)7);
        cell.setCellValue("Fehler:");
        int i7 = 3;
        while (i7 < maxAbsolut + 3) {
            Object kw;
            row = s.createRow(i7);
            if (fehlendeWahlangaben != null && fehlendeWahlangaben.size() != 0 && fehlendeWahlangaben.getFirst() != null) {
                Schueler fehlend = (Schueler)fehlendeWahlangaben.getFirst();
                cell = row.createCell((short)0);
                cell.setCellValue("" + fehlend.getKlassenstufe() + fehlend.getKlasse() + " " + fehlend.getName());
                cell = row.createCell((short)1);
                if (fehlend.getWahl1() == -1) {
                    cell.setCellValue("Alles");
                } else if (fehlend.getWahl2() != -1) {
                    cell.setCellValue("2 Wahlen");
                } else {
                    cell.setCellValue("1 Wahl");
                }
                fehlendeWahlangaben.removeFirst();
            }
            if (fehlerhafteErsteWahl != null && fehlerhafteErsteWahl.size() != 0 && fehlerhafteErsteWahl.getFirst() != null) {
                Schueler fehlerErste = (Schueler)fehlerhafteErsteWahl.getFirst();
                cell = row.createCell((short)2);
                kw = null;
                cell.setCellValue("" + fehlerErste.getKlassenstufe() + fehlerErste.getKlasse() + " " + fehlerErste.getName());
                for (Kurs k : kurse) {
                    if (k.getNummer() != fehlerErste.getWahl1()) continue;
                    kw = k;
                    break;
                }
                cell = row.createCell((short)3);
                if (kw != null) {
                    cell.setCellValue("Projekt " + fehlerErste.getWahl1() + " nur fuer Klasse " + ((Kurs)kw).getMinklassenstufe() + " bis " + ((Kurs)kw).getMaxklassenstufe());
                } else {
                    cell.setCellValue("" + fehlerErste.getKlassenstufe() + fehlerErste.getKlasse() + " " + fehlerErste.getName() + ": Projekt " + fehlerErste.getWahl1() + " existiert nicht");
                }
                fehlerhafteErsteWahl.removeFirst();
            }
            if (fehlerhafteZweiteWahl != null && fehlerhafteZweiteWahl.size() != 0 && fehlerhafteZweiteWahl.getFirst() != null) {
                Schueler fehlerZweite = (Schueler)fehlerhafteZweiteWahl.getFirst();
                cell = row.createCell((short)4);
                cell.setCellValue("" + fehlerZweite.getKlassenstufe() + fehlerZweite.getKlasse() + " " + fehlerZweite.getName());
                kw = null;
                for (Kurs k : kurse) {
                    if (k.getNummer() != fehlerZweite.getWahl2()) continue;
                    kw = k;
                    break;
                }
                cell = row.createCell((short)5);
                if (kw != null) {
                    cell.setCellValue("Projekt " + fehlerZweite.getWahl2() + " nur fuer Klasse " + ((Kurs)kw).getMinklassenstufe() + " bis " + ((Kurs)kw).getMaxklassenstufe());
                } else {
                    cell.setCellValue("" + fehlerZweite.getKlassenstufe() + fehlerZweite.getKlasse() + " " + fehlerZweite.getName() + ": Projekt " + fehlerZweite.getWahl2() + " existiert nicht");
                }
                fehlerhafteZweiteWahl.removeFirst();
            }
            if (fehlerhafteDritteWahl != null && fehlerhafteDritteWahl.size() != 0 && fehlerhafteDritteWahl.getFirst() != null) {
                Schueler fehlerDritte = (Schueler)fehlerhafteDritteWahl.getFirst();
                cell = row.createCell((short)6);
                cell.setCellValue("" + fehlerDritte.getKlassenstufe() + fehlerDritte.getKlasse() + " " + fehlerDritte.getName());
                kw = null;
                for (Kurs k : kurse) {
                    if (k.getNummer() != fehlerDritte.getWahl3()) continue;
                    kw = k;
                    break;
                }
                cell = row.createCell((short)7);
                if (kw != null) {
                    cell.setCellValue("Projekt " + fehlerDritte.getWahl3() + " nur fuer Klasse " + ((Kurs)kw).getMinklassenstufe() + " bis " + ((Kurs)kw).getMaxklassenstufe());
                } else {
                    cell.setCellValue("" + fehlerDritte.getKlassenstufe() + fehlerDritte.getKlasse() + " " + fehlerDritte.getName() + ": Projekt " + fehlerDritte.getWahl3() + " existiert nicht");
                }
                fehlerhafteDritteWahl.removeFirst();
            }
            if (schuelerMitGruppenKonflikt != null && schuelerMitGruppenKonflikt.size() != 0 && schuelerMitGruppenKonflikt.getFirst() != null) {
                Schueler fehlerWahlGruppe = (Schueler)schuelerMitGruppenKonflikt.getFirst();
                cell = row.createCell((short)8);
                cell.setCellValue(" " + fehlerWahlGruppe.getKlassenstufe() + fehlerWahlGruppe.getKlasse() + " " + fehlerWahlGruppe.getName());
                schuelerMitGruppenKonflikt.removeFirst();
            }
            ++i7;
        }
        if (this.kurswahlTabelle != null) {
            s = wb.createSheet();
            wb.setSheetName(4, "Zwang", (short)0);
            row = s.createRow(0);
            s.setColumnWidth((short)1, (short)7500);
            cell = row.createCell((short)1);
            cell.setCellValue("zwangs- oder nichteingeteilte Schueler");
            cell.setCellStyle(cs);
            row = s.createRow(2);
            cell = row.createCell((short)1);
            cell.setCellValue("Name");
            cell.setCellStyle(cs2);
            cell = row.createCell((short)2);
            cell.setCellValue("Wahl1");
            cell.setCellStyle(cs2);
            cell = row.createCell((short)3);
            cell.setCellValue("Wahl2");
            cell.setCellStyle(cs2);
            cell = row.createCell((short)4);
            cell.setCellValue("Wahl3");
            cell.setCellStyle(cs2);
            cell = row.createCell((short)0);
            cell.setCellValue("Klasse");
            cell.setCellStyle(cs2);
            cell = row.createCell((short)5);
            cell.setCellValue("Eingeteilt");
            cell.setCellStyle(cs2);
            int k = 3;
            for (Schueler i8 : schuelers) {
                if (i8.getGeplant() != null && (i8.getGew\u00e4hlt()[0] == i8.getGeplant() || i8.getGew\u00e4hlt()[1] == i8.getGeplant() || i8.getGew\u00e4hlt()[2] == i8.getGeplant()) && i8.getGeplant().getNummer() != -1) continue;
                row = s.createRow(k);
                ++k;
                cell = row.createCell((short)0);
                cell.setCellValue("" + i8.getKlassenstufe() + i8.getKlasse());
                cell = row.createCell((short)1);
                cell.setCellValue(i8.getName());
                if (i8.getGew\u00e4hlt()[0] != null) {
                    cell = row.createCell((short)2);
                    cell.setCellValue(i8.getGew\u00e4hlt()[0].getNummer());
                }
                if (i8.getGew\u00e4hlt()[1] != null) {
                    cell = row.createCell((short)3);
                    cell.setCellValue(i8.getGew\u00e4hlt()[1].getNummer());
                }
                if (i8.getGew\u00e4hlt()[2] != null) {
                    cell = row.createCell((short)4);
                    cell.setCellValue(i8.getGew\u00e4hlt()[2].getNummer());
                }
                if (i8.getGeplant() == null) continue;
                cell = row.createCell((short)5);
                cell.setCellValue(i8.getGeplant().getNummer());
            }
            int i9 = 0;
            while (i9 < this.kurswahlTabelle.length) {
                Kurs aktkurs;
                int rownr;
                String name;
                int stellen;
                if (this.Programm.isShowDetails()) {
                    s = wb.createSheet();
                    stellen = 0;
                    while (stellen < this.kurswahlTabelle[i9][0].length()) {
                        if (this.kurswahlTabelle[i9][0].charAt(stellen) == ')') break;
                        ++stellen;
                    }
                    name = "P" + this.kurswahlTabelle[i9][0].substring(0, stellen);
                    wb.setSheetName(i9 + 5, name, (short)0);
                    row = s.createRow(0);
                    cell = row.createCell((short)0);
                    cell.setCellValue(name);
                    cell.setCellStyle(cs);
                    cell = row.createCell((short)1);
                    cell.setCellStyle(cs);
                    cell.setCellValue(this.kurswahlTabelle[i9][0].substring(4));
                    row = s.createRow(1);
                    cell = row.createCell((short)0);
                    cell.setCellValue("Leitung:");
                    cell.setCellStyle(cs2);
                    cell = row.createCell((short)1);
                    cell.setCellValue(this.kurswahlTabelle[i9][2]);
                    cell.setCellStyle(cs2);
                    rownr = 2;
                    aktkurs = null;
                    for (Kurs kurs : kurse) {
                        if (!("" + kurs.getNummer()).equals(this.kurswahlTabelle[i9][0].substring(0, stellen)) && !("0" + kurs.getNummer()).equals(this.kurswahlTabelle[i9][0].substring(0, stellen))) continue;
                        aktkurs = kurs;
                        break;
                    }
                    if (aktkurs.getOrt() != null) {
                        row = s.createRow(rownr);
                        cell = row.createCell((short)0);
                        cell.setCellValue("Ort:");
                        cell.setCellStyle(cs2);
                        cell = row.createCell((short)1);
                        cell.setCellValue(aktkurs.getOrt());
                        ++rownr;
                    }
                    if (aktkurs.getZeit() != null) {
                        row = s.createRow(rownr);
                        cell = row.createCell((short)0);
                        cell.setCellValue("Zeit:");
                        cell.setCellStyle(cs2);
                        cell = row.createCell((short)1);
                        cell.setCellValue(aktkurs.getZeit());
                        ++rownr;
                    }
                    row = s.createRow(++rownr);
                    cell = row.createCell((short)0);
                    cell.setCellValue("Klasse");
                    cell.setCellStyle(cs2);
                    cell = row.createCell((short)1);
                    cell.setCellValue("Name");
                    cell.setCellStyle(cs2);
                    cell = row.createCell((short)2);
                    cell.setCellValue("Wahl");
                    cell.setCellStyle(cs2);
                    cell = row.createCell((short)3);
                    cell.setCellValue("Wunsch");
                    cell.setCellStyle(cs2);
                    s.setColumnWidth((short)1, (short)8000);
                    s.setColumnWidth((short)2, (short)3000);
                    ++rownr;
                    int gesamt = 0;
                    int gesetzt = 0;
                    int wahl1 = 0;
                    int wahl2 = 0;
                    int wahl3 = 0;
                    int wahl0 = 0;
                    int j = 3;
                    while (j < this.kurswahlTabelle[i9].length - 1) {
                        row = s.createRow(rownr);
                        ++rownr;
                        if (this.kurswahlTabelle[i9][j] == null) break;
                        cell = row.createCell((short)0);
                        cell.setCellValue(String.valueOf(this.kurswahlTabelle[i9][j]) + this.kurswahlTabelle[i9][j + 1]);
                        cell = row.createCell((short)1);
                        cell.setCellValue(this.kurswahlTabelle[i9][j + 2]);
                        cell = row.createCell((short)2);
                        cell.setCellValue(this.kurswahlTabelle[i9][j + 3]);
                        if (this.kurswahlTabelle[i9][j + 3].equals("Zwang")) {
                            ++wahl0;
                        }
                        if (this.kurswahlTabelle[i9][j + 3].equals("Erstwahl")) {
                            ++wahl1;
                        }
                        if (this.kurswahlTabelle[i9][j + 3].equals("Zweitwahl")) {
                            ++wahl2;
                        }
                        if (this.kurswahlTabelle[i9][j + 3].equals("Drittwahl")) {
                            ++wahl3;
                        }
                        if (this.kurswahlTabelle[i9][j + 3].equals("Gesetzt")) {
                            ++gesetzt;
                        }
                        ++gesamt;
                        cell = row.createCell((short)3);
                        cell.setCellValue(this.kurswahlTabelle[i9][j + 4]);
                        j += 5;
                    }
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue(String.valueOf(gesamt) + " Teilnehmer gesamt, davon:");
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue(String.valueOf(wahl1) + " Erstwahlen,");
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue(String.valueOf(wahl2) + " Zweitwahlen,");
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue(String.valueOf(wahl3) + " Drittwahlen,");
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue(String.valueOf(wahl0) + " Zwangseinteilungen und");
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue(String.valueOf(gesetzt) + " Gesetzt");
                } else {
                    s = wb.createSheet();
                    stellen = 0;
                    while (stellen < this.kurswahlTabelle[i9][0].length()) {
                        if (this.kurswahlTabelle[i9][0].charAt(stellen) == ')') break;
                        ++stellen;
                    }
                    name = "P" + this.kurswahlTabelle[i9][0].substring(0, stellen);
                    wb.setSheetName(i9 + 5, name, (short)0);
                    row = s.createRow(0);
                    cell = row.createCell((short)0);
                    cell.setCellValue(name);
                    cell.setCellStyle(cs);
                    cell = row.createCell((short)1);
                    cell.setCellStyle(cs);
                    cell.setCellValue(this.kurswahlTabelle[i9][0].substring(4));
                    row = s.createRow(1);
                    cell = row.createCell((short)0);
                    cell.setCellValue("Leitung:");
                    cell.setCellStyle(cs2);
                    cell = row.createCell((short)1);
                    cell.setCellValue(this.kurswahlTabelle[i9][2]);
                    cell.setCellStyle(cs2);
                    rownr = 2;
                    aktkurs = null;
                    for (Kurs kurs : kurse) {
                        if (!("" + kurs.getNummer()).equals(this.kurswahlTabelle[i9][0].substring(0, stellen)) && !("0" + kurs.getNummer()).equals(this.kurswahlTabelle[i9][0].substring(0, stellen))) continue;
                        aktkurs = kurs;
                        break;
                    }
                    if (aktkurs.getOrt() != null) {
                        row = s.createRow(rownr);
                        cell = row.createCell((short)0);
                        cell.setCellValue("Ort:");
                        cell.setCellStyle(cs2);
                        cell = row.createCell((short)1);
                        cell.setCellValue(aktkurs.getOrt());
                        ++rownr;
                    }
                    if (aktkurs.getZeit() != null) {
                        row = s.createRow(rownr);
                        cell = row.createCell((short)0);
                        cell.setCellValue("Zeit:");
                        cell.setCellStyle(cs2);
                        cell = row.createCell((short)1);
                        cell.setCellValue(aktkurs.getZeit());
                        ++rownr;
                    }
                    row = s.createRow(++rownr);
                    cell = row.createCell((short)0);
                    cell.setCellValue("Klasse");
                    cell.setCellStyle(cs2);
                    cell = row.createCell((short)1);
                    cell.setCellValue("Name");
                    cell.setCellStyle(cs2);
                    cell = row.createCell((short)2);
                    cell.setCellValue("");
                    cell.setCellStyle(cs2);
                    cell = row.createCell((short)3);
                    cell.setCellValue("");
                    cell.setCellStyle(cs2);
                    s.setColumnWidth((short)1, (short)8000);
                    s.setColumnWidth((short)2, (short)3000);
                    ++rownr;
                    int j = 3;
                    while (j < this.kurswahlTabelle[i9].length - 1) {
                        row = s.createRow(rownr);
                        ++rownr;
                        if (this.kurswahlTabelle[i9][j] == null) break;
                        cell = row.createCell((short)0);
                        cell.setCellValue(String.valueOf(this.kurswahlTabelle[i9][j]) + this.kurswahlTabelle[i9][j + 1]);
                        cell = row.createCell((short)1);
                        cell.setCellValue(this.kurswahlTabelle[i9][j + 2]);
                        cell = row.createCell((short)2);
                        cell.setCellValue("");
                        cell = row.createCell((short)3);
                        cell.setCellValue("");
                        j += 5;
                    }
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue("");
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue("");
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue("");
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue("");
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue("");
                    row = s.createRow(rownr++);
                    cell = row.createCell((short)1);
                    cell.setCellValue("");
                }
                ++i9;
            }
        }
        if (this.Programm.isEinstelllungeninxls()) {
            s = wb.createSheet("Einstellungen");
            row = s.createRow(0);
            cell = row.createCell((short)0);
            cell.setCellValue("Einstellungen");
            cell.setCellStyle(cs);
            row = s.createRow(2);
            cell = row.createCell((short)0);
            cell.setCellValue("Fehlerpunkte");
            cell.setCellStyle(cs2);
            row = s.createRow(3);
            cell = row.createCell((short)0);
            cell.setCellValue("Zweite Wahl:");
            cell = row.createCell((short)1);
            cell.setCellValue(this.Programm.getFehlerpunkte2());
            row = s.createRow(4);
            cell = row.createCell((short)0);
            cell.setCellValue("Dritte Wahl:");
            cell = row.createCell((short)1);
            cell.setCellValue(this.Programm.getFehlerpunkte3());
            row = s.createRow(5);
            cell = row.createCell((short)0);
            cell.setCellValue("Zwangseinteilung:");
            cell = row.createCell((short)1);
            cell.setCellValue(this.Programm.getFehlerpunkte0());
            row = s.createRow(7);
            cell = row.createCell((short)0);
            cell.setCellValue("Vertauschen:");
            cell = row.createCell((short)1);
            if (this.Programm.isStufe2()) {
                cell.setCellValue("2 Stufen");
            } else if (this.Programm.isStufe1()) {
                cell.setCellValue("1 Stufe");
            } else {
                cell.setCellValue("keine");
            }
            row = s.createRow(8);
            cell = row.createCell((short)0);
            cell.setCellValue("Zwangseinteilen");
            cell = row.createCell((short)1);
            if (this.Programm.isWithoutBondage()) {
                cell.setCellValue("keine");
            } else if (this.Programm.isAllocationPerPercent()) {
                cell.setCellValue("gleichmaessig");
            } else if (this.Programm.isDoRandomAllocation()) {
                cell.setCellValue("zufaellig");
            } else if (this.Programm.isZwangsGruppe()) {
                cell.setCellValue("Gruppe");
            } else if (this.Programm.isPuppe()) {
                cell.setCellValue("Bestmoeglich ohne Gruppe");
            } else {
                cell.setCellValue("auff\u00fcllen");
            }
            int aktzeile = 9;
            if (!this.Programm.isPuppe()) {
                row = s.createRow(aktzeile);
                cell = row.createCell((short)0);
                cell.setCellValue("Anzahl Iterationen:");
                cell = row.createCell((short)1);
                cell.setCellValue(this.Programm.getAnzahliterationen());
                row = s.createRow(++aktzeile);
                cell = row.createCell((short)0);
                cell.setCellValue("Gruppe bevorzugt:");
                cell = row.createCell((short)1);
                if (this.Programm.isFirstGroup()) {
                    cell.setCellValue("Ja");
                } else {
                    cell.setCellValue("Nein");
                }
                ++aktzeile;
            }
            row = s.createRow(aktzeile);
            cell = row.createCell((short)0);
            cell.setCellValue("Random Schueler:");
            cell = row.createCell((short)1);
            if (this.Programm.isDoRandom()) {
                cell.setCellValue("Ja");
            } else {
                cell.setCellValue("Nein");
            }
            row = s.createRow(++aktzeile);
            cell = row.createCell((short)0);
            cell.setCellValue("Details anzeigen:");
            cell = row.createCell((short)1);
            if (this.Programm.isShowDetails()) {
                cell.setCellValue("Ja");
            } else {
                cell.setCellValue("Nein");
            }
            s.setColumnWidth((short)0, (short)5000);
            s.setColumnWidth((short)1, (short)10000);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dateiname);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            wb.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void tabellezeichnen() {
        LinkedList<Schueler> schueler = this.Programm.getSchuelers();
        this.scrollpane.remove(this.jTable1);
        this.jTable1 = new JTable(schueler.size() + 1, 8);
        this.jTable1.setValueAt("Klasse", 0, 0);
        this.jTable1.setValueAt("Name", 0, 1);
        this.jTable1.setValueAt("Wahl1", 0, 2);
        this.jTable1.setValueAt("Wahl2", 0, 3);
        this.jTable1.setValueAt("Wahl3", 0, 4);
        this.jTable1.setValueAt("Gesetzt", 0, 5);
        this.jTable1.setValueAt("Geplant", 0, 6);
        this.jTable1.setValueAt("Gruppe", 0, 7);
        this.scrollpane.add((Component)this.jTable1, "Center");
        int j = 1;
        for (Schueler i : schueler) {
            this.jTable1.setValueAt(i.getName(), j, 1);
            this.jTable1.setValueAt("" + i.getKlassenstufe() + i.getKlasse(), j, 0);
            Kurs[] kurs = i.getGew\u00e4hlt();
            if (kurs[0] != null) {
                this.jTable1.setValueAt(kurs[0].getNummer(), j, 2);
            }
            if (kurs[1] != null) {
                this.jTable1.setValueAt(kurs[1].getNummer(), j, 3);
            }
            if (kurs[2] != null) {
                this.jTable1.setValueAt(kurs[2].getNummer(), j, 4);
            }
            if (i.getGesetzt() != null) {
                this.jTable1.setValueAt(i.getGesetzt().getNummer(), j, 5);
            }
            if (i.getWahlgruppe() != -1) {
                this.jTable1.setValueAt(i.getWahlgruppe(), j, 7);
            }
            ++j;
        }
        this.jTable1.setAutoResizeMode(0);
        TableColumnModel model = this.jTable1.getColumnModel();
        TableColumn column = model.getColumn(0);
        column.setMaxWidth(50);
        column = model.getColumn(1);
        column.setMinWidth(180);
        this.jTable1.setEnabled(false);
        this.setVisible(true);
        LinkedList<Kurs> kurse = this.Programm.getKurse();
        this.tabelle = new String[kurse.size() + 2][6];
        j = 0;
        int gesmax = 0;
        int ges1 = 0;
        int ges2 = 0;
        int ges3 = 0;
        for (Kurs i : kurse) {
            this.tabelle[j][0] = "" + i.getNummer();
            this.tabelle[j][1] = i.getName();
            this.tabelle[j][5] = "" + i.getMaximalbelegung();
            gesmax += i.getMaximalbelegung();
            int k = 0;
            int l = 0;
            int m = 0;
            for (Schueler s : schueler) {
                if (s.getGew\u00e4hlt()[0] == i) {
                    ++k;
                }
                if (s.getGew\u00e4hlt()[1] == i) {
                    ++l;
                }
                if (s.getGew\u00e4hlt()[2] != i) continue;
                ++m;
            }
            this.tabelle[j][2] = "" + k;
            ges1 += k;
            this.tabelle[j][3] = "" + l;
            ges2 += l;
            this.tabelle[j][4] = "" + m;
            ges3 += m;
            ++j;
        }
        this.tabelle[++j][1] = "Summe";
        this.tabelle[j][2] = "" + ges1;
        this.tabelle[j][3] = "" + ges2;
        this.tabelle[j][4] = "" + ges3;
        this.tabelle[j][5] = "" + gesmax;
        boolean test = false;
        j = 0;
        for (Kurs k : kurse) {
            int full = 0;
            int atleastfull = 0;
            int halffull = 0;
            int atleastempty = 0;
            for (Schueler s : schueler) {
                if (s.getGew\u00e4hlt()[1] != k) continue;
                Kurs erstwahl = s.getGew\u00e4hlt()[0];
                int anzahlerstwahlen = this.berechneauslastung(erstwahl);
                int a = s.getGew\u00e4hlt()[0].getMaximalbelegung();
                double auslastung = (double)anzahlerstwahlen / (double)s.getGew\u00e4hlt()[0].getMaximalbelegung() * 100.0;
                if (auslastung >= 100.0) {
                    ++full;
                    continue;
                }
                if (auslastung >= 75.0) {
                    ++atleastfull;
                    continue;
                }
                if (auslastung >= 50.0) {
                    ++halffull;
                    continue;
                }
                ++atleastempty;
            }
            String[] stringArray = this.tabelle[j];
            stringArray[3] = String.valueOf(stringArray[3]) + " (" + full + "," + atleastfull + "," + halffull + ")";
            ++j;
        }
    }

    public void zuvieleSchueler() {
        JOptionPane.showMessageDialog(this, "In der Eingabedatei sind mehr Sch\u00fcler als freie Kurspl\u00e4tze! Korregieren Sie bitte die Eingabedatei und lesen Sie sie neu ein.");
        this.Berechnen.setEnabled(false);
        this.zuvieleSchueler = true;
    }

    public void setZuvieleSchueler(boolean zuvieleSchueler) {
        this.zuvieleSchueler = zuvieleSchueler;
    }
}

