/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class Vorschaufenster
extends Frame
implements ActionListener {
    JTable Tabelle;
    JPanel Menueleiste = new JPanel();
    JButton Speichern = new JButton();
    JButton SpeichernUnter = new JButton();
    JButton Drucken = new JButton();
    JButton Schlie\u00dfen = new JButton();
    ScrollPane Scrollpane = new ScrollPane();
    String[][] Eingabetabelle;
    String DateinameAlt;

    public Vorschaufenster(String[][] eingabetabelle, String dateiname) {
        super("Vorschau");
        this.Eingabetabelle = eingabetabelle;
        this.DateinameAlt = dateiname;
        this.Tabelle = new JTable(this.Eingabetabelle.length + 1, 6);
        this.setSize(600, 600);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Vorschaufenster.this.verstecken();
            }
        });
        this.setVisible(true);
    }

    protected void verstecken() {
        this.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.Speichern.setText("Speichern");
        this.SpeichernUnter.setText("Speichern unter");
        this.Drucken.setText("Drucken");
        this.Schlie\u00dfen.setText("Schlie\u00dfen");
        this.add((Component)this.Scrollpane, "Center");
        this.Scrollpane.add(this.Tabelle);
        this.add((Component)this.Menueleiste, "South");
        this.Menueleiste.add(this.Drucken);
        this.Menueleiste.add(this.Speichern);
        this.Menueleiste.add(this.SpeichernUnter);
        this.Menueleiste.add(this.Schlie\u00dfen);
        this.Drucken.addActionListener(this);
        this.Schlie\u00dfen.addActionListener(this);
        this.Speichern.addActionListener(this);
        this.SpeichernUnter.addActionListener(this);
        this.Tabelle.setValueAt("Nr.", 0, 0);
        this.Tabelle.setValueAt("Name", 0, 1);
        this.Tabelle.setValueAt("1.Wahl", 0, 2);
        this.Tabelle.setValueAt("2.Wahl", 0, 3);
        this.Tabelle.setValueAt("3.Wahl", 0, 4);
        this.Tabelle.setValueAt("Maximal", 0, 5);
        int i = 1;
        while (i <= this.Eingabetabelle.length) {
            int j = 0;
            while (j < 6) {
                this.Tabelle.setValueAt(this.Eingabetabelle[i - 1][j], i, j);
                ++j;
            }
            ++i;
        }
        this.Tabelle.setAutoResizeMode(0);
        TableColumnModel model = this.Tabelle.getColumnModel();
        TableColumn column = model.getColumn(0);
        column.setMaxWidth(40);
        column = model.getColumn(1);
        column.setMinWidth(180);
        column = model.getColumn(2);
        column.setMaxWidth(60);
        column = model.getColumn(3);
        column.setMaxWidth(160);
        column = model.getColumn(4);
        column.setMaxWidth(60);
        column = model.getColumn(5);
        column.setMaxWidth(60);
        this.Tabelle.setEnabled(false);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Speichern unter")) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(2);
            int returnVal = fc.showSaveDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String Dateiname = file.getAbsolutePath();
                if (!Dateiname.endsWith(".xls")) {
                    Dateiname = String.valueOf(Dateiname) + ".xls";
                }
                this.speichern(Dateiname);
            }
        }
        if (ae.getActionCommand().equals("Speichern")) {
            this.speichern(this.DateinameAlt);
        }
        if (ae.getActionCommand().equals("Schlie\u00dfen")) {
            this.verstecken();
        }
        if (ae.getActionCommand().equals("Drucken")) {
            try {
                this.Tabelle.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    private void speichern(String Speicherdatei) {
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem(new FileInputStream(this.DateinameAlt));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HSSFWorkbook wb = null;
        try {
            wb = new HSSFWorkbook(fs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int i = 1000;
        while (i > 1) {
            try {
                wb.removeSheetAt(i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            --i;
        }
        HSSFSheet s = wb.createSheet();
        wb.setSheetName(2, "Vorschau", (short)0);
        HSSFRow row = null;
        HSSFCell cell = null;
        row = s.createRow(0);
        cell = row.createCell((short)0);
        cell.setCellValue("Nummer");
        cell = row.createCell((short)1);
        cell.setCellValue("Name");
        cell = row.createCell((short)2);
        cell.setCellValue("Wahl1");
        cell = row.createCell((short)3);
        cell.setCellValue("Wahl2");
        cell = row.createCell((short)4);
        cell.setCellValue("Wahl3");
        int i2 = 1;
        while (i2 <= this.Eingabetabelle.length) {
            row = s.createRow(i2);
            short j = 0;
            while (j < 5) {
                cell = row.createCell(j);
                cell.setCellValue(this.Eingabetabelle[i2 - 1][j]);
                j = (short)(j + 1);
            }
            i2 = (short)(i2 + 1);
        }
        s.setColumnWidth((short)1, (short)10000);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(Speicherdatei);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            wb.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

