/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datenklassen.Kurs;
import datenklassen.Schueler;
import gui.Schuelerverwaltungfenster;
import gui.Zwangstablemodel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import programm.Schuelerverwaltung;

public class Zwangseinteilung
extends Frame
implements ActionListener {
    private Schuelerverwaltung Programm;
    private ScrollPane scrollpane = new ScrollPane();
    private JPanel Buttonleiste = new JPanel();
    private JButton Speichern = new JButton();
    private JButton Drucken = new JButton();
    private JButton Abbrechen = new JButton();
    private JTable jTable1 = new JTable(41, 6);
    private LinkedList<Schueler> schuelers;
    private LinkedList<Schueler> schuelerszwang;
    private Schuelerverwaltungfenster sft;

    public Zwangseinteilung(Schuelerverwaltung programm, Schuelerverwaltungfenster sft) {
        super("Zwangseinteilung vornehmen");
        this.sft = sft;
        this.Programm = programm;
        this.setSize(600, 300);
        this.Speichern.setText("Speichern");
        this.Drucken.setText("Drucken");
        this.Abbrechen.setText("Abbrechen");
        this.add((Component)this.scrollpane, "Center");
        this.add((Component)this.Buttonleiste, "South");
        this.Buttonleiste.add(this.Speichern);
        this.Buttonleiste.add(this.Drucken);
        this.Buttonleiste.add(this.Abbrechen);
        this.Speichern.addActionListener(this);
        this.Drucken.addActionListener(this);
        this.Abbrechen.addActionListener(this);
        this.schuelers = this.Programm.getSchuelers();
        this.schuelerszwang = new LinkedList();
        for (Schueler i : this.schuelers) {
            if (i.getGeplant() != null && (i.getGew\u00e4hlt()[0] != null || i.getGesetzt() != null) && (i.getGew\u00e4hlt()[0] == i.getGeplant() || i.getGew\u00e4hlt()[1] == i.getGeplant() || i.getGew\u00e4hlt()[2] == i.getGeplant())) continue;
            this.schuelerszwang.add(i);
        }
        this.jTable1.setModel(new Zwangstablemodel(this.schuelerszwang.size() + 1, 6));
        this.scrollpane.add(this.jTable1);
        this.jTable1.setValueAt("Klasse", 0, 0);
        this.jTable1.setValueAt("Name", 0, 1);
        this.jTable1.setValueAt("Wahl1", 0, 2);
        this.jTable1.setValueAt("Wahl2", 0, 3);
        this.jTable1.setValueAt("Wahl3", 0, 4);
        this.jTable1.setValueAt("Geplant", 0, 5);
        int j = 1;
        for (Schueler i : this.schuelerszwang) {
            this.jTable1.setValueAt("" + i.getKlassenstufe() + i.getKlasse(), j, 0);
            this.jTable1.setValueAt(i.getName(), j, 1);
            if (i.getGew\u00e4hlt()[0] != null) {
                this.jTable1.setValueAt("" + i.getGew\u00e4hlt()[0].getNummer(), j, 2);
            }
            if (i.getGew\u00e4hlt()[1] != null) {
                this.jTable1.setValueAt("" + i.getGew\u00e4hlt()[1].getNummer(), j, 3);
            }
            if (i.getGew\u00e4hlt()[2] != null) {
                this.jTable1.setValueAt("" + i.getGew\u00e4hlt()[2].getNummer(), j, 4);
            }
            if (i.getGeplant() != null) {
                this.jTable1.setValueAt("" + i.getGeplant().getNummer(), j, 5);
            }
            ++j;
        }
        this.jTable1.setAutoResizeMode(0);
        TableColumnModel model = this.jTable1.getColumnModel();
        TableColumn column = model.getColumn(0);
        column.setMaxWidth(50);
        column = model.getColumn(1);
        column.setMinWidth(180);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Zwangseinteilung.this.verstecken();
            }
        });
        this.setVisible(true);
        this.setAlwaysOnTop(true);
    }

    protected void verstecken() {
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Drucken")) {
            try {
                this.jTable1.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
        if (ae.getActionCommand().equals("Abbrechen")) {
            this.verstecken();
        }
        if (ae.getActionCommand().equals("Speichern")) {
            try {
                this.jTable1.getCellEditor().stopCellEditing();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            int i = 1;
            while (i < this.jTable1.getRowCount()) {
                try {
                    int number = Integer.parseInt(this.jTable1.getValueAt(i, 5).toString());
                    boolean test = false;
                    for (Kurs k : this.Programm.getKurse()) {
                        int alt;
                        int jung;
                        if (k.getNummer() != number) continue;
                        test = true;
                        if (this.schuelerszwang.get(i - 1).getKlassenstufe() < k.getMinklassenstufe() && (jung = JOptionPane.showOptionDialog(this, "Der Schueler " + this.schuelerszwang.get(i - 1).getName() + " aus Klasse " + this.schuelerszwang.get(i - 1).getKlassenstufe() + " erf\u00fcllt nicht die Mindestklassenstufe (" + k.getMinklassenstufe() + ") f\u00fcr Kurs " + k.getNummer() + ") " + k.getName() + ". Trotzdem fortfahren?", "Fortfahren?", 0, 0, null, null, null)) != 0) {
                            return;
                        }
                        if (this.schuelerszwang.get(i - 1).getKlassenstufe() <= k.getMaxklassenstufe() || (alt = JOptionPane.showOptionDialog(this, "Der Schueler " + this.schuelerszwang.get(i - 1).getName() + " aus Klasse " + this.schuelerszwang.get(i - 1).getKlassenstufe() + " \u00fcberschreitet die Maximalklassenstufe (" + k.getMaxklassenstufe() + ") f\u00fcr Kurs " + k.getNummer() + ") " + k.getName() + ". Trotzdem fortfahren?", "Fortfahren?", 0, 0, null, null, null)) == 0) continue;
                        return;
                    }
                    if (!test) {
                        JOptionPane.showMessageDialog(this, "Es existiert kein Kurs mit Nummer " + number);
                        return;
                    }
                }
                catch (NumberFormatException k) {
                    // empty catch block
                }
                ++i;
            }
            if (!this.testobzuvoll()) {
                i = 1;
                while (i < this.jTable1.getRowCount()) {
                    try {
                        int number = Integer.parseInt(this.jTable1.getValueAt(i, 5).toString());
                        if (this.schuelerszwang.get(i - 1).getGeplant() == null || this.schuelerszwang.get(i - 1).getGeplant().getNummer() != number) {
                            for (Kurs k : this.Programm.getKurse()) {
                                if (k.getNummer() != number) continue;
                                this.schuelerszwang.get(i - 1).setGeplant(k);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        this.schuelerszwang.get(i - 1).setGeplant(null);
                    }
                    catch (NullPointerException e) {
                        this.schuelerszwang.get(i - 1).setGeplant(null);
                    }
                    ++i;
                }
                this.sft.aktualisieren();
                this.verstecken();
            }
        }
    }

    private boolean testobzuvoll() {
        int max = 0;
        for (Kurs i : this.Programm.getKurse()) {
            if (i.getNummer() <= max) continue;
            max = i.getNummer();
        }
        int[] freieKursPlaetze = new int[max + 1];
        int i = 0;
        while (i < freieKursPlaetze.length) {
            freieKursPlaetze[i] = 0;
            ++i;
        }
        for (Kurs i2 : this.Programm.getKurse()) {
            freieKursPlaetze[i2.getNummer()] = i2.getMaximalbelegung();
        }
        int i3 = 1;
        while (i3 < this.jTable1.getRowCount()) {
            try {
                int number = Integer.parseInt(this.jTable1.getValueAt(i3, 5).toString());
                if (number >= 0 && number < freieKursPlaetze.length) {
                    int n = number;
                    freieKursPlaetze[n] = freieKursPlaetze[n] - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i3;
        }
        for (Schueler s : this.schuelers) {
            if (this.schuelerszwang.contains(s)) continue;
            int n = s.getGeplant().getNummer();
            freieKursPlaetze[n] = freieKursPlaetze[n] - 1;
        }
        int ok = 0;
        int i4 = 0;
        while (i4 < freieKursPlaetze.length) {
            if (freieKursPlaetze[i4] < 0 && (ok = JOptionPane.showOptionDialog(this, "Kurs Nr. " + i4 + " \u00fcbersteigt die maximale Teilnehmerzahl. Trotzdem fortfahren?", "Fortfahren?", 0, 0, null, null, null)) != 0) {
                return true;
            }
            ++i4;
        }
        return false;
    }
}

