import javax.swing.*;
import java.awt.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.awt.geom.Ellipse2D.Double;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Path2D;    

/**
 * Die Klasse DRAWINGBOARD zeichnet das Koordinatensystem und die Datenpunkte und färbt die 
 * Datenpunkte und Zentren.
 * 
 * @author Daniela Andres
 */
class DRAWINGBOARD extends JPanel {
    private static Dimension dim = Toolkit. getDefaultToolkit(). getScreenSize();
    private static int windowheight = (int) (dim.height*0.75);

    private int min;
    private int max; 
    private double achsenlaenge;
    private int rahmenabstand = 20; 
    private int objectsize = 5;

    private static double mid = windowheight/2;
    private double SCALE;
    private double pointsize;

    private static ArrayList<Color> colorList = new ArrayList<Color>(Arrays.asList(Color.GREEN,Color.YELLOW,Color.RED,Color.BLUE,Color.MAGENTA,Color.CYAN, Color.ORANGE, Color.WHITE));
    GUI frame; 
    public DRAWINGBOARD (GUI frame) {
        setOpaque (true);
        this.frame = frame;
        min = frame.getData().minValue;
        max = frame.getData().maxValue;
        achsenlaenge = Math.max(Math.abs(min), Math.abs(max));
        SCALE = (mid-rahmenabstand)/achsenlaenge;
        pointsize =  7;
    }

    @Override
    public Dimension getPreferredSize () {
        return new Dimension ( windowheight, windowheight );
    }

    @Override
    protected void paintComponent ( Graphics g ) {
        super.paintComponent ( g );
        Graphics2D g2 = (Graphics2D) g;

        int w = windowheight;

        //Achsenstriche
        g2.drawLine((int) mid, rahmenabstand, (int) mid, windowheight - rahmenabstand);
        g2.drawLine(rahmenabstand, (int) mid, windowheight - rahmenabstand, (int) mid);

        //Achsenpfeile
        //x-Achse
        Path2D myPathX = new Path2D.Double();
        myPathX.moveTo(windowheight - rahmenabstand , mid);
        myPathX.lineTo(windowheight - rahmenabstand , mid - objectsize);
        myPathX.lineTo(windowheight - rahmenabstand + objectsize, mid);
        myPathX.lineTo(windowheight - rahmenabstand , mid + objectsize);
        myPathX.lineTo(windowheight - rahmenabstand , mid);
        g2.draw(myPathX);
        g2.fill(myPathX);

        //y-Achse
        Path2D myPathY = new Path2D.Double();
        myPathY.moveTo(mid , rahmenabstand);
        myPathY.lineTo(mid - objectsize , rahmenabstand);
        myPathY.lineTo(mid , rahmenabstand-objectsize);
        myPathY.lineTo(mid + objectsize, rahmenabstand);
        myPathY.lineTo(mid , rahmenabstand);
        g2.draw(myPathY);
        g2.fill(myPathY);

        
        //Ursprung
        java.awt.geom.Ellipse2D.Double shape = new java.awt.geom.Ellipse2D.Double(mid-2,mid-2, 4, 4);
        g2.draw(shape);
        g2.fill(shape);

        drawPoints(frame.kMeans.getData(), frame.kMeans.getAssignment(), g);
        drawCenters(frame.kMeans.getCenters(), g);
    }

    /**
     * Methode zum Zeichnen der Datenpunkte
     */
    public void drawPoints(POINT[] points, int[] assignment, Graphics g){
        Graphics2D g2 = (Graphics2D) g;

        if(frame.getData() != null){
            for(int i = 0; i < points.length; i++){
                if(points[i] == null){
                    continue;
                }
                double x = points[i].getX();
                double y = points[i].getY();
                g2.setColor(Color.DARK_GRAY);
                java.awt.geom.Ellipse2D.Double shape = new java.awt.geom.Ellipse2D.Double(mid + x*SCALE -pointsize/2,mid - y*SCALE-pointsize/2, pointsize, pointsize);
                g2.draw(shape);
                g2.setColor(getColor(assignment[i]));
                g2.fill(shape);
            } 
        }

    }

    /**
     * Methode zum Zeichnen der Zentren
     */
    public void drawCenters(POINT[] points, Graphics g){
        Graphics2D g2 = (Graphics2D) g;

        if(frame.getData() != null){
            for(int i = 0; i < points.length; i++){
                if(points[i] == null){
                    continue;
                }
                double x = points[i].getX();
                double y = points[i].getY();
                g2.setColor(Color.BLACK);
                Rectangle2D rect = new Rectangle2D.Double(mid + x*SCALE-pointsize,mid - y*SCALE-pointsize, 2*pointsize, 2*pointsize);
                g2.draw(rect);
                g2.setColor(getColor(i));
                g2.fill(rect);
            } 
        }

    }

    /**
     * Hilfsmethode zum Färben der Datenpunkte 
     */
    public static Color getColor(int cluster){
        if(cluster == -1){
            return Color.GRAY;
        }
        int index = cluster%colorList.size();
        return colorList.get(index);
    }

    public boolean pointsHasNull(POINT[] points){
        for(int i = 0; i < points.length; i++){
            if(points[i] == null){
                return true;
            }
        }
        return false; 
    }
}