import java.util.Random;

/**
 * Die Klasse KMEANS implementiert den eigentlichen k-Means-Algorithmus
 * Ziel ist es, dass die Schülerinnen und Schüler die drei Methoden initialize(), assign()
 * und update() analog zum k-Means-Algorithmus von Lloyd implementieren. 
 * 
 * @author Daniela Andres
 */
public class KMEANS
{
    /**
     * Array, das die Clusterzentren erhält. Muss im Schritt "initalisieren" gefüllt werden
     */
    POINT[] centers;

    /**
     * Array, das die Punkte des Datensatzes enthält. Wird an KMEANS im Konstruktor übergeben
     */
    POINT[] data;

    int[] assignment; 
    /**
     * Gewünschte Anzahl der Zentren
     */
    int k; 

    /**
     * Für die iterative Ausführung. Hält den aktuellen Status des Algorithmus.
     */
    private STATE state;

    /**
     * Konstuktor der Klasse KMEANS
     */
    public KMEANS(POINT[] data, int k){
        this.data = data; 
        this.k = k;
        state = STATE.INIT;

        centers = new POINT[k];
        assignment = new int[data.length];
        for(int i = 0; i < assignment.length; i++){
            assignment[i] = -1;
        }
    }

    /**
     * Initalisierung: Wählt k zufällige (verschiedene bei Variante 2) Datenpunkte als Zentren.
     */
    public void initialize(){
        //Variante 1: Wähle k zufällige Punkte aus den Startpunkten als Anfangs"mittelwerte"
        /*Random random = new Random();
        for(int i = 0; i < k; i++){
        int index = random.nextInt(data.length);
        POINT zentrum = new POINT(data[index].getX(), data[index].getY());
        centers[i] = zentrum;
        }*/

        //Variante 2: Wähle k zufällige, verschiedene Punkte aus den Startpunkten als Anfangs"mittelwerte"
        //Benötigt die Methode contains(POINT[] array, POINT p). Kann entweder vorimplementiert in der 
        //Schülervorlage belassen werden oder entfernt werden, sodass die Schülerinnen und Schüler sie selbst
        //implementieren können. 
        Random random = new Random();
        int i = 0;
        while(i<k){
            int index = random.nextInt(data.length);
            POINT zentrum = new POINT(data[index].getX(), data[index].getY());
            if(!contains(centers, zentrum)){
                centers[i] = zentrum;
                i++;
            }
        }
    }

    /**
     * Zuweisung: Weist alle Datenpunkte dem Zentrum zu, von dem sie den geringsten Abstand haben. 
     */
    public void assign(){
        //Zuordnung: Jeder Punkt wird zu dem Clusterzentrum geordnet, dem es am nächsten ist
        //Den Abstand berechnet die Methode getDistance(POINT p) der Klasse POINT
        for(int i = 0; i < data.length; i++){
            double minabs = Double.MAX_VALUE;
            for(int j = 0; j < centers.length; j++){
                double abstand = data[i].getDistance(centers[j]);
                if(abstand < minabs){
                    minabs = abstand;
                    assignment[i] = j; //der Index des enstsprechnenden Zentrums = Clusternummer des Zentrums wird als Zuordnung gespeichert
                }
            }
        }
    }

    /**
     * Aktualisieren der Clusterzentren: Es wird der Mittelwert innerhalb eines Clusters ausgerechnet. 
     * Dieser Mittelwert wird das neue Clusterzentrum. 
     * Insbesondere muss dieses neue Clusterzentrum kein Punkt der ursprünglichen Daten sein. 
     */
    public void update(){
        //Variante 1
        //Mittelpunkt von jedem Cluster berechnen. Dieser Punkt wird das neue Zentrum des Clusters
        for(int i = 0; i < centers.length; i++){ //gehe durch alle bisherigen Zentren
            double meansX = 0;
            double meansY = 0;
            int count = 0; //wie viele Punkte pro Cluster
            //Mittelwertsberechnung für die x- und y-Koordinate
            for(int j = 0; j < data.length; j++){
                if(assignment[j] == i){
                    meansX += data[j].getX();
                    meansY += data[j].getY();
                    count++;
                }
            }
            meansX = meansX/count;
            meansY = meansY/count;
            centers[i].setX(meansX);
            centers[i].setY(meansY); 
        }

        //Diese Implementierung ist laufzeittechnisch nicht optimal, da für jedes Zentrum die gesamte Punktliste
        //durchlaufen werden muss. Damit entsteht eine Laufzeit von O(nk)
        //Eine Zusatzaufgabe für besonders schnelle Schüler:innen könnte sein, die Laufzeit dieser Methode 
        //zu verbessern
        //Variante 2: Erstelle k neue Clusterzentren und speichere zusätzlich die Anzahl der Clusterpunkte, 
        //als Array anzahl. 
        //Anstatt manuell für jedes Clusterzentrum einzeln einen Mittelwert zu bilden 
        //(oben mit meansX und meansY) wird direkt die Summe in der x und y Variable des neuen Zentrums gebildet. 
        //Abschließend wird nur noch für jedes Cluster durch seine jeweilige Anzahl geteilt. 
        //Da diese Variante ein genaues Verständis des Indexmanagements sowie der Projektstruktur erfordert
        //ist Variante 1 wahrscheinlich mit Schülerinnen und Schülern einfacher zu implementieren als Variante 2
        /*POINT[] centersNeu = new POINT[centers.length];
        int[] anzahl = new int[centers.length];
        for(int i = 0; i < centers.length; i++){
            centersNeu[i] = new POINT(0,0);
        }
        for(int i = 0; i < data.length; i++){
            centersNeu[assignment[i]].setX(centersNeu[assignment[i]].getX() + data[i].getX());
            centersNeu[assignment[i]].setY(centersNeu[assignment[i]].getY() + data[i].getY());
            anzahl[assignment[i]] = anzahl[assignment[i]] + 1;
        }
        for(int i = 0; i < centersNeu.length; i++){
            centersNeu[i].setX(centersNeu[i].getX()/anzahl[i]);
            centersNeu[i].setY(centersNeu[i].getY()/anzahl[i]);
        }
        centers = centersNeu; */
    }
    
    /**
     * Überprüft, ob der Punkt point in dem POINT-Array array enthalten ist
     */
    public boolean contains(POINT[] array, POINT point){
        for(int i = 0; i < array.length; i++){
            if(array[i] != null && array[i].getX() == point.getX() && array[i].getY() == point.getY()){
                return true;
            }
        }
        return false; 
    }
    
    

    /**
     * Führt einen Schritt des k-Means-Algorithmus aus.
     */
    public String nextStep() {
        if(state==STATE.INIT){
            initialize();
            state = STATE.ALLOC;
            return "Assign";
        }else if(state == STATE.ALLOC){
            assign();
            state = STATE.MEANS;
            return "Update";
        }else{
            update();
            state = STATE.ALLOC;
            return "Assign";
        }
    }

    public void addCenter(double x, double y, int index){
        centers[index] = new POINT(x,y);
    }

    public POINT[] getData(){
        return data;
    }

    public POINT[] getCenters(){
        return centers;
    }

    public int[] getAssignment(){
        return assignment; 
    }

    public STATE getState(){
        return state;
    }

    public void setState(STATE s){
        state = s;
    }
}
