import java.awt.Graphics2D;
import java.awt.Graphics;

/**
 * Die Klasse POINT hält die x- und y-Koordinate eines Punktes.
 * 
 * @author Daniela Andres
 */

public class POINT
{
    private double x;
    private double y;
    

    /**
     * Konstruktor für Objekte der Klasse POINT
     */
    public POINT(double x, double y)
    {
        this.x = x;
        this.y = y; 
    }
    
    public void setX(double x){
        this.x = x;
    }
    
    public void setY(double y){
        this.y = y; 
    }
    
    public double getX(){
        return x;
    }
    
    public double getY(){
        return y;
    }
    
    /**
     * Die Methode getDistance(POINT p) berechnet den euklidischen Abstand zwischen diesem Punkt und 
     * einem weiteren Punkt p.
     * ACHTUNG: ^2 kann nicht zum Potenzieren verwendet werden. Nutze Math.pow( , ).
     */
    public double getDistance(POINT p){
        return Math.sqrt(Math.pow(x-p.getX(),2) + Math.pow(y-p.getY(),2));
    }


    

    
    
}
