import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.text.DecimalFormat;

/**
 * Die Klasse GUI stellt in Verbindung mit der Klasse DrawingBoard die grafische Oberfläche zur Visualisierung
 * der Clusterbildung zur Verfügung
 * 
 * Workflow: 
 * Variante 1: Zum schnellen Erzeugen eines klar in vier Cluster einteilbaren Datensatzes verwende den Konstruktor
 * der Klasse GUI ohne Parameter. 
 * Variante 2: Zum Clustern eines speziellen Datensatzes mit selbst gewählter Anzahl an Zentren, muss zunächst ein 
 * Objekt der Klasse DATAHANDLER erstellt werden. Mit den dort vorhandenen Methoden kann ein Datensatz individuell
 * geladen/erstellt werden. Danach kann ein Objekt der Klasse GUI mittels des zweiten Konstruktors von GUI 
 * erstellt werden, wenn ihm dabei das eben erstellte DATAHANDLER-Objekt sowie die gewünschte Anzahl der 
 * Clusterzentren übergeben wird.
 * 
 * @author Daniela Andres
 */
public class GUI extends JFrame implements ActionListener
{
    protected int initState;

    private static Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    private static int windowheight = dim.height;

    private JButton button;
    private JPanel coordsys;
    public KMEANS kMeans;

    private DATAHANDLER d;

    private int counter; 
    private int k;
    
    //Oben Rechts Anzeige für Koordinaten der Zentren
    private JLabel label = new JLabel("Noch keine Zentren initalisiert."); 

    /**
     * Konstruktor zum schnellen Testen der Klasse KMEANS.
     * Erstellt einen zufälligen, klar in vier Cluster einteilbaren Datensatz und initialisiert mit der Methode
     * initialize() von KMEANS vier Zentren. 
     */
    public GUI(){
        new GUI(4, new DATAHANDLER());
    }

    /**
     * Konstruktor zum Testen der Klasse KMEANS auf benutzerdefinierten Daten.
     * Teilt den in dem Objekt data gespeicherten Datensatz in k viele Cluster ein. 
     */
    public GUI(int k, DATAHANDLER data)
    {
        counter = k;
        this.k = k;
        initState = 0;

        setTitle("k-Means-Visualization");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setPreferredSize(new Dimension(windowheight, windowheight));

        d = data;
        kMeans = new KMEANS(d.getPointlist(),k);

        button = new JButton("Initialize");
        button.addActionListener(this);

        //Panel (Koordinatensystem)
        coordsys = new DRAWINGBOARD(this);
        coordsys.setLayout(new BorderLayout());
        

        // Hauptfenster zusammenbauen:
        //Layout
        setLayout(new GridBagLayout());

        GridBagConstraints gbc = new GridBagConstraints();

        // Erste Spalte: Frei wachsend mit BorderLayout
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0; // Erste Spalte soll wachsen
        gbc.weighty = 1.0; // Gesamtes Grid soll wachsen
        gbc.fill = GridBagConstraints.BOTH; // Füllt den Platz in beiden Richtungen
        add(coordsys, gbc);

        //Zweite Spalte
        // Create a main panel with BorderLayout
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.1; // Zweite Spalte soll 50% der Breite einnehmen
        gbc.weighty = 1.0; // Gesamtes Grid soll wachsen
        gbc.fill = GridBagConstraints.BOTH; // Füllt den Platz in beiden Richtungen

        // Panel für die zweite Spalte mit BorderLayout
        JPanel panel = new JPanel(new BorderLayout());

        // Label oben rechts hinzufügen
        panel.add(label, BorderLayout.NORTH);

        // Panel für die Button-Zentrierung mit FlowLayout (Standardlayoutmanager für JPanel)
        JPanel buttonPanel = new JPanel(new FlowLayout(FlowLayout.CENTER));
        buttonPanel.add(button); // Button in das Button-Panel hinzufügen

        // Button-Panel zur Mitte des Haupt-Panels hinzufügen
        panel.add(buttonPanel, BorderLayout.CENTER);

        // Panel zur zweiten Spalte des Hauptfensters hinzufügen
        add(panel, gbc);


        pack();
        setVisible(true);
    }

    /**
     * Regelung der Methodenaufrufe/Animaltionen 
     */
    public void actionPerformed(ActionEvent e) {
        coordsys.revalidate();
        coordsys.repaint();
        if(initState == 0){
            String buttonText = kMeans.nextStep();
            button.setText(buttonText);
        }else{
            if(kMeans.getState() == STATE.INIT){
                if(counter > 0){
                    //Achtung: Angabe von Kommazahlen mit z.B. 5.5 und nicht 5,5! 
                    double x = Double.parseDouble(JOptionPane.showInputDialog("Die x-Koordinate des " + (k-counter+1) + "-ten Zentrums angeben", "x"));
                    double y = Double.parseDouble(JOptionPane.showInputDialog("Die y-Koordinate des " + (k-counter+1) + "-ten Zentrums angeben", "y"));
                    kMeans.addCenter(x,y,k-counter);

                    counter--;
                    coordsys.revalidate();
                    coordsys.repaint();
                }
                if(counter <= 0){
                    kMeans.setState(STATE.ALLOC);
                    button.setText("Assign");
                }
            }else{
                String buttonText = kMeans.nextStep();
                button.setText(buttonText);
            }
        }
        setLabelText(kMeans.getCenters());
    }

    public DATAHANDLER getData(){
        return d;
    }
    
    public void setLabelText(POINT[] centers){
        DecimalFormat df = new DecimalFormat("#.##");
        String text = "<html>";
        for(int i = 0; i < centers.length; i++){
            if(centers[i] == null){
                continue;
            }
            text += "Center " + nameOf(DRAWINGBOARD.getColor(i)) + ": (" + df.format(centers[i].getX()) + "|" + df.format(centers[i].getY()) + ")<br>";  
        }
        text += "</html>";
        label.setText(text);
    }
    
    public String nameOf(Color color){
        if (color.equals(Color.RED)) {
            return "Red";
        } else if (color.equals(Color.GREEN)) {
            return "Green";
        } else if (color.equals(Color.BLUE)) {
            return "Blue";
        } else if (color.equals(Color.YELLOW)) {
            return "Yellow";
        } else if (color.equals(Color.MAGENTA)) {
            return "Magenta";
        } else if (color.equals(Color.CYAN)) {
            return "Cyan";
        } else if (color.equals(Color.ORANGE)) {
            return "Orange";
        } else {
            return "White";
        }
    }
    
    

}
