import java.util.Random;

/**
 * In der Klasse KMEANS soll der k-Means-Algorithmus implementiert werden
 * Dafür stehen drei Methoden initialize(), assign() und update() analog zu den Phasen des
 * k-Means-Algorithmus von Lloyd bereit, die von dir ergänzt werden sollen. 
 * 
 * @author Daniela Andres
 */
public class KMEANS
{
    /**
     * Array, das die Clusterzentren erhält. Muss im Schritt "initalisieren" gefüllt werden
     */
    POINT[] centers;

    /**
     * Array, das die Punkte des Datensatzes enthält. Wird an KMEANS im Konstruktor übergeben
     */
    POINT[] data;

    int[] assignment; 
    /**
     * Gewünschte Anzahl der Zentren
     */
    int k; 

    /**
     * Für die iterative Ausführung. Hält den aktuellen Status des Algorithmus.
     */
    private STATE state;

    /**
     * Konstuktor der Klasse KMEANS
     */
    public KMEANS(POINT[] data, int k){
        this.data = data; 
        this.k = k;
        state = STATE.INIT;

        centers = new POINT[k];
        assignment = new int[data.length];
        for(int i = 0; i < assignment.length; i++){
            assignment[i] = -1;
        }
    }

    /**
     * Initalisierung: Wählt k zufällige Datenpunkte als Zentren.
     */
    public void initialize(){
        //TODO: Initalisiere die Liste centers indem du k zufällige Datenpunkte als Zentren wählst. 
    }

    /**
     * Zuweisung: Weist alle Datenpunkte dem Zentrum zu, von dem sie den geringsten Abstand haben. 
     */
    public void assign(){
        //TODO: Ordne jeden Punkt dem Clusterzentrum zu, dem es am nächsten ist
    }

    /**
     * Aktualisierung der Clusterzentren: Berechnet die Mittelwerte der einzelnen Cluster. Ein Punkt
     * an diesen Koordinaten wird das neue Zentrum des jeweiligen Clusters.
     */
    public void update(){
        //TODO: Aktualisiere die Clusterzentren. 
    }
    
    
    /**
     * Überprüft, ob der Punkt point in dem POINT-Array array enthalten ist
     */
    public boolean contains(POINT[] array, POINT point){
        for(int i = 0; i < array.length; i++){
            if(array[i] != null && array[i].getX() == point.getX() && array[i].getY() == point.getY()){
                return true;
            }
        }
        return false; 
    }

    
    
    //Code, der für das Gesamtprojekt benötigt wird. Hier muss nichts mehr implementiert werden 
    
    /**
     * Führt einen Schritt des k-Means-Algorithmus aus.
     */
    public String nextStep() {
        if(state==STATE.INIT){
            initialize();
            state = STATE.ALLOC;
            return "Assign";
        }else if(state == STATE.ALLOC){
            assign();
            state = STATE.MEANS;
            return "Update";
        }else{
            update();
            state = STATE.ALLOC;
            return "Assign";
        }
    }
    
    public void addCenter(double x, double y, int index){
        centers[index] = new POINT(x,y);
    }

    public POINT[] getData(){
        return data;
    }

    public POINT[] getCenters(){
        return centers;
    }

    public int[] getAssignment(){
        return assignment; 
    }

    public STATE getState(){
        return state;
    }

    public void setState(STATE s){
        state = s;
    }
}
