import {NgModule} from '@angular/core';
import {RouterModule, Routes} from "@angular/router";

import {DifficultiesComponent} from "./difficulties/difficulties.component";
import {BoardComponent} from "./board/board.component";

const routes: Routes = [
  {path: '', redirectTo: '/sudoku', pathMatch: 'full'},
  {path: 'sudoku', component: DifficultiesComponent},
  {path: 'sudoku/:difficulty', component: BoardComponent},
  {path: '**', redirectTo: '/sudoku', pathMatch: 'full'}
];

@NgModule({
  declarations: [],
  imports: [
    RouterModule.forRoot(routes)
  ],
  exports: [
    RouterModule
  ]
})
export class AppRoutingModule {
}
