import {Cell} from "./cell";

export class Board {
  values: Map<number, Cell>;

  constructor(values: any) {
    this.values = new Map<number, Cell>();
    for (let cellId in values) {
      let cell = values[cellId] as Cell;
      this.values.set(parseInt(cellId), new Cell(cell.id, cell.value));
    }
  }

  getCell(outerRow: number, outerColumn: number, innerRow: number, innerColumn: number): Cell {
    let rowNumber = (outerRow - 1) * 3 + innerRow;
    let columnNumber = (outerColumn - 1) * 3 + innerColumn;
    let cellId = parseInt("" + rowNumber + columnNumber);
    return this.values.get(cellId)!;
  }

  countMissingValues(): number {
    let missingValues = 0;
    for (let cell of this.values.values()) {
      if (cell.value === 0) {
        missingValues++;
      }
    }
    return missingValues;
  }
}

export class VerificationResult {
  result: String;

  constructor(result: String) {
    this.result = result;
  }
}
