import {Navbar} from "react-bootstrap";
import {Link, Redirect, Route, Switch} from 'react-router-dom';

import {FontAwesomeIcon} from "@fortawesome/react-fontawesome";
import {faReact} from "@fortawesome/free-brands-svg-icons";

import DifficultiesComponent from "./components/DifficultiesComponent";
import BoardComponent from "./components/BoardComponent";

function App() {
    return (
        <div className="App">
            <Navbar bg="light">
                <Navbar.Brand className="mb-0 h1">
                    <Link to="/test" style={{color: 'inherit', textDecoration: 'inherit'}}>
                        <FontAwesomeIcon color="#61dafb" icon={faReact}/>
                        Sudoku
                    </Link>
                </Navbar.Brand>
            </Navbar>
            <Switch>
                <Route exact path="/"><Redirect to="/sudoku"/></Route>
                <Route exact path="/sudoku" component={DifficultiesComponent}/>
                <Route exact path="/sudoku/:difficulty" component={BoardComponent}/>
                <Route exact path="**"><Redirect to="/sudoku"/></Route>
            </Switch>
        </div>
    );
}

export default App;
