import React from "react";
import {Col, Container, ListGroup, Row} from "react-bootstrap";
import {backendURL, CheckError} from "../constants";

class DifficultiesComponent extends React.Component {

    constructor(props) {
        super(props);
        this.state = {
            difficulties: []
        };
    }

    componentDidMount() {
        fetch(backendURL + "/difficulties")
            .then(CheckError)
            .then((jsonResponse) => {
                this.setState({
                    difficulties: jsonResponse
                });
            })
            .catch((error) => {
                console.error(error);
                window.alert(error.message);
            });
    }

    render() {
        let header;
        let selection = null;
        if (this.state.difficulties.length === 0) {
            header = <h5>Loading available difficulties...</h5>;
        } else {
            header = <h5>Please select a difficulty</h5>;

            selection =
                <Col xs={12}>
                    <ListGroup>
                        {this.state.difficulties.map((difficulty) =>
                            <ListGroup.Item action key={difficulty.id}
                                            onClick={() => this.props.history.push("/sudoku/" + difficulty.name)}>
                                {difficulty.name}
                            </ListGroup.Item>
                        )}
                    </ListGroup>
                </Col>;
        }

        return (
            <div className="Difficulties">
                <Container fluid>
                    <Row>
                        <Col xs={12}>
                            {header}
                        </Col>
                    </Row>
                </Container>
                {selection}
            </div>
        );
    }
}

export default DifficultiesComponent;