import Vue from 'vue'
import VueRouter from 'vue-router'
import Difficulties from "@/views/Difficulties";
import Board from "@/views/Board";

Vue.use(VueRouter)

const routes = [
    {
        path: '/',
        redirect: {
            name: 'Difficulties'
        }
    },
    {
        path: '/sudoku',
        name: 'Difficulties',
        component: Difficulties
    },
    {
        path: '/sudoku/:difficulty',
        name: 'Board',
        component: Board
    },
    {
        path: '*',
        redirect: {
            name: 'Difficulties'
        }
    }
]

const router = new VueRouter({
    mode: 'history',
    base: process.env.BASE_URL,
    routes
})

export default router
