import {Component, OnInit} from '@angular/core';

import {Board, VerificationResult} from "../model/board";
import {ActivatedRoute} from "@angular/router";
import {SudokuService} from "../sudoku.service";

@Component({
  selector: 'app-board',
  templateUrl: './board.component.html',
  styleUrls: ['./board.component.css']
})
export class BoardComponent implements OnInit {

  board?: Board;
  difficulty = "";
  verificationRunning = false;

  constructor(
    private route: ActivatedRoute,
    private sudokuService: SudokuService
  ) {
  }

  ngOnInit(): void {
    this.difficulty = this.route.snapshot.paramMap.get('difficulty')!;
    this.sudokuService.getBoard(this.difficulty)
      .subscribe((data: Board) => this.board = new Board(data.values));
  }

  verify() {
    this.verificationRunning = true;
    this.sudokuService.verifyBoard(this.board!)
      .subscribe({
        next: (data: VerificationResult) => {
          window.alert(data.result);
          this.verificationRunning = false;
        },
        error: (_) => {
          this.verificationRunning = false;
        }
      });
  }

}
