import Cell from "./Cell";

class Board {
    constructor(values) {
        this.values = new Map();
        for (let cellId in values) {
            let cell = values[cellId];
            this.values.set(parseInt(cellId), new Cell(cell.id, cell.value));
        }
    }

    getCell(outerRow, outerColumn, innerRow, innerColumn) {
        let rowNumber = (outerRow - 1) * 3 + innerRow;
        let columnNumber = (outerColumn - 1) * 3 + innerColumn;
        let cellId = parseInt("" + rowNumber + columnNumber);
        return this.values.get(cellId);
    }

    countMissingValues() {
        let missingValues = 0;
        for (let cell of this.values.values()) {
            if (cell.value === 0) {
                missingValues++;
            }
        }
        return missingValues;
    }
}

export default Board;