import { createRouter, createWebHashHistory } from 'vue-router'
import Difficulties from "@/views/Difficulties";
import Board from "@/views/Board";

const routes = [
    {
        path: '/',
        redirect: {
            name: 'Difficulties'
        }
    },
    {
        path: '/sudoku',
        name: 'Difficulties',
        component: Difficulties
    },
    {
        path: '/sudoku/:difficulty',
        name: 'Board',
        component: Board
    },
    {
        path: '/:pathMatch(.*)*',
        redirect: {
            name: 'Difficulties'
        }
    }
]

const router = createRouter({
    history: createWebHashHistory(),
    routes
})

export default router
