/*
 * Decompiled with CFR 0.152.
 */
package muehle;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JApplet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import mln.DiffFunction;
import mln.LearningParameter;
import mln.NeuralNetwork;
import mln.SigmoidFunction;
import muehle.Muehle;
import muehle.gui.AboutDialog;
import muehle.gui.PlayerPanel;
import muehle.gui.PlaygroundPanel;
import muehle.gui.StatusPanel;
import muehle.logic.Playground;
import muehle.logic.Stone;
import muehle.player.ComputerPlayer;
import muehle.player.HumanPlayer;
import muehle.player.Player;
import muehle.thinking.Heuristic;
import muehle.thinking.StandardHeuristic;

public class MuehleApp
extends JApplet
implements Runnable,
ActionListener {
    private String VERSION_NUMBER = "2.45";
    private Playground p;
    private StatusPanel statuspanel;
    private PlayerPanel playerpanel;
    private PlaygroundPanel playgroundpanel;
    private Player player1;
    private Player player2;
    private Player aktPlayer;
    private Player gameWon;
    private JCheckBoxMenuItem m_power_1;
    private JCheckBoxMenuItem m_power_2;
    private JCheckBoxMenuItem m_power_3;
    private JMenuItem m_moveProposal;
    private JMenuItem m_offerDraw;
    private AboutDialog aboutDialog;
    private boolean verbose = false;
    private boolean gestoppt = true;
    private boolean threadEnd = true;
    private Thread play;
    private final double POWER_1 = 0.4;
    private final double POWER_2 = 0.2;
    private final double POWER_3 = 0.0;
    private Heuristic staticHeuristic;

    public void init() {
        System.out.println("Init...");
        this.verbose = false;
        MuehleApp.getAudioClips(this.getCodeBase());
        int[] layersizes = new int[]{3};
        DiffFunction[] functions = new DiffFunction[]{SigmoidFunction.f};
        NeuralNetwork nn = new NeuralNetwork(39, layersizes, functions, LearningParameter.standardParameters);
        double[] wights0 = new double[]{0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.15, 0.2, 0.25, 0.3, 0.0, 0.0, 0.0, 0.0, 0.0, 0.01, 0.02, 0.0, 0.0, 0.02, 0.04, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02, 0.04, 0.08, 0.16};
        double[] wights1 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.15, 0.2, 0.25, 0.3, 0.0, 0.0, 0.01, 0.02, 0.0, 0.0, 0.02, 0.04, 0.16, 0.08, 0.04, 0.02, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] wights2 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        nn.getLayers()[0].getNeurons()[0].setWeights(wights0);
        nn.getLayers()[0].getNeurons()[0].setActivationEnergy(0.0);
        nn.getLayers()[0].getNeurons()[1].setWeights(wights1);
        nn.getLayers()[0].getNeurons()[1].setActivationEnergy(0.0);
        nn.getLayers()[0].getNeurons()[2].setWeights(wights2);
        nn.getLayers()[0].getNeurons()[2].setActivationEnergy(0.0);
        this.staticHeuristic = new StandardHeuristic(nn);
        this.staticHeuristic.setUseDatabase(false);
        this.setSize(650, 650);
        Frame parent = JOptionPane.getFrameForComponent(this);
        this.aboutDialog = new AboutDialog(parent);
        this.getContentPane().setLayout(new BorderLayout());
        JMenuBar m = new JMenuBar();
        JMenu m1 = new JMenu("Spiel");
        JMenu m2 = new JMenu("Einstellungen");
        JMenu m3 = new JMenu("Hilfe");
        m1.setMnemonic('S');
        m2.setMnemonic('E');
        m3.setMnemonic('H');
        JMenuItem m_neu = new JMenuItem("Neues Spiel", 78);
        this.m_offerDraw = new JMenuItem("Remis anbieten", 82);
        this.m_moveProposal = new JMenuItem("Zugvorschlag", 90);
        JMenuItem m_help = new JMenuItem("Hilfe", 72);
        JMenuItem m_about = new JMenuItem("\u00dcber M\u00fchle", 77);
        JCheckBoxMenuItem m_sound = new JCheckBoxMenuItem("Soundeffekte");
        JCheckBoxMenuItem m_markLastAction = new JCheckBoxMenuItem("letzten Zug markieren");
        JCheckBoxMenuItem m_coordinates = new JCheckBoxMenuItem("Koordinaten anzeigen");
        JMenu m_power = new JMenu("Spielst\u00e4rke");
        m_power.setMnemonic('k');
        this.m_power_1 = new JCheckBoxMenuItem("Anf\u00e4nger");
        this.m_power_2 = new JCheckBoxMenuItem("Fortgeschrittener");
        this.m_power_3 = new JCheckBoxMenuItem("Profi");
        m_power.add(this.m_power_1);
        m_power.add(this.m_power_2);
        m_power.add(this.m_power_3);
        this.m_power_3.setState(true);
        m_sound.setState(true);
        m_markLastAction.setState(true);
        m_coordinates.setState(true);
        m1.add(m_neu);
        m1.addSeparator();
        m1.add(this.m_offerDraw);
        m1.add(this.m_moveProposal);
        m2.add(m_power);
        m2.addSeparator();
        m2.add(m_sound);
        m2.add(m_markLastAction);
        m2.add(m_coordinates);
        m3.add(m_help);
        m3.add(m_about);
        m.add(m1);
        m.add(m2);
        m.add(m3);
        this.setJMenuBar(m);
        m_neu.addActionListener(this);
        this.m_offerDraw.addActionListener(this);
        m_power.addActionListener(this);
        m_about.addActionListener(this);
        this.m_power_1.addActionListener(this);
        this.m_power_2.addActionListener(this);
        this.m_power_3.addActionListener(this);
        m_markLastAction.addActionListener(this);
        m_sound.addActionListener(this);
        m_coordinates.addActionListener(this);
        this.m_moveProposal.addActionListener(this);
        this.newGame();
    }

    public void newGame() {
        this.p = new Playground();
        this.gameWon = null;
        this.player1 = new HumanPlayer("Player", Stone.O);
        this.player2 = new ComputerPlayer("Computer", Stone.X, this.staticHeuristic);
        this.aktPlayer = this.player1;
        this.player1.setOpponent(this.player2);
        this.player2.setOpponent(this.player1);
        this.player1.setVerbose(this.verbose);
        this.player2.setVerbose(this.verbose);
        if (!(this.player1 instanceof ComputerPlayer) && !(this.player2 instanceof ComputerPlayer)) {
            this.m_moveProposal.setEnabled(false);
            this.m_offerDraw.setEnabled(false);
        } else {
            this.m_moveProposal.setEnabled(true);
            this.m_offerDraw.setEnabled(true);
        }
        this.statuspanel = new StatusPanel(this.player1, this.player2);
        this.playerpanel = new PlayerPanel(this.player1, this.player2);
        this.playgroundpanel = new PlaygroundPanel(this.p);
        this.playgroundpanel.setPlayer(this.aktPlayer);
        this.playerpanel.setPreferredSize(new Dimension((int)((double)this.getWidth() * 0.25), 0));
        this.statuspanel.setPreferredSize(new Dimension(0, (int)((double)this.getHeight() * 0.15)));
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.playgroundpanel, "Center");
        this.getContentPane().add((Component)this.playerpanel, "East");
        this.getContentPane().add((Component)this.statuspanel, "South");
        this.getContentPane().validate();
        while (!this.threadEnd) {
            System.gc();
        }
        if (this.m_power_1.getState()) {
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.4);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.4);
            }
        } else if (this.m_power_2.getState()) {
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.2);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.2);
            }
        } else if (this.m_power_3.getState()) {
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.0);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.0);
            }
        }
        this.play = new Thread(this);
        this.threadEnd = false;
        this.play.start();
    }

    public void destroy() {
        this.threadEnd = true;
        this.play.interrupt();
        this.notifyThread();
    }

    public void run() {
        this.statuspanel.setText("Das Spiel beginnt!");
        Hashtable<Playground, Integer> remisHash = new Hashtable<Playground, Integer>();
        int moveCounter = 0;
        while (!this.isGameOver()) {
            this.playerpanel.setAktPlayer(this.aktPlayer);
            this.playerpanel.repaint();
            this.playgroundpanel.setPlayer(this.aktPlayer);
            this.aktPlayer.getThread(this.play);
            this.aktPlayer.makeMove(this.p);
            this.p.appendAction(this.aktPlayer.getLastAction());
            if (++moveCounter == 100) {
                this.aktPlayer.soundPlayback(2);
                this.statuspanel.setText("Remis durch 100 Z\u00fcge-Regel! Das Spiel endet unentschieden!");
                this.play.interrupt();
            }
            if (remisHash.containsKey(this.p)) {
                int val = (Integer)remisHash.get(this.p);
                if (val == 2) {
                    this.aktPlayer.soundPlayback(2);
                    this.statuspanel.setText("Remis durch Zugwiederholung! Spiel endet unentschieden!");
                    this.play.interrupt();
                }
                remisHash.put(this.p, new Integer(val + 1));
            } else {
                remisHash.put(this.p, new Integer(1));
            }
            this.playgroundpanel.repaint();
            if (this.play.isInterrupted()) {
                this.threadEnd = true;
                return;
            }
            this.statuspanel.setText("Zug von " + this.aktPlayer.getName() + ": " + this.aktPlayer.getLastAction().toString());
            if (this.p.isMuehle(this.aktPlayer.getLastAction()) && !this.p.getPlayersFreeStones(this.aktPlayer.getOpponent().getStone()).isEmpty()) {
                this.aktPlayer.deleteStone(this.p);
                this.p.appendAction(this.aktPlayer.getLastAction());
                this.playgroundpanel.repaint();
                this.statuspanel.setText(this.aktPlayer.getLastAction().toString());
            }
            this.aktPlayer = this.aktPlayer.getOpponent();
        }
        this.gameWon.soundPlayback(2);
        this.statuspanel.setText("Spielende: Spieler " + this.gameWon.getName() + " hat gewonnen!");
        this.playerpanel.repaint();
        this.threadEnd = true;
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String item = source.getText();
        if ("Neues Spiel".equals(item)) {
            if (!this.threadEnd) {
                this.play.interrupt();
                this.notifyThread();
            }
            this.newGame();
        }
        if ("letzten Zug markieren".equals(item)) {
            this.playgroundpanel.flipMarkLastAction();
            this.repaint();
        }
        if ("Koordinaten anzeigen".equals(item)) {
            this.playgroundpanel.flipShowCoordinates();
            this.repaint();
        }
        if ("Soundeffekte".equals(item)) {
            Player.flipSound();
            this.repaint();
        }
        if ("Zugvorschlag".equals(item) && this.aktPlayer instanceof HumanPlayer && this.aktPlayer.getOpponent() instanceof ComputerPlayer) {
            ((HumanPlayer)this.aktPlayer).moveProposal(this.p, this.statuspanel, ((ComputerPlayer)this.aktPlayer.getOpponent()).getHeuristic());
            this.repaint();
        }
        if ("Remis anbieten".equals(item)) {
            boolean b1 = this.player1.acceptDraw(this.p);
            boolean b2 = this.player2.acceptDraw(this.p);
            if (b1 && b2) {
                this.player1.soundPlayback(2);
                this.play.interrupt();
                this.notifyThread();
                this.statuspanel.setText("Remis akzeptiert!");
                this.statuspanel.setText("Das Spiel endet unentschieden!");
            } else {
                this.player1.soundPlayback(0);
                this.statuspanel.setText("Remis NICHT akzeptiert!");
            }
        }
        if ("Anf\u00e4nger".equals(item)) {
            this.m_power_2.setState(false);
            this.m_power_3.setState(false);
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.4);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.4);
            }
        }
        if ("Fortgeschrittener".equals(item)) {
            this.m_power_1.setState(false);
            this.m_power_3.setState(false);
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.2);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.2);
            }
        }
        if ("Profi".equals(item)) {
            this.m_power_1.setState(false);
            this.m_power_2.setState(false);
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.0);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.0);
            }
        }
        if ("\u00dcber M\u00fchle".equals(item)) {
            this.aboutDialog.setToVisible(true);
        }
    }

    public StatusPanel getStatusPanel() {
        return this.statuspanel;
    }

    private boolean isGameOver() {
        if (this.aktPlayer.getNumberOfStones() < 3 && this.aktPlayer.getNumberOfInitStones() == 0 || !this.p.hasActions(this.aktPlayer)) {
            this.gameWon = this.aktPlayer.getOpponent();
            return true;
        }
        if (this.aktPlayer.getOpponent().getNumberOfStones() < 3 && this.aktPlayer.getOpponent().getNumberOfInitStones() == 0 || !this.p.hasActions(this.aktPlayer.getOpponent())) {
            this.gameWon = this.aktPlayer;
            return true;
        }
        return false;
    }

    private void notifyThread() {
        Thread thread = this.play;
        synchronized (thread) {
            this.play.notify();
        }
    }

    public static AudioClip[] getAudioClips(URL codebase) {
        try {
            AudioClip[] ac = new AudioClip[3];
            String url_header = String.valueOf(codebase.getProtocol()) + "://" + codebase.getHost() + codebase.getPath();
            ac[0] = Applet.newAudioClip(new URL(String.valueOf(url_header) + "Resources/ding.wav"));
            ac[1] = Applet.newAudioClip(new URL(String.valueOf(url_header) + "Resources/set.wav"));
            ac[2] = Applet.newAudioClip(new URL(String.valueOf(url_header) + "Resources/win.wav"));
            Player.setAudio(ac);
            return ac;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        boolean verbose = false;
        if (args.length != 0 && args[0].equals("-v")) {
            verbose = true;
        }
        Muehle m = new Muehle(verbose);
        m.setVisible(true);
    }
}

