/*
 * Decompiled with CFR 0.152.
 */
package muehle.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import muehle.logic.Action;
import muehle.logic.DeleteAction;
import muehle.logic.MoveAction;
import muehle.logic.Playground;
import muehle.player.HumanPlayer;
import muehle.player.Player;

public class PlaygroundPanel
extends JPanel {
    private Playground p;
    private Player aktPlayer;
    private final int borderQuotient = 8;
    private boolean markLastAction = true;
    private int mouseX = -1;
    private int mouseY = -1;
    private int dragStart = -1;
    private boolean showCoordinates = true;
    private static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    public PlaygroundPanel(Playground p) {
        this.p = p;
        MouseListener mListener = new MouseListener(){

            public void mouseClicked(MouseEvent m) {
            }

            public void mousePressed(MouseEvent m) {
                int result = PlaygroundPanel.this.translate(m.getX(), m.getY());
                PlaygroundPanel.this.dragStart = result;
                if (result < 0) {
                    return;
                }
                PlaygroundPanel.this.aktPlayer.pressedAt(result);
            }

            public void mouseReleased(MouseEvent m) {
                PlaygroundPanel.this.mouseX = -1;
                PlaygroundPanel.this.mouseY = -1;
                PlaygroundPanel.this.dragStart = -1;
                PlaygroundPanel.this.repaint();
                int result = PlaygroundPanel.this.translate(m.getX(), m.getY());
                if (result < 0) {
                    return;
                }
                PlaygroundPanel.this.aktPlayer.releasedAt(result);
            }

            public void mouseEntered(MouseEvent m) {
            }

            public void mouseExited(MouseEvent m) {
            }
        };
        MouseMotionListener mmListener = new MouseMotionListener(){

            public void mouseMoved(MouseEvent m) {
            }

            public void mouseDragged(MouseEvent m) {
                if (!PlaygroundPanel.this.aktPlayer.canSet() && PlaygroundPanel.this.aktPlayer instanceof HumanPlayer) {
                    PlaygroundPanel.this.mouseX = m.getX();
                    PlaygroundPanel.this.mouseY = m.getY();
                    PlaygroundPanel.this.repaint();
                }
            }
        };
        this.addMouseListener(mListener);
        this.addMouseMotionListener(mmListener);
    }

    public void setPlayer(Player player) {
        this.aktPlayer = player;
    }

    public void flipMarkLastAction() {
        this.markLastAction = !this.markLastAction;
    }

    public int translate(int mx, int my) {
        int width = this.getWidth();
        int border = this.getWidth() / 8;
        int height = this.getHeight();
        Point[] position = this.getPosition(width, height, border);
        int i = 0;
        while (i < 24) {
            int x = position[i].x;
            int y = position[i].y;
            if (Math.abs(mx - x) < this.getWidth() / 24 && Math.abs(my - y) < this.getWidth() / 24) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 500);
    }

    public void update(Graphics g) {
        Image offscreen = null;
        Dimension d = this.getSize();
        offscreen = this.createImage(d.width, d.height);
        Graphics offgc = offscreen.getGraphics();
        offgc.setColor(this.getBackground());
        offgc.fillRect(0, 0, d.width, d.height);
        offgc.setColor(this.getForeground());
        this.paint(offgc);
        g.drawImage(offscreen, 0, 0, this);
    }

    public void paint(Graphics g2) {
        Graphics2D g = (Graphics2D)g2;
        g.addRenderingHints(AALIAS);
        int width = this.getWidth();
        int border = this.getWidth() / 8;
        int height = this.getHeight();
        Action lastAction = null;
        Action delAction = null;
        if (this.p.getActions().size() != 0 && (lastAction = (Action)this.p.getActions().get(this.p.getActions().size() - 1)) instanceof DeleteAction) {
            delAction = lastAction;
            lastAction = (Action)this.p.getActions().get(this.p.getActions().indexOf(delAction) - 1);
        }
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, width, height);
        g.setColor(new Color(200, 155, 100));
        g.fillRect(4, 4, width - 7, height - 8);
        g.setColor(new Color(0, 0, 0));
        g.drawLine(border, border, width - border, border);
        g.drawLine(border, width - border, width - border, width - border);
        g.drawLine(border, border, border, width - border);
        g.drawLine(width - border, width - border, width - border, border);
        g.drawLine(border + (width - 2 * border) / 6, border + (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6, border + (width - 2 * border) / 6);
        g.drawLine(border + (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6);
        g.drawLine(border + (width - 2 * border) / 6, border + (width - 2 * border) / 6, border + (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6);
        g.drawLine(border + 5 * (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6, border + (width - 2 * border) / 6);
        g.drawLine(border + (width - 2 * border) / 3, border + (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3, border + (width - 2 * border) / 3);
        g.drawLine(border + (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3);
        g.drawLine(border + (width - 2 * border) / 3, border + (width - 2 * border) / 3, border + (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3);
        g.drawLine(border + 2 * (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3, border + (width - 2 * border) / 3);
        g.drawLine(width / 2, border, width / 2, border + (width - 2 * border) / 3);
        g.drawLine(width / 2, border + 2 * (width - 2 * border) / 3, width / 2, width - border);
        g.drawLine(border, width / 2, border + (width - 2 * border) / 3, width / 2);
        g.drawLine(border + 2 * (width - 2 * border) / 3, width / 2, width - border, width / 2);
        if (this.showCoordinates) {
            g.drawString("a", border - 3, border / 2);
            g.drawString("b", border + 1 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("c", border + 2 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("d", border + 3 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("e", border + 4 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("f", border + 5 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("g", border + 6 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("1", border / 2, border + 3);
            g.drawString("2", border / 2, border + 1 * (width - 2 * border) / 6 + 3);
            g.drawString("3", border / 2, border + 2 * (width - 2 * border) / 6 + 3);
            g.drawString("4", border / 2, border + 3 * (width - 2 * border) / 6 + 3);
            g.drawString("5", border / 2, border + 4 * (width - 2 * border) / 6 + 3);
            g.drawString("6", border / 2, border + 5 * (width - 2 * border) / 6 + 3);
            g.drawString("7", border / 2, border + 6 * (width - 2 * border) / 6 + 3);
        }
        int radius = (width - 2 * border) / 18;
        int x = 0;
        while (x < 24) {
            if (!this.p.isFree(x) && x != this.dragStart) {
                g.setColor(this.p.getStone(x).getColor());
                g.fillOval(this.getPosition((int)width, (int)height, (int)border)[x].x - radius, this.getPosition((int)width, (int)height, (int)border)[x].y - radius, 2 * radius, 2 * radius);
            }
            boolean noProposal = true;
            if (this.aktPlayer.getProposalAction() != null) {
                noProposal = false;
                if (this.aktPlayer.getProposalDrop() != null && this.aktPlayer.getProposalDrop().getDestination() == x) {
                    g.setColor(Color.red);
                    g.drawLine(this.getPosition((int)width, (int)height, (int)border)[x].x - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].x + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y + radius / 2);
                    g.drawLine(this.getPosition((int)width, (int)height, (int)border)[x].x - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].x + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y - radius / 2);
                } else if (this.aktPlayer.getProposalAction() instanceof MoveAction && ((MoveAction)this.aktPlayer.getProposalAction()).getSource() == x) {
                    g.setColor(Color.blue);
                    g.drawLine(this.getPosition((int)width, (int)height, (int)border)[x].x - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].x + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y + radius / 2);
                    g.drawLine(this.getPosition((int)width, (int)height, (int)border)[x].x - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].x + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y - radius / 2);
                } else if (this.aktPlayer.getProposalAction().getDestination() == x) {
                    g.setColor(Color.blue);
                    g.fillOval(this.getPosition((int)width, (int)height, (int)border)[x].x - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y - radius / 2, radius, radius);
                }
            }
            if (this.markLastAction && noProposal && x != this.dragStart) {
                if (delAction != null && delAction.getDestination() == x) {
                    g.setColor(Color.red);
                    g.drawLine(this.getPosition((int)width, (int)height, (int)border)[x].x - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].x + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y + radius / 2);
                    g.drawLine(this.getPosition((int)width, (int)height, (int)border)[x].x - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].x + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y - radius / 2);
                } else if (lastAction != null && lastAction instanceof MoveAction && ((MoveAction)lastAction).getSource() == x) {
                    g.setColor(Color.GREEN);
                    g.drawLine(this.getPosition((int)width, (int)height, (int)border)[x].x - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].x + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y + radius / 2);
                    g.drawLine(this.getPosition((int)width, (int)height, (int)border)[x].x - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].x + radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y - radius / 2);
                } else if (lastAction != null && lastAction.getDestination() == x) {
                    g.setColor(Color.green);
                    g.fillOval(this.getPosition((int)width, (int)height, (int)border)[x].x - radius / 2, this.getPosition((int)width, (int)height, (int)border)[x].y - radius / 2, radius, radius);
                }
            }
            ++x;
        }
        if (this.mouseX != -1 && this.mouseY != -1 && this.dragStart != -1) {
            g.setColor(this.p.getStone(this.dragStart).getColor());
            g.fillOval(this.mouseX - radius, this.mouseY - radius, 2 * radius, 2 * radius);
        }
    }

    private Point[] getPosition(int width, int height, int border) {
        Point[] position = new Point[24];
        int feld = width - 2 * border;
        position[0] = new Point(border, border);
        position[1] = new Point(border + feld / 2, border);
        position[2] = new Point(border + feld, border);
        position[3] = new Point(border + feld / 6, border + feld / 6);
        position[4] = new Point(border + feld / 2, border + feld / 6);
        position[5] = new Point(border + feld * 5 / 6, border + feld / 6);
        position[6] = new Point(border + feld / 3, border + feld / 3);
        position[7] = new Point(border + feld / 2, border + feld / 3);
        position[8] = new Point(border + feld * 2 / 3, border + feld / 3);
        position[9] = new Point(border, border + feld / 2);
        position[10] = new Point(border + feld / 6, border + feld / 2);
        position[11] = new Point(border + feld / 3, border + feld / 2);
        position[12] = new Point(border + feld * 2 / 3, border + feld / 2);
        position[13] = new Point(border + feld * 5 / 6, border + feld / 2);
        position[14] = new Point(border + feld, border + feld / 2);
        position[15] = new Point(border + feld / 3, border + feld * 2 / 3);
        position[16] = new Point(border + feld / 2, border + feld * 2 / 3);
        position[17] = new Point(border + feld * 2 / 3, border + feld * 2 / 3);
        position[18] = new Point(border + feld / 6, border + feld * 5 / 6);
        position[19] = new Point(border + feld / 2, border + feld * 5 / 6);
        position[20] = new Point(border + feld * 5 / 6, border + feld * 5 / 6);
        position[21] = new Point(border, border + feld);
        position[22] = new Point(border + feld / 2, border + feld);
        position[23] = new Point(border + feld, border + feld);
        return position;
    }

    public void flipShowCoordinates() {
        this.showCoordinates = !this.showCoordinates;
    }

    public void toPrinter(Graphics g, Dimension page, int resolution) {
        int width = page.width / 2;
        int border = width / 6;
        int height = width;
        g.translate(20, 20);
        g.setColor(new Color(0, 0, 0));
        g.drawLine(border, border, width - border, border);
        g.drawLine(border, width - border, width - border, width - border);
        g.drawLine(border, border, border, width - border);
        g.drawLine(width - border, width - border, width - border, border);
        g.drawLine(border + (width - 2 * border) / 6, border + (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6, border + (width - 2 * border) / 6);
        g.drawLine(border + (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6);
        g.drawLine(border + (width - 2 * border) / 6, border + (width - 2 * border) / 6, border + (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6);
        g.drawLine(border + 5 * (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6, border + 5 * (width - 2 * border) / 6, border + (width - 2 * border) / 6);
        g.drawLine(border + (width - 2 * border) / 3, border + (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3, border + (width - 2 * border) / 3);
        g.drawLine(border + (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3);
        g.drawLine(border + (width - 2 * border) / 3, border + (width - 2 * border) / 3, border + (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3);
        g.drawLine(border + 2 * (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3, border + 2 * (width - 2 * border) / 3, border + (width - 2 * border) / 3);
        g.drawLine(width / 2, border, width / 2, border + (width - 2 * border) / 3);
        g.drawLine(width / 2, border + 2 * (width - 2 * border) / 3, width / 2, width - border);
        g.drawLine(border, width / 2, border + (width - 2 * border) / 3, width / 2);
        g.drawLine(border + 2 * (width - 2 * border) / 3, width / 2, width - border, width / 2);
        if (this.showCoordinates) {
            g.drawString("a", border - 3, border / 2);
            g.drawString("b", border + 1 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("c", border + 2 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("d", border + 3 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("e", border + 4 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("f", border + 5 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("g", border + 6 * (width - 2 * border) / 6 - 3, border / 2);
            g.drawString("1", border / 2, border + 3);
            g.drawString("2", border / 2, border + 1 * (width - 2 * border) / 6 + 3);
            g.drawString("3", border / 2, border + 2 * (width - 2 * border) / 6 + 3);
            g.drawString("4", border / 2, border + 3 * (width - 2 * border) / 6 + 3);
            g.drawString("5", border / 2, border + 4 * (width - 2 * border) / 6 + 3);
            g.drawString("6", border / 2, border + 5 * (width - 2 * border) / 6 + 3);
            g.drawString("7", border / 2, border + 6 * (width - 2 * border) / 6 + 3);
        }
        int x = 0;
        while (x < 24) {
            int radius = (width - 2 * border) / 18;
            if (!this.p.isFree(x)) {
                g.setColor(this.p.getStone(x).getColor());
                g.fillOval(this.getPosition((int)width, (int)height, (int)border)[x].x - radius, this.getPosition((int)width, (int)height, (int)border)[x].y - radius, 2 * radius, 2 * radius);
                g.setColor(new Color(0, 0, 0));
                g.drawOval(this.getPosition((int)width, (int)height, (int)border)[x].x - radius, this.getPosition((int)width, (int)height, (int)border)[x].y - radius, 2 * radius, 2 * radius);
            }
            ++x;
        }
        int c = 1;
        int zeile = 0;
        int spalte = 0;
        int abstand = 18;
        int i = 0;
        while (i < this.p.getActions().size()) {
            String zug = ((Action)this.p.getActions().get(i)).toString();
            if (i + 1 < this.p.getActions().size() && ((Action)this.p.getActions().get(i + 1)).toString().startsWith("x")) {
                zug = String.valueOf(zug) + " " + ((Action)this.p.getActions().get(++i)).toString();
            }
            g.setColor(new Color(255 * c, 255 * c, 255 * c));
            g.fillOval(width + 15 + 80 * spalte, border + abstand * zeile, 8, 8);
            g.setColor(Color.black);
            g.drawOval(width + 15 + 80 * spalte, border + abstand * zeile, 8, 8);
            g.drawString(zug, width + 30 + 80 * spalte, border + 9 + abstand * zeile);
            c = 1 - c;
            if (++zeile > 10 && zeile % ((this.p.getActions().size() + 2) / 3) == 0) {
                ++spalte;
                zeile = 0;
            }
            ++i;
        }
        g.setFont(new Font("arial", 1, 13));
        g.drawString("Spielz\u00fcge", width + 15, border / 2);
    }
}

