/*
 * Decompiled with CFR 0.152.
 */
package muehle.gui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import muehle.player.NetPlayer;
import muehle.player.Player;

public class StatusPanel
extends JPanel {
    private TextArea area;
    private TextField msgArea;
    private Button send;
    private Player p1;
    private Player p2;

    public StatusPanel(Player player1, Player player2) {
        this.setBackground(new Color(180, 145, 90));
        this.setLayout(new BorderLayout());
        String infotext = "";
        this.p1 = player1;
        this.p2 = player2;
        this.msgArea = new TextField("", 20);
        this.msgArea.setBackground(new Color(220, 220, 220));
        this.msgArea.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (!StatusPanel.this.msgArea.getText().equals("") && e.getKeyCode() == 10 && !StatusPanel.this.msgArea.getText().equals("")) {
                    StatusPanel.this.sendMsg();
                }
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.send = new Button("  Die Nachricht senden!  ");
        this.send.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!StatusPanel.this.msgArea.getText().equals("")) {
                    StatusPanel.this.sendMsg();
                }
            }
        });
        this.area = new TextArea(infotext, 5, 40, 1);
        this.area.setBackground(new Color(180, 145, 90));
        this.area.setForeground(Color.BLACK);
        this.area.setEditable(false);
        this.add(this.area);
    }

    private void sendMsg() {
        String sender = this.p1 instanceof NetPlayer ? this.p2.getName() : this.p1.getName();
        this.setText("Nachricht von " + sender + ": " + this.msgArea.getText());
        this.p1.notice("MSG," + this.msgArea.getText());
        this.p2.notice("MSG," + this.msgArea.getText());
        this.msgArea.setText("");
    }

    public void setText(String infotext) {
        if (!infotext.startsWith("x") && !this.area.getText().equals("")) {
            this.area.append("\n");
        }
        this.area.append(String.valueOf(infotext) + " ");
        this.validate();
    }

    public void showMsgArea() {
        this.add((Component)this.msgArea, "North");
        this.add((Component)this.send, "East");
    }
}

