/*
 * Decompiled with CFR 0.152.
 */
package muehle.logic;

import muehle.logic.Action;
import muehle.logic.Position;
import muehle.logic.UndoMoveAction;
import muehle.player.Player;

public class MoveAction
extends Action {
    protected int source;

    public MoveAction() {
    }

    public MoveAction(Player p, int destination, int source) {
        super(p, destination);
        this.source = source;
        this.undoAction = new UndoMoveAction(this.player, source, destination);
    }

    public int getSource() {
        return this.source;
    }

    public String toNetString() {
        return "M," + this.destination + "," + this.source;
    }

    public String toString() {
        return String.valueOf(Position.toString(this.source)) + "-" + Position.toString(this.destination);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MoveAction)) {
            return false;
        }
        MoveAction otherMovAction = (MoveAction)o;
        if (this.player != otherMovAction.getPlayer()) {
            return false;
        }
        if (this.destination != otherMovAction.getDestination()) {
            return false;
        }
        return this.source == otherMovAction.getSource();
    }

    public int getActionValue() {
        return Position.getValue(this.destination) - Position.getValue(this.source);
    }

    public void setSource(int source) {
        this.source = source;
    }
}

