/*
 * Decompiled with CFR 0.152.
 */
package muehle.player;

import java.util.ArrayList;
import java.util.Random;
import mln.NeuralNetwork;
import mln.NeuralNetworkReadingException;
import muehle.logic.Action;
import muehle.logic.Playground;
import muehle.logic.Stone;
import muehle.player.Player;
import muehle.thinking.CombinedHeuristic;
import muehle.thinking.EvaluatedAction;
import muehle.thinking.Heuristic;
import muehle.thinking.Minmax;
import muehle.thinking.QuadraticFeatureHeuristic;
import muehle.thinking.QuiescentSearch;
import muehle.thinking.SimpleHeuristic;
import muehle.thinking.SmallHeuristic;
import muehle.thinking.StandardHeuristic;
import muehle.thinking.VerySmallHeuristic;

public class ComputerPlayer
extends Player {
    protected EvaluatedAction bestAction;
    protected Heuristic heuristic;
    protected boolean verbose;
    protected boolean useTimeToBreak;
    protected int timeToThink;
    protected int depthToThink;
    protected QuiescentSearch qs;

    public ComputerPlayer(String name, Stone s) {
        this(name, s, "Heuristic/standard.xml");
    }

    public ComputerPlayer(String name, Stone s, String filenameOfHeuristic) {
        block8: {
            super(name, s);
            this.useTimeToBreak = true;
            this.verbose = false;
            this.timeToThink = 5000;
            this.depthToThink = 6;
            this.qs = QuiescentSearch.noQuiescentSearch();
            try {
                NeuralNetwork nn = NeuralNetwork.readFromFile(filenameOfHeuristic);
                if (nn.getNumberOfInputs() == StandardHeuristic.NUMBER_OF_FEATURES) {
                    this.heuristic = new StandardHeuristic(nn);
                    System.out.println("Heuristik " + filenameOfHeuristic + " wird verwendet!");
                    break block8;
                }
                if (nn.getNumberOfInputs() == SmallHeuristic.NUMBER_OF_FEATURES) {
                    this.heuristic = new SmallHeuristic(nn);
                    System.out.println("Heuristik " + filenameOfHeuristic + " wird verwendet!");
                    break block8;
                }
                if (nn.getNumberOfInputs() == VerySmallHeuristic.NUMBER_OF_FEATURES) {
                    this.heuristic = new VerySmallHeuristic(nn);
                    System.out.println("Heuristik " + filenameOfHeuristic + " wird verwendet!");
                    break block8;
                }
                if (nn.getNumberOfInputs() == SimpleHeuristic.NUMBER_OF_FEATURES) {
                    this.heuristic = new SimpleHeuristic(nn);
                    System.out.println("Heuristik " + filenameOfHeuristic + " wird verwendet!");
                    break block8;
                }
                if (nn.getNumberOfInputs() == QuadraticFeatureHeuristic.NUMBER_OF_FEATURES) {
                    this.heuristic = new QuadraticFeatureHeuristic(nn);
                    System.out.println("Heuristik " + filenameOfHeuristic + " wird verwendet!");
                    break block8;
                }
                if (nn.getNumberOfInputs() == CombinedHeuristic.NUMBER_OF_FEATURES) {
                    this.heuristic = new CombinedHeuristic(nn);
                    System.out.println("Heuristik " + filenameOfHeuristic + " wird verwendet!");
                    break block8;
                }
                throw new NeuralNetworkReadingException(filenameOfHeuristic);
            }
            catch (NeuralNetworkReadingException e) {
                System.out.println("Neue Zufalls-Heuristik wird verwendet.");
                this.heuristic = Heuristic.randomSingleLayerHeuristic();
            }
        }
    }

    public ComputerPlayer(String name, Stone s, Heuristic h) {
        super(name, s);
        this.useTimeToBreak = true;
        this.verbose = false;
        this.timeToThink = 5000;
        this.depthToThink = 6;
        this.qs = QuiescentSearch.noQuiescentSearch();
        this.heuristic = h;
    }

    public void makeMove(Playground p) {
        this.calculateBestAction(p);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Action move = this.bestAction.getMove();
        if (p.execute(move)) {
            this.soundPlayback(1);
            this.appendLastAction(move);
            this.informOpponent(move);
        } else {
            System.out.println("Computer hat illegalen Zug gemacht => du kommst hier nicht mehr weiter :(");
            this.makeMove(p);
        }
    }

    public EvaluatedAction calculateBestAction(Playground p) {
        Player clone = this.getClone();
        Player cloneOpp = this.getOpponent().getClone();
        clone.setOpponent(cloneOpp);
        cloneOpp.setOpponent(clone);
        if (!this.useTimeToBreak) {
            this.timeToThink = Integer.MAX_VALUE;
        }
        Minmax think = new Minmax(p, clone, this.heuristic, this.timeToThink);
        long thinktime = think.getTimeUsed();
        ArrayList bestActions = think.getBestActions();
        int depth = 2;
        while (true) {
            ArrayList evaluatedActions = think.getActions();
            if (think.gameAlreadyOver() || this.isEndgame() || !this.useTimeToBreak && depth > this.depthToThink || this.useTimeToBreak && (double)thinktime > (double)this.timeToThink / 2.5 || !(think = new Minmax(p, clone, depth, evaluatedActions, this.heuristic, this.qs, (long)this.timeToThink - thinktime)).isThinkReady()) break;
            bestActions = think.getBestActions();
            thinktime += think.getTimeUsed();
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            ++depth;
        }
        this.time += thinktime;
        int nodeCounter = think.getNodeCounter();
        int maximalDepth = --depth - think.getMinimumDepthReached();
        Random rnd = new Random();
        int zufall = rnd.nextInt(bestActions.size());
        this.bestAction = (EvaluatedAction)bestActions.get(zufall);
        if (this.verbose) {
            if (this.isEndgame()) {
                System.out.println("Endspieldatenbank: ");
                System.out.println("Zeit: " + think.getTimeUsed() + " ms");
                System.out.println("Spieleinsch\u00e4tzung: " + this.bestAction.getValue());
                System.out.println("******************************************************");
            } else {
                System.out.println("Ebenen: " + depth + "   Maximal: " + maximalDepth);
                System.out.println("Zeit: " + thinktime + " ms");
                System.out.println("Anzahl beste:: " + bestActions.size());
                System.out.println("Knoten durchsucht: " + nodeCounter);
                System.out.println("Spieleinsch\u00e4tzung: " + this.bestAction.getValue());
                double[] nnOutput = this.heuristic.getNNOutputs(p, clone);
                System.out.println("NetworkOutput: [" + nnOutput[0] + "], [" + nnOutput[1] + "], [" + nnOutput[2] + "]");
                System.out.println("******************************************************");
            }
        }
        this.bestAction.getMove().setPlayer(this);
        if (this.bestAction.getDrop() != null) {
            this.bestAction.getDrop().setPlayer(this.getOpponent());
        }
        return this.bestAction;
    }

    public void deleteStone(Playground p) {
        if (p.execute(this.bestAction.getDrop())) {
            this.appendLastAction(this.bestAction.getDrop());
            this.informOpponent(this.bestAction.getDrop());
        } else {
            this.deleteStone(p);
            System.out.println("Computer hat illegalen Drop gemacht => du kommst hier nicht mehr weiter :(");
        }
    }

    public void setTimeToThink(int power) {
        this.timeToThink = power;
    }

    public int getTimeToThink() {
        return this.timeToThink;
    }

    public int getDepthToThink() {
        return this.depthToThink;
    }

    public void setDepthToThink(int depthToThink) {
        this.depthToThink = depthToThink;
    }

    public boolean isUseTimeToBreak() {
        return this.useTimeToBreak;
    }

    public void setUseTimeToBreak(boolean useTimeToBreak) {
        this.useTimeToBreak = useTimeToBreak;
    }

    public Player getClone() {
        ComputerPlayer temp = new ComputerPlayer(this.name, this.s, this.heuristic);
        temp.setNumberOfStones(this.numberOfStones);
        temp.setNumberOfInitStones(this.initStones);
        temp.setUseTimeToBreak(this.useTimeToBreak);
        temp.setTimeToThink(this.timeToThink);
        temp.setDepthToThink(this.depthToThink);
        temp.setQs(this.qs);
        temp.setVerbose(this.verbose);
        temp.setOpponent(this.opponent);
        return temp;
    }

    public void setQs(QuiescentSearch qs2) {
        this.qs = qs2;
    }

    public boolean acceptDraw(Playground p) {
        if (this.bestAction == null) {
            return true;
        }
        if (this.bestAction.getValue() == 0.0) {
            return true;
        }
        return this.bestAction.getValue() - (double)p.getActions().size() * 0.01 < -0.5;
    }

    public boolean isEndgame() {
        return !this.canSet() && this.getNumberOfStones() + this.getOpponent().getNumberOfStones() <= 8;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Heuristic getHeuristic() {
        return this.heuristic;
    }

    public void setHeuristic(Heuristic h) {
        this.heuristic = h;
    }

    public double getEvaluatedValueOfPlayground() {
        return this.bestAction.getValue();
    }

    public double getRandomRadius() {
        return this.heuristic.getRandomRadius();
    }

    public void setRandomRadius(double randomRadius) {
        this.heuristic.setRandomRadius(randomRadius);
    }

    public double getLambda() {
        return 0.0;
    }

    public void setLambda(double lambda) {
    }

    public String toString() {
        String output = super.toString();
        output = this.isUseTimeToBreak() ? String.valueOf(output) + ", TimeToThink: " + this.getTimeToThink() : String.valueOf(output) + ", DepthToThink: " + this.getDepthToThink();
        output = String.valueOf(output) + ", Random-Radius: " + this.getRandomRadius();
        return output;
    }

    public QuiescentSearch getQs() {
        return this.qs;
    }
}

