/*
 * Decompiled with CFR 0.152.
 */
package muehle.player;

import java.applet.AudioClip;
import java.util.ArrayList;
import muehle.gui.StatusPanel;
import muehle.logic.Action;
import muehle.logic.DeleteAction;
import muehle.logic.MoveAction;
import muehle.logic.Playground;
import muehle.logic.SetAction;
import muehle.logic.Stone;
import muehle.player.NetClientPlayer;
import muehle.player.NetServerPlayer;

public class Player {
    protected String name;
    protected Stone s;
    protected int numberOfStones;
    protected int initStones;
    protected ArrayList actions;
    protected Player opponent;
    protected Thread play;
    protected long time;
    protected static AudioClip[] clip;
    private static boolean soundOn;
    private SetAction[] setActions;
    private DeleteAction[] deleteActions;
    private MoveAction[][] moveActions;
    protected boolean gestoppt = false;

    static {
        soundOn = true;
    }

    public Player(String name, Stone s) {
        this.name = name;
        this.s = s;
        this.actions = new ArrayList();
        this.setActions = this.generateSetActions();
        this.moveActions = this.generateMoveActions();
        this.deleteActions = this.generateDeleteActions();
        this.reset();
    }

    public static void setAudio(AudioClip[] ac) {
        clip = ac;
    }

    public static void flipSound() {
        soundOn = !soundOn;
    }

    private SetAction[] generateSetActions() {
        SetAction[] allSetActions = new SetAction[24];
        int i = 0;
        while (i < 24) {
            allSetActions[i] = new SetAction(this, i);
            ++i;
        }
        return allSetActions;
    }

    private DeleteAction[] generateDeleteActions() {
        DeleteAction[] allDeleteActions = new DeleteAction[24];
        int i = 0;
        while (i < 24) {
            allDeleteActions[i] = new DeleteAction(this, i);
            ++i;
        }
        return allDeleteActions;
    }

    private MoveAction[][] generateMoveActions() {
        MoveAction[][] allMoveActions = new MoveAction[24][24];
        int destination = 0;
        while (destination < 24) {
            int source = 0;
            while (source < 24) {
                allMoveActions[destination][source] = new MoveAction(this, destination, source);
                ++source;
            }
            ++destination;
        }
        return allMoveActions;
    }

    public SetAction getSetAction(int destination) {
        return this.setActions[destination];
    }

    public DeleteAction getDeleteAction(int destination) {
        return this.deleteActions[destination];
    }

    public MoveAction getMoveAction(int destination, int source) {
        return this.moveActions[destination][source];
    }

    public Stone getStone() {
        return this.s;
    }

    public Action getLastAction() {
        if (this.actions.size() > 0) {
            return (Action)this.actions.get(this.actions.size() - 1);
        }
        return null;
    }

    public ArrayList getAllLastActions() {
        return this.actions;
    }

    public boolean canSet() {
        return this.initStones > 0;
    }

    public boolean canJump() {
        return this.numberOfStones < 4 && this.initStones < 1;
    }

    public boolean hasLostByStones() {
        return this.numberOfStones < 3 && this.initStones < 1;
    }

    public String getType() {
        return this.getClass().getName();
    }

    public String getName() {
        return this.name;
    }

    public Player getOpponent() {
        return this.opponent;
    }

    public int getNumberOfStones() {
        return this.numberOfStones;
    }

    public void setStone(Stone s) {
        this.s = s;
    }

    public int getNumberOfInitStones() {
        return this.initStones;
    }

    public void setNumberOfInitStones(int initStones) {
        this.initStones = initStones;
    }

    public void setNumberOfStones(int numberStones) {
        this.numberOfStones = numberStones;
    }

    public void incrementInitStones() {
        ++this.initStones;
    }

    public void decrementInitStones() {
        --this.initStones;
    }

    public void incrementStones() {
        ++this.numberOfStones;
    }

    public void decrementStones() {
        --this.numberOfStones;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOpponent(Player p) {
        this.opponent = p;
    }

    public void appendLastAction(Action a) {
        this.actions.add(a);
    }

    public void informOpponent(Action a) {
        if (this.getOpponent() instanceof NetClientPlayer || this.getOpponent() instanceof NetServerPlayer) {
            this.getOpponent().notice(this.getLastAction().toNetString());
        }
    }

    protected void stopGameThread() {
        try {
            this.gestoppt = true;
            Thread thread = this.play;
            synchronized (thread) {
                while (this.gestoppt && !this.play.isInterrupted()) {
                    this.play.wait();
                }
            }
        }
        catch (Exception e) {
            this.play.interrupt();
        }
    }

    public void soundPlayback(int i) {
        if (soundOn) {
            clip[i].play();
        }
    }

    public String toString() {
        String output = "Name: " + this.getName() + ", Stone: " + this.getStone().getSign() + ", InitStones: " + this.initStones + " Stones: " + this.numberOfStones;
        if (this.canSet()) {
            output = String.valueOf(output) + ", CanSet ";
        }
        if (this.canJump()) {
            output = String.valueOf(output) + ", CanJump ";
        }
        return output;
    }

    public void reset() {
        this.numberOfStones = 0;
        this.initStones = 9;
        this.actions.clear();
    }

    public Player getClone() {
        return null;
    }

    public void notice(String note) {
    }

    public int connect() {
        return 0;
    }

    public void disconnect() {
    }

    public void setHost(String s) {
    }

    public void setPort(int port) {
    }

    public void makeMove(Playground p) {
    }

    public void deleteStone(Playground p) {
    }

    public void pressedAt(int source) {
    }

    public void releasedAt(int destination) {
    }

    public void setTimeToThink(int power) {
    }

    public String receiveMsg() {
        return "";
    }

    public void setVerbose(boolean verbose) {
    }

    public int getTimeToThink() {
        return 0;
    }

    public boolean acceptDraw(Playground p) {
        return false;
    }

    public Action getProposalAction() {
        return null;
    }

    public Action getProposalDrop() {
        return null;
    }

    public long getTimeUsedByPlayer() {
        return this.time;
    }

    public void learningPhase(double outcome, boolean save) {
    }

    public void saveFeatures(Playground p, Player aktPlayer) {
    }

    public void clearFeatures() {
    }

    public int getDepthToThink() {
        return 0;
    }

    public void setDepthToThink(int depthToThink) {
    }

    public boolean isUseTimeToBreak() {
        return true;
    }

    public void setUseTimeToBreak(boolean useTimeToBreak) {
    }

    public void getThread(Thread play) {
    }

    public void getStatusPanel(StatusPanel sp) {
    }
}

