/*
 * Decompiled with CFR 0.152.
 */
package muehle.thinking;

import java.util.BitSet;
import mln.NeuralNetwork;
import muehle.logic.Playground;
import muehle.logic.Stone;
import muehle.player.Player;
import muehle.thinking.Heuristic;
import muehle.thinking.StandardHeuristic;

public class CombinedHeuristic
extends Heuristic {
    public static int NUMBER_OF_FEATURES = 88;

    public CombinedHeuristic(NeuralNetwork nn) {
        super(nn);
    }

    public BitSet generateFeatures(Playground p, Player aktPlayer) {
        int situationValueDifference;
        int oppPlayerMovementPossibilities;
        int aktPlayerMovementPossibilities;
        int oppPlayerStones;
        BitSet result = new BitSet(88);
        BitSet bs1 = new BitSet(24);
        BitSet bs2 = new BitSet(24);
        if (aktPlayer.getStone() == Stone.O) {
            bs1 = p.getStones()[0];
            bs2 = p.getStones()[1];
        }
        if (aktPlayer.getStone() == Stone.X) {
            bs1 = p.getStones()[1];
            bs2 = p.getStones()[0];
        }
        result.or(bs1);
        int i = bs2.nextSetBit(0);
        while (i >= 0) {
            result.set(i + 24);
            i = bs2.nextSetBit(i + 1);
        }
        result.set(48, aktPlayer.canSet());
        Player oppPlayer = aktPlayer.getOpponent();
        BitSet features = new BitSet(StandardHeuristic.NUMBER_OF_FEATURES);
        int aktPlayerStones = aktPlayer.getNumberOfStones();
        if (aktPlayerStones == 4) {
            features.set(0);
        }
        if (aktPlayerStones == 5) {
            features.set(1);
        }
        if (aktPlayerStones == 6) {
            features.set(2);
        }
        if (aktPlayerStones == 7) {
            features.set(3);
        }
        if (aktPlayerStones == 8) {
            features.set(4);
        }
        if (aktPlayerStones == 9) {
            features.set(5);
        }
        if ((oppPlayerStones = oppPlayer.getNumberOfStones()) == 4) {
            features.set(6);
        }
        if (oppPlayerStones == 5) {
            features.set(7);
        }
        if (oppPlayerStones == 6) {
            features.set(8);
        }
        if (oppPlayerStones == 7) {
            features.set(9);
        }
        if (oppPlayerStones == 8) {
            features.set(10);
        }
        if (oppPlayerStones == 9) {
            features.set(11);
        }
        if ((aktPlayerMovementPossibilities = p.getNumberOfPlayersMoveActions(aktPlayer)) == 2 || aktPlayerMovementPossibilities == 3) {
            features.set(12);
        }
        if (aktPlayerMovementPossibilities == 4 || aktPlayerMovementPossibilities == 5) {
            features.set(13);
        }
        if (aktPlayerMovementPossibilities == 6 || aktPlayerMovementPossibilities == 7) {
            features.set(14);
        }
        if (aktPlayerMovementPossibilities == 8 || aktPlayerMovementPossibilities == 9) {
            features.set(15);
        }
        if (aktPlayerMovementPossibilities >= 10) {
            features.set(16);
        }
        if ((oppPlayerMovementPossibilities = p.getNumberOfPlayersMoveActions(oppPlayer)) == 2 || oppPlayerMovementPossibilities == 3) {
            features.set(17);
        }
        if (oppPlayerMovementPossibilities == 4 || oppPlayerMovementPossibilities == 5) {
            features.set(18);
        }
        if (oppPlayerMovementPossibilities == 6 || oppPlayerMovementPossibilities == 7) {
            features.set(19);
        }
        if (oppPlayerMovementPossibilities == 8 || oppPlayerMovementPossibilities == 9) {
            features.set(20);
        }
        if (oppPlayerMovementPossibilities >= 10) {
            features.set(21);
        }
        int[] aktPlayerMuehles = p.countMuehlen(aktPlayer);
        int[] oppPlayerMuehles = p.countMuehlen(oppPlayer);
        if (aktPlayerMuehles[0] == 1) {
            features.set(22);
        }
        if (aktPlayerMuehles[0] >= 2) {
            features.set(23);
        }
        if (oppPlayerMuehles[0] == 1) {
            features.set(24);
        }
        if (oppPlayerMuehles[0] >= 2) {
            features.set(25);
        }
        if (aktPlayerMuehles[1] == 1) {
            features.set(26);
        }
        if (aktPlayerMuehles[1] >= 2) {
            features.set(27);
        }
        if (oppPlayerMuehles[1] == 1) {
            features.set(28);
        }
        if (oppPlayerMuehles[1] >= 2) {
            features.set(29);
        }
        if ((situationValueDifference = p.getSituationValue(aktPlayer.getStone()) - p.getSituationValue(oppPlayer.getStone())) <= -7) {
            features.set(30);
        }
        if (situationValueDifference == -4 || situationValueDifference == -5 || situationValueDifference == -6) {
            features.set(31);
        }
        if (situationValueDifference == -2 || situationValueDifference == -3) {
            features.set(32);
        }
        if (situationValueDifference == -1) {
            features.set(33);
        }
        if (situationValueDifference == 0) {
            features.set(34);
        }
        if (situationValueDifference == 1) {
            features.set(35);
        }
        if (situationValueDifference == 2 || situationValueDifference == 3) {
            features.set(36);
        }
        if (situationValueDifference == 4 || situationValueDifference == 5 || situationValueDifference == 6) {
            features.set(37);
        }
        if (situationValueDifference >= 7) {
            features.set(38);
        }
        int i2 = features.nextSetBit(0);
        while (i2 >= 0) {
            result.set(i2 + 49);
            i2 = features.nextSetBit(i2 + 1);
        }
        return result;
    }
}

