/*
 * Decompiled with CFR 0.152.
 */
package muehle.thinking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import muehle.logic.Action;
import muehle.logic.DeleteAction;
import muehle.logic.Playground;
import muehle.player.Player;
import muehle.thinking.EvaluatedAction;
import muehle.thinking.HashEntry;
import muehle.thinking.Heuristic;
import muehle.thinking.QuiescentSearch;

public class Minmax {
    private Playground playground;
    private QuiescentSearch q;
    private ArrayList evaluatedActions;
    private Heuristic heuristik;
    private Player maxPlayer;
    private Player minPlayer;
    private static Hashtable hash = new Hashtable(300000);
    private int maximumDepth;
    private int nodeCounter = 0;
    private long timeUsed;
    private long timeBegin = System.currentTimeMillis();
    private long timeToThink;
    private boolean thinkReady = true;
    private int minimumDepthReached = 0;
    public static final double WIN_VALUE = 1.0;
    public static final double LOSS_VALUE = -1.0;
    public static final double POSITIVE_ZERO = 1.0E-10;

    public Minmax(Playground p, Player player, Heuristic h, long timeToThink) {
        this.timeToThink = timeToThink;
        this.evaluatedActions = new ArrayList();
        this.heuristik = h;
        this.playground = p.getClone();
        this.maxPlayer = player;
        this.minPlayer = player.getOpponent();
        this.maximumDepth = 2;
        this.evaluatedActions = this.getSortedActions(this.maxPlayer, this.playground);
        this.timeUsed = System.currentTimeMillis() - this.timeBegin;
    }

    public Minmax(Playground p, Player player, int depth, ArrayList initialActions, Heuristic h, QuiescentSearch q, long timeToThink) {
        this.timeToThink = timeToThink;
        this.maximumDepth = depth;
        this.evaluatedActions = new ArrayList();
        this.heuristik = h;
        this.playground = p.getClone();
        this.maxPlayer = player;
        this.minPlayer = player.getOpponent();
        this.q = q;
        hash.clear();
        Iterator it = initialActions.iterator();
        double alpha = -1.0;
        double beta = 1.0;
        while (it.hasNext()) {
            if (!this.thinkReady) {
                return;
            }
            EvaluatedAction ea = (EvaluatedAction)it.next();
            Action move = ea.getMove();
            this.playground.executeProofed(move);
            double aktval = 0.0;
            if (this.playground.isMuehle(move) && this.playground.hasFreeStones(this.minPlayer.getStone())) {
                DeleteAction drop = ea.getDrop();
                this.playground.executeProofed(drop);
                aktval = -this.alphaBeta(depth - 2, -beta, -alpha);
                ++this.nodeCounter;
                if (aktval == beta) {
                    aktval = -this.alphaBeta(depth - 2, -1.0, -alpha);
                }
                alpha = Math.max(alpha, aktval - 1.0E-10);
                beta = alpha + 2.0E-10;
                this.evaluatedActions.add(new EvaluatedAction(aktval, move, drop));
                this.playground.executeProofed(drop.getUndoAction());
            } else {
                aktval = -this.alphaBeta(depth - 2, -beta, -alpha);
                if (aktval == beta) {
                    aktval = -this.alphaBeta(depth - 2, -1.0, -alpha);
                }
                alpha = Math.max(alpha, aktval - 1.0E-10);
                beta = alpha + 2.0E-10;
                ++this.nodeCounter;
                this.evaluatedActions.add(new EvaluatedAction(aktval, move));
            }
            this.playground.executeProofed(move.getUndoAction());
            if (aktval >= 1.0) break;
        }
        Collections.sort(this.evaluatedActions);
        this.timeUsed = System.currentTimeMillis() - this.timeBegin;
        this.thinkReady = true;
    }

    public double alphaBeta(int depth, double alpha, double beta) {
        Action action;
        Player aktPlayer;
        if (!this.thinkReady) {
            return 0.0;
        }
        this.timeUsed = System.currentTimeMillis() - this.timeBegin;
        if (this.timeUsed > this.timeToThink) {
            this.thinkReady = false;
            return 0.0;
        }
        ++this.nodeCounter;
        byte hashf = HashEntry.HE_ALPHA;
        double val = 0.0;
        Player player = aktPlayer = (this.maximumDepth - depth) % 2 == 0 ? this.minPlayer : this.maxPlayer;
        if (hash.containsKey(this.playground)) {
            HashEntry he = (HashEntry)hash.get(this.playground);
            byte typeOfHashedValue = he.getType();
            double hashedValue = he.getValue();
            if (he.getDepth() == depth) {
                if (typeOfHashedValue == HashEntry.HE_EXACT) {
                    return hashedValue;
                }
                if (typeOfHashedValue == HashEntry.HE_ALPHA) {
                    if (hashedValue <= alpha) {
                        return alpha;
                    }
                    if (hashedValue < beta) {
                        beta = hashedValue;
                    }
                } else if (typeOfHashedValue == HashEntry.HE_BETA) {
                    if (hashedValue >= beta) {
                        return beta;
                    }
                    if (hashedValue > alpha) {
                        alpha = hashedValue;
                    }
                }
            }
        }
        if (aktPlayer.hasLostByStones() || !this.playground.hasActions(aktPlayer)) {
            return -1.0 + (double)(this.maximumDepth - depth - 2) * 1.0E-10;
        }
        if (depth == -this.q.getQuiescentDepth()) {
            val = this.heuristik.evaluate(this.playground, aktPlayer);
            hash.put(this.playground, new HashEntry(val, HashEntry.HE_EXACT, depth));
            if (depth < this.minimumDepthReached) {
                this.minimumDepthReached = depth;
            }
            return val;
        }
        ArrayList actions = null;
        if (depth <= 0) {
            val = this.heuristik.evaluate(this.playground, aktPlayer);
            actions = this.q.getStillingActions(this.playground, aktPlayer);
            if (actions.isEmpty()) {
                hash.put(this.playground, new HashEntry(val, HashEntry.HE_EXACT, depth));
                if (depth < this.minimumDepthReached) {
                    this.minimumDepthReached = depth;
                }
                return val;
            }
            if (val >= beta) {
                return beta;
            }
            if (val - 0.1 > alpha) {
                alpha = val - 0.1;
            }
        }
        Iterator it = actions == null ? this.playground.getPlayersActions(aktPlayer).iterator() : actions.iterator();
        boolean opponentHasFreestones = this.playground.hasFreeStones(aktPlayer.getOpponent().getStone());
        ArrayList<Action> muehlenList = new ArrayList<Action>();
        ArrayList<Action> noMuehlenList = new ArrayList<Action>();
        int muehlenCounter = 0;
        while (it.hasNext()) {
            action = (Action)it.next();
            this.playground.executeProofed(action);
            if (this.playground.isMuehle(action) && opponentHasFreestones) {
                muehlenList.add(action);
                ++muehlenCounter;
            } else {
                noMuehlenList.add(action);
            }
            this.playground.executeProofed(action.getUndoAction());
        }
        muehlenList.addAll(noMuehlenList);
        it = muehlenList.iterator();
        while (it.hasNext()) {
            action = (Action)it.next();
            this.playground.executeProofed(action);
            if (muehlenCounter > 0) {
                --muehlenCounter;
                ArrayList freeStones = this.playground.getPlayersFreeStones(aktPlayer.getOpponent().getStone());
                int listLength = freeStones.size();
                int i = 0;
                while (i < listLength) {
                    int freeStone = (Integer)freeStones.get(i);
                    DeleteAction delAction = aktPlayer.getOpponent().getDeleteAction(freeStone);
                    this.playground.executeProofed(delAction);
                    val = -this.alphaBeta(depth - 1, -beta, -alpha);
                    this.playground.executeProofed(delAction.getUndoAction());
                    if (val >= beta) {
                        this.playground.executeProofed(action.getUndoAction());
                        hash.put(this.playground, new HashEntry(beta, HashEntry.HE_BETA, depth));
                        return beta;
                    }
                    if (val > alpha) {
                        hashf = HashEntry.HE_EXACT;
                        alpha = val;
                    }
                    ++i;
                }
            } else {
                val = -this.alphaBeta(depth - 1, -beta, -alpha);
            }
            this.playground.executeProofed(action.getUndoAction());
            if (val >= beta) {
                hash.put(this.playground, new HashEntry(beta, HashEntry.HE_BETA, depth));
                return beta;
            }
            if (!(val > alpha)) continue;
            hashf = HashEntry.HE_EXACT;
            alpha = val;
        }
        hash.put(this.playground, new HashEntry(alpha, hashf, depth));
        return alpha;
    }

    private ArrayList getSortedActions(Player aktPlayer, Playground p) {
        Player opponent = aktPlayer.getOpponent();
        ArrayList<EvaluatedAction> evaluatedActions = new ArrayList<EvaluatedAction>();
        ArrayList playerMoves = p.getPlayersActions(aktPlayer);
        Iterator it = playerMoves.iterator();
        while (it.hasNext()) {
            double aktval;
            Action action = (Action)it.next();
            this.playground.executeProofed(action);
            if (this.playground.isMuehle(action) && this.playground.hasFreeStones(opponent.getStone())) {
                ArrayList list = this.playground.getPlayersFreeStones(opponent.getStone());
                int i = 0;
                while (i < list.size()) {
                    int freeStone = (Integer)list.get(i);
                    DeleteAction delAction = opponent.getDeleteAction(freeStone);
                    this.playground.executeProofed(delAction);
                    aktval = opponent.hasLostByStones() || !this.playground.hasActions(opponent) ? 1.0 : -this.heuristik.evaluate(p, opponent);
                    evaluatedActions.add(new EvaluatedAction(aktval, action, delAction));
                    this.playground.executeProofed(delAction.getUndoAction());
                    ++i;
                }
            } else {
                aktval = !this.playground.hasActions(opponent) ? 1.0 : -this.heuristik.evaluate(p, opponent);
                evaluatedActions.add(new EvaluatedAction(aktval, action));
            }
            this.playground.executeProofed(action.getUndoAction());
        }
        Collections.sort(evaluatedActions);
        return evaluatedActions;
    }

    public double getBestValue() {
        return ((EvaluatedAction)this.evaluatedActions.get(0)).getValue();
    }

    public ArrayList getBestActions() {
        double bestValue = this.getBestValue();
        ArrayList<EvaluatedAction> bestActions = new ArrayList<EvaluatedAction>();
        int i = 0;
        while (i < this.evaluatedActions.size()) {
            EvaluatedAction ea = (EvaluatedAction)this.evaluatedActions.get(i);
            if (ea.getValue() != bestValue) {
                return bestActions;
            }
            bestActions.add(ea);
            ++i;
        }
        return bestActions;
    }

    public ArrayList getActions() {
        return this.evaluatedActions;
    }

    public int getNodeCounter() {
        return this.nodeCounter;
    }

    public long getTimeUsed() {
        return this.timeUsed;
    }

    public int getMinimumDepthReached() {
        return this.minimumDepthReached;
    }

    public boolean gameAlreadyOver() {
        double bestValue = ((EvaluatedAction)this.evaluatedActions.get(0)).getValue();
        return bestValue >= 0.999999995 || bestValue <= -0.999999995;
    }

    public boolean isThinkReady() {
        return this.thinkReady;
    }
}

