/*
 * Decompiled with CFR 0.152.
 */
package muehle.thinking;

import java.util.BitSet;
import mln.NeuralNetwork;
import muehle.logic.Playground;
import muehle.player.Player;
import muehle.thinking.Heuristic;
import muehle.thinking.StandardHeuristic;

public class QuadraticFeatureHeuristic
extends Heuristic {
    public static int NUMBER_OF_FEATURES = (StandardHeuristic.NUMBER_OF_FEATURES + 1) * StandardHeuristic.NUMBER_OF_FEATURES / 2;
    private Heuristic h;

    public QuadraticFeatureHeuristic(NeuralNetwork nn) {
        super(nn);
        this.h = new StandardHeuristic(nn);
    }

    public BitSet generateFeatures(Playground p, Player aktPlayer) {
        BitSet features = this.h.generateFeatures(p, aktPlayer);
        BitSet result = new BitSet(NUMBER_OF_FEATURES);
        int i = features.nextSetBit(0);
        while (i >= 0) {
            int j = features.nextSetBit(i);
            while (j >= 0) {
                result.set(StandardHeuristic.NUMBER_OF_FEATURES * i - (i - 1) * i / 2 + (j - i));
                j = features.nextSetBit(j + 1);
            }
            i = features.nextSetBit(i + 1);
        }
        return result;
    }
}

