/*
 * Decompiled with CFR 0.152.
 */
package mln;

import mln.DiffFunction;

public final class TanhFunction
extends DiffFunction {
    public static TanhFunction f = new TanhFunction(1.0);
    public static TanhFunction f_half = new TanhFunction(0.5);
    public static TanhFunction f_flat = new TanhFunction(0.1);
    private double temperature;

    public TanhFunction() {
    }

    public TanhFunction(double temperature) {
        this.temperature = temperature;
    }

    public double calculate(double x) {
        return (Math.exp(x /= this.temperature) - Math.exp(-x)) / (Math.exp(x) + Math.exp(-x));
    }

    public double calculatePrime(double x) {
        double tanh = this.calculate(x / this.temperature);
        return (1.0 - Math.pow(tanh, 2.0)) / this.temperature;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    public String toString() {
        return "Tangens Hyperbolicus Funktion";
    }
}

