/*
 * Decompiled with CFR 0.152.
 */
package muehle.logic;

import java.util.BitSet;

public class Position {
    private static int[] positionValue = Position.createStaticPositionValues();
    private static int[][] neighbours = Position.createStaticNeighbours();
    private static int[][] muehlen = Position.createStaticMuehlen();
    private static BitSet[] muehlenMask = Position.createStaticMuehlenMask();

    private static int[][] createStaticMuehlen() {
        int[][] result = new int[24][4];
        result[0][0] = 1;
        result[0][1] = 2;
        result[0][2] = 9;
        result[0][3] = 21;
        result[1][0] = 0;
        result[1][1] = 2;
        result[1][2] = 4;
        result[1][3] = 7;
        result[2][0] = 1;
        result[2][1] = 0;
        result[2][2] = 14;
        result[2][3] = 23;
        result[3][0] = 4;
        result[3][1] = 5;
        result[3][2] = 10;
        result[3][3] = 18;
        result[4][0] = 1;
        result[4][1] = 7;
        result[4][2] = 3;
        result[4][3] = 5;
        result[5][0] = 3;
        result[5][1] = 4;
        result[5][2] = 13;
        result[5][3] = 20;
        result[6][0] = 7;
        result[6][1] = 8;
        result[6][2] = 11;
        result[6][3] = 15;
        result[7][0] = 4;
        result[7][1] = 1;
        result[7][2] = 6;
        result[7][3] = 8;
        result[8][0] = 6;
        result[8][1] = 7;
        result[8][2] = 12;
        result[8][3] = 17;
        result[9][0] = 0;
        result[9][1] = 21;
        result[9][2] = 10;
        result[9][3] = 11;
        result[10][0] = 9;
        result[10][1] = 11;
        result[10][2] = 18;
        result[10][3] = 3;
        result[11][0] = 9;
        result[11][1] = 10;
        result[11][2] = 6;
        result[11][3] = 15;
        result[12][0] = 8;
        result[12][1] = 17;
        result[12][2] = 13;
        result[12][3] = 14;
        result[13][0] = 14;
        result[13][1] = 12;
        result[13][2] = 5;
        result[13][3] = 20;
        result[14][0] = 2;
        result[14][1] = 23;
        result[14][2] = 13;
        result[14][3] = 12;
        result[15][0] = 16;
        result[15][1] = 17;
        result[15][2] = 11;
        result[15][3] = 6;
        result[16][0] = 19;
        result[16][1] = 22;
        result[16][2] = 15;
        result[16][3] = 17;
        result[17][0] = 16;
        result[17][1] = 15;
        result[17][2] = 12;
        result[17][3] = 8;
        result[18][0] = 19;
        result[18][1] = 20;
        result[18][2] = 10;
        result[18][3] = 3;
        result[19][0] = 22;
        result[19][1] = 16;
        result[19][2] = 18;
        result[19][3] = 20;
        result[20][0] = 19;
        result[20][1] = 18;
        result[20][2] = 13;
        result[20][3] = 5;
        result[21][0] = 9;
        result[21][1] = 0;
        result[21][2] = 22;
        result[21][3] = 23;
        result[22][0] = 21;
        result[22][1] = 23;
        result[22][2] = 19;
        result[22][3] = 16;
        result[23][0] = 22;
        result[23][1] = 21;
        result[23][2] = 14;
        result[23][3] = 2;
        return result;
    }

    public static int[] getMuehlen(int position) {
        return muehlen[position];
    }

    private static BitSet[] createStaticMuehlenMask() {
        BitSet[] result = new BitSet[16];
        int i = 0;
        while (i < 16) {
            result[i] = new BitSet(24);
            ++i;
        }
        result[0].set(0);
        result[0].set(1);
        result[0].set(2);
        result[1].set(0);
        result[1].set(9);
        result[1].set(21);
        result[2].set(1);
        result[2].set(4);
        result[2].set(7);
        result[3].set(2);
        result[3].set(14);
        result[3].set(23);
        result[4].set(3);
        result[4].set(4);
        result[4].set(5);
        result[5].set(3);
        result[5].set(10);
        result[5].set(18);
        result[6].set(5);
        result[6].set(13);
        result[6].set(20);
        result[7].set(6);
        result[7].set(7);
        result[7].set(8);
        result[8].set(6);
        result[8].set(11);
        result[8].set(15);
        result[9].set(8);
        result[9].set(12);
        result[9].set(17);
        result[10].set(9);
        result[10].set(10);
        result[10].set(11);
        result[11].set(12);
        result[11].set(13);
        result[11].set(14);
        result[12].set(15);
        result[12].set(16);
        result[12].set(17);
        result[13].set(16);
        result[13].set(19);
        result[13].set(22);
        result[14].set(18);
        result[14].set(19);
        result[14].set(20);
        result[15].set(21);
        result[15].set(22);
        result[15].set(23);
        return result;
    }

    public static BitSet[] getMuehlenMask() {
        return muehlenMask;
    }

    private static int[][] createStaticNeighbours() {
        int[][] result = new int[24][];
        result[0] = new int[2];
        result[0][0] = 1;
        result[0][1] = 9;
        result[1] = new int[3];
        result[1][0] = 0;
        result[1][1] = 2;
        result[1][2] = 4;
        result[2] = new int[2];
        result[2][0] = 1;
        result[2][1] = 14;
        result[3] = new int[2];
        result[3][0] = 4;
        result[3][1] = 10;
        result[4] = new int[4];
        result[4][0] = 1;
        result[4][1] = 3;
        result[4][2] = 5;
        result[4][3] = 7;
        result[5] = new int[2];
        result[5][0] = 4;
        result[5][1] = 13;
        result[6] = new int[2];
        result[6][0] = 7;
        result[6][1] = 11;
        result[7] = new int[3];
        result[7][0] = 4;
        result[7][1] = 6;
        result[7][2] = 8;
        result[8] = new int[2];
        result[8][0] = 7;
        result[8][1] = 12;
        result[9] = new int[3];
        result[9][0] = 0;
        result[9][1] = 10;
        result[9][2] = 21;
        result[10] = new int[4];
        result[10][0] = 3;
        result[10][1] = 9;
        result[10][2] = 11;
        result[10][3] = 18;
        result[11] = new int[3];
        result[11][0] = 6;
        result[11][1] = 10;
        result[11][2] = 15;
        result[12] = new int[3];
        result[12][0] = 8;
        result[12][1] = 13;
        result[12][2] = 17;
        result[13] = new int[4];
        result[13][0] = 5;
        result[13][1] = 12;
        result[13][2] = 14;
        result[13][3] = 20;
        result[14] = new int[3];
        result[14][0] = 2;
        result[14][1] = 13;
        result[14][2] = 23;
        result[15] = new int[2];
        result[15][0] = 11;
        result[15][1] = 16;
        result[16] = new int[3];
        result[16][0] = 15;
        result[16][1] = 17;
        result[16][2] = 19;
        result[17] = new int[2];
        result[17][0] = 12;
        result[17][1] = 16;
        result[18] = new int[2];
        result[18][0] = 10;
        result[18][1] = 19;
        result[19] = new int[4];
        result[19][0] = 16;
        result[19][1] = 18;
        result[19][2] = 20;
        result[19][3] = 22;
        result[20] = new int[2];
        result[20][0] = 13;
        result[20][1] = 19;
        result[21] = new int[2];
        result[21][0] = 9;
        result[21][1] = 22;
        result[22] = new int[3];
        result[22][0] = 19;
        result[22][1] = 21;
        result[22][2] = 23;
        result[23] = new int[2];
        result[23][0] = 14;
        result[23][1] = 22;
        return result;
    }

    public static int[] getNeighbours(int id) {
        return neighbours[id];
    }

    private static int[] createStaticPositionValues() {
        int[] result = new int[]{2, 3, 2, 2, 4, 2, 2, 3, 2, 3, 4, 3, 3, 4, 3, 2, 3, 2, 2, 4, 2, 2, 3, 2};
        return result;
    }

    public static int getValue(int id) {
        return positionValue[id];
    }

    public static String toString(int id) {
        if (id == 0) {
            return "a1";
        }
        if (id == 1) {
            return "d1";
        }
        if (id == 2) {
            return "g1";
        }
        if (id == 3) {
            return "b2";
        }
        if (id == 4) {
            return "d2";
        }
        if (id == 5) {
            return "f2";
        }
        if (id == 6) {
            return "c3";
        }
        if (id == 7) {
            return "d3";
        }
        if (id == 8) {
            return "e3";
        }
        if (id == 9) {
            return "a4";
        }
        if (id == 10) {
            return "b4";
        }
        if (id == 11) {
            return "c4";
        }
        if (id == 12) {
            return "e4";
        }
        if (id == 13) {
            return "f4";
        }
        if (id == 14) {
            return "g4";
        }
        if (id == 15) {
            return "c5";
        }
        if (id == 16) {
            return "d5";
        }
        if (id == 17) {
            return "e5";
        }
        if (id == 18) {
            return "b6";
        }
        if (id == 19) {
            return "d6";
        }
        if (id == 20) {
            return "f6";
        }
        if (id == 21) {
            return "a7";
        }
        if (id == 22) {
            return "d7";
        }
        if (id == 23) {
            return "g7";
        }
        return null;
    }
}

