/*
 * Decompiled with CFR 0.152.
 */
package muehle.player;

import java.util.ArrayList;
import java.util.BitSet;
import muehle.logic.Playground;
import muehle.logic.Stone;
import muehle.player.ComputerPlayer;
import muehle.player.Player;
import muehle.thinking.Heuristic;

public class LearningPlayer
extends ComputerPlayer {
    private ArrayList oppGameFeatures;
    private ArrayList lastGameFeatures = new ArrayList();
    private String filename;
    private double lambda;

    public LearningPlayer(String name, Stone s, String filenameOfHeuristic) {
        super(name, s, filenameOfHeuristic);
        this.oppGameFeatures = new ArrayList();
        this.filename = filenameOfHeuristic;
        this.lambda = 0.0;
    }

    public LearningPlayer(String name, Stone s, Heuristic h, String filename) {
        super(name, s, h);
        this.oppGameFeatures = new ArrayList();
        this.filename = filename;
        this.lambda = 0.0;
    }

    public void makeMove(Playground p) {
        super.makeMove(p);
    }

    public void learningPhase(double outcome, boolean save) {
        this.heuristic.learn(-outcome, this.oppGameFeatures, this.lambda);
        this.heuristic.learn(outcome, this.lastGameFeatures, this.lambda);
        if (save) {
            this.heuristic.save(this.filename);
        }
    }

    public void saveFeatures(Playground p, Player aktPlayer) {
        BitSet features = this.heuristic.generateFeatures(p, aktPlayer);
        if (aktPlayer == this) {
            this.lastGameFeatures.add(features);
        } else {
            this.oppGameFeatures.add(features);
        }
    }

    public void clearFeatures() {
        this.lastGameFeatures.clear();
        this.oppGameFeatures.clear();
    }

    public Player getClone() {
        LearningPlayer temp = new LearningPlayer(this.name, this.s, this.heuristic, this.filename);
        temp.setNumberOfStones(this.numberOfStones);
        temp.setNumberOfInitStones(this.initStones);
        temp.setUseTimeToBreak(this.useTimeToBreak);
        temp.setTimeToThink(this.timeToThink);
        temp.setDepthToThink(this.depthToThink);
        temp.setQs(this.qs);
        temp.setVerbose(this.verbose);
        temp.setLambda(this.lambda);
        temp.setOpponent(this.getOpponent());
        return temp;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }
}

