/*
 * Decompiled with CFR 0.152.
 */
package muehle.player;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import muehle.gui.StatusPanel;
import muehle.logic.DeleteAction;
import muehle.logic.MoveAction;
import muehle.logic.Playground;
import muehle.logic.SetAction;
import muehle.logic.Stone;
import muehle.player.NetClientPlayer;
import muehle.player.NetServerPlayer;
import muehle.player.Player;

public class NetPlayer
extends Player
implements Runnable {
    protected int destination;
    protected int source;
    protected int drop = -1;
    protected int port;
    protected BufferedReader input;
    protected PrintStream output;
    protected StatusPanel statusPanel;
    protected Thread rcvThread;

    protected NetPlayer(String name, Stone s, int port) {
        super(name, s);
        this.port = port;
    }

    public void getStatusPanel(StatusPanel sp) {
        this.statusPanel = sp;
    }

    public void getThread(Thread play) {
        this.play = play;
    }

    public void makeMove(Playground p) {
        long time1 = System.currentTimeMillis();
        this.stopGameThread();
        this.time += System.currentTimeMillis() - time1;
        if (this.play.isInterrupted()) {
            return;
        }
        if (this.canSet()) {
            SetAction action = new SetAction(this, this.destination);
            if (p.execute(action)) {
                this.appendLastAction(action);
            } else {
                this.makeMove(p);
            }
        } else {
            MoveAction action = new MoveAction(this, this.destination, this.source);
            if (p.execute(action)) {
                this.appendLastAction(action);
            } else {
                this.makeMove(p);
            }
        }
    }

    public void deleteStone(Playground p) {
        long time1 = System.currentTimeMillis();
        if (this.drop == -1) {
            this.stopGameThread();
        }
        this.time += System.currentTimeMillis() - time1;
        if (this.play.isInterrupted()) {
            return;
        }
        DeleteAction action = new DeleteAction(this.getOpponent(), this.drop);
        this.drop = -1;
        if (p.execute(action)) {
            this.appendLastAction(action);
        } else {
            this.deleteStone(p);
        }
    }

    public boolean acceptDraw(Playground p) {
        this.notice("RQ");
        this.statusPanel.setText("Warte auf Antwort...");
        return true;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void run() {
        block29: while (true) {
            try {
                while (!this.rcvThread.isInterrupted()) {
                    String rcv = this.input.readLine();
                    if (rcv == null) {
                        return;
                    }
                    StringTokenizer s = new StringTokenizer(rcv, ",");
                    String command = s.nextToken();
                    if (command.equals("IAM")) {
                        this.setName(s.nextToken());
                        if (this instanceof NetServerPlayer) {
                            this.notice("IAM," + this.getOpponent().getName());
                        }
                        if (!(this instanceof NetClientPlayer)) continue;
                        Thread thread = this.play;
                        synchronized (thread) {
                            this.gestoppt = false;
                            this.play.notifyAll();
                            continue block29;
                        }
                    }
                    if (command.equals("QUIT")) {
                        this.soundPlayback(0);
                        this.statusPanel.setText(String.valueOf(this.name) + " hat das Spiel verlassen!");
                        this.rcvThread.interrupt();
                        this.play.interrupt();
                        Thread thread = this.play;
                        synchronized (thread) {
                            this.play.notify();
                        }
                        this.disconnect();
                        continue;
                    }
                    if (command.equals("MSG")) {
                        this.statusPanel.setText("Nachricht von " + this.name + ": " + s.nextToken());
                        this.soundPlayback(0);
                        continue;
                    }
                    if (command.equals("RQ")) {
                        this.soundPlayback(0);
                        this.statusPanel.setText(String.valueOf(this.getName()) + " bietet Remis an!");
                        int answer = JOptionPane.showConfirmDialog(this.statusPanel, "Remis annehmen?", "Remisangebot", 0, 3);
                        if (answer == 0) {
                            this.notice("RA");
                            this.statusPanel.setText(String.valueOf(this.getOpponent().getName()) + " akzeptiert Remis!");
                            this.statusPanel.setText("Das Spiel endet unentschieden!");
                            this.soundPlayback(2);
                            this.play.interrupt();
                            Thread thread = this.play;
                            synchronized (thread) {
                                this.play.notifyAll();
                                continue block29;
                            }
                        }
                        this.notice("RNA");
                        this.statusPanel.setText(String.valueOf(this.getOpponent().getName()) + " lehnt Remis ab!");
                        continue;
                    }
                    if (command.equals("RA")) {
                        this.soundPlayback(2);
                        this.statusPanel.setText(String.valueOf(this.getName()) + " akzeptiert Remis!");
                        this.statusPanel.setText("Das Spiel endet unentschieden!");
                        this.play.interrupt();
                        Thread thread = this.play;
                        synchronized (thread) {
                            this.gestoppt = false;
                            this.play.notifyAll();
                            continue block29;
                        }
                    }
                    if (command.equals("RNA")) {
                        this.soundPlayback(0);
                        this.statusPanel.setText(String.valueOf(this.getName()) + " lehnt Remis ab!");
                        Thread thread = this.play;
                        synchronized (thread) {
                            this.gestoppt = true;
                            this.play.notifyAll();
                            continue block29;
                        }
                    }
                    if (command.equals("GU")) {
                        this.soundPlayback(2);
                        this.statusPanel.setText(String.valueOf(this.name) + " gibt auf!");
                        this.statusPanel.setText("Spielende: " + this.getOpponent().getName() + " hat gewonnen!");
                        this.play.interrupt();
                        Thread thread = this.play;
                        synchronized (thread) {
                            this.play.notifyAll();
                            continue block29;
                        }
                    }
                    if (command.equals("NG")) {
                        this.soundPlayback(0);
                        this.statusPanel.setText(String.valueOf(this.name) + " m\u00f6chte noch ein Spiel!");
                        this.disconnect();
                        continue;
                    }
                    if (command.equals("S")) {
                        this.soundPlayback(1);
                        this.destination = Integer.parseInt(s.nextToken());
                        Thread thread = this.play;
                        synchronized (thread) {
                            this.gestoppt = false;
                            this.play.notify();
                            continue block29;
                        }
                    }
                    if (command.equals("M")) {
                        this.soundPlayback(1);
                        this.destination = Integer.parseInt(s.nextToken());
                        this.source = Integer.parseInt(s.nextToken());
                        Thread thread = this.play;
                        synchronized (thread) {
                            this.gestoppt = false;
                            this.play.notify();
                            continue block29;
                        }
                    }
                    if (!command.equals("D")) continue;
                    this.drop = Integer.parseInt(s.nextToken());
                    Thread thread = this.play;
                    synchronized (thread) {
                        this.gestoppt = false;
                        this.play.notify();
                        continue block29;
                    }
                }
                break;
            }
            catch (IOException e) {
                System.out.println("receiveAction: " + e);
                this.statusPanel.setText(String.valueOf(this.name) + " hat das Spiel verlassen!");
                this.soundPlayback(0);
                this.play.interrupt();
                break;
            }
        }
    }

    public int connect() {
        return 0;
    }

    public void disconnect() {
    }

    public void notice(String note) {
        if (this.output == null) {
            return;
        }
        this.output.println(note);
    }

    public Player getClone() {
        NetPlayer temp = new NetPlayer(this.name, this.s, this.port);
        temp.setNumberOfStones(this.numberOfStones);
        temp.setNumberOfInitStones(this.initStones);
        temp.setOpponent(this.getOpponent());
        return temp;
    }
}

