/*
 * Decompiled with CFR 0.152.
 */
package muehle.thinking;

import java.io.FileNotFoundException;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import mln.DiffFunction;
import mln.LearningParameter;
import mln.NeuralNetwork;
import mln.SigmoidFunction;
import muehle.database.Database;
import muehle.logic.Playground;
import muehle.player.Player;
import muehle.thinking.QuadraticFeatureHeuristic;
import muehle.thinking.StandardHeuristic;

public abstract class Heuristic {
    private static Database database = Database.getDatabase();
    private NeuralNetwork nn;
    private static Random r = new Random();
    private boolean useDatabase;
    private double randomRadius = 0.0;

    public Heuristic(NeuralNetwork nn) {
        this.nn = nn;
        this.useDatabase = true;
    }

    public abstract BitSet generateFeatures(Playground var1, Player var2);

    public double evaluate(Playground p, Player aktPlayer) {
        if (this.useDatabase) {
            try {
                if (this.isEndgame(aktPlayer)) {
                    return database.getValue(p, aktPlayer);
                }
            }
            catch (NullPointerException e) {
                System.out.println("Spiel wird kurz unterbrochen -> Datenbank wird nachgeladen");
                database.load();
                System.out.println("Spiel geht weiter!");
                return database.getValue(p, aktPlayer);
            }
        }
        BitSet features = this.generateFeatures(p, aktPlayer);
        double[] nnOutput = this.nn.getOutput(features);
        double result = nnOutput[0] - nnOutput[1];
        if (this.randomRadius > 0.0 && Math.abs(result) + this.randomRadius < 0.99995) {
            result += (2.0 * r.nextDouble() - 1.0) * this.randomRadius;
        }
        return result * 0.999;
    }

    public double[] getNNOutputs(Playground p, Player aktPlayer) {
        BitSet features = this.generateFeatures(p, aktPlayer);
        return this.nn.getOutput(features);
    }

    public void save(String filename) {
        try {
            this.nn.writeToFile(filename);
        }
        catch (FileNotFoundException e) {
            System.out.println("Fehler beim Speichern (" + e + ")");
        }
    }

    public void learn(double outcome, List features, double lambda) {
        double[] finalOutcome = new double[]{0.0, 0.0, 0.0};
        if (outcome > 0.0) {
            finalOutcome[0] = Math.abs(outcome);
        }
        if (outcome < 0.0) {
            finalOutcome[1] = Math.abs(outcome);
        }
        if (outcome == 0.0) {
            finalOutcome[2] = 1.0;
        }
        double[] lastOutcome = finalOutcome;
        int i = features.size() - 1;
        while (i >= 0) {
            BitSet bs = (BitSet)features.get(i);
            this.nn.learn(lastOutcome, bs);
            lastOutcome[0] = lambda * lastOutcome[0] + (1.0 - lambda) * this.nn.getOutput(bs)[0];
            lastOutcome[1] = lambda * lastOutcome[1] + (1.0 - lambda) * this.nn.getOutput(bs)[1];
            lastOutcome[2] = lambda * lastOutcome[2] + (1.0 - lambda) * this.nn.getOutput(bs)[2];
            --i;
        }
    }

    protected boolean isEndgame(Player aktPlayer) {
        return !aktPlayer.canSet() && aktPlayer.getNumberOfStones() + aktPlayer.getOpponent().getNumberOfStones() <= 8;
    }

    public double getRandomRadius() {
        return this.randomRadius;
    }

    public void setRandomRadius(double randomRadius) {
        this.randomRadius = randomRadius;
    }

    public static StandardHeuristic randomSingleLayerHeuristic() {
        int[] layerSizes = new int[]{3};
        DiffFunction[] functions = new DiffFunction[]{new SigmoidFunction()};
        return new StandardHeuristic(new NeuralNetwork(StandardHeuristic.NUMBER_OF_FEATURES, layerSizes, functions, LearningParameter.standardParameters));
    }

    public static StandardHeuristic randomMultiLayerHeuristic() {
        int[] layerSizes = new int[]{3, StandardHeuristic.NUMBER_OF_FEATURES};
        DiffFunction[] functions = new DiffFunction[]{new SigmoidFunction(), new SigmoidFunction()};
        return new StandardHeuristic(new NeuralNetwork(StandardHeuristic.NUMBER_OF_FEATURES, layerSizes, functions, LearningParameter.standardParameters));
    }

    public static QuadraticFeatureHeuristic randomCombinedHeuristik() {
        int[] layerSizes = new int[]{3};
        DiffFunction[] functions = new DiffFunction[]{new SigmoidFunction()};
        NeuralNetwork nn = new NeuralNetwork(QuadraticFeatureHeuristic.NUMBER_OF_FEATURES, layerSizes, functions, LearningParameter.standardParameters);
        return new QuadraticFeatureHeuristic(nn);
    }

    public boolean isUseDatabase() {
        return this.useDatabase;
    }

    public void setUseDatabase(boolean useDatabase) {
        this.useDatabase = useDatabase;
    }
}

