/*
 * Decompiled with CFR 0.152.
 */
package muehle.thinking;

import java.util.ArrayList;
import java.util.BitSet;
import muehle.logic.Playground;
import muehle.logic.Position;
import muehle.logic.SetAction;
import muehle.player.Player;
import muehle.thinking.QuiescentSearch;

public class Quiet3Points
extends QuiescentSearch {
    public Quiet3Points(int quiescentDepth) {
        super(quiescentDepth);
    }

    public ArrayList getStillingActions(Playground playground, Player aktPlayer) {
        if (aktPlayer.getNumberOfInitStones() < 2) {
            return new ArrayList();
        }
        return this.getActionsToCreateTwoMuehlen(playground, aktPlayer);
    }

    private ArrayList getActionsToCreateTwoMuehlen(Playground playground, Player aktPlayer) {
        ArrayList<SetAction> actions = new ArrayList<SetAction>();
        BitSet playersStones = playground.getStones()[aktPlayer.getStone().getId()];
        BitSet opponentsStones = playground.getStones()[1 - aktPlayer.getStone().getId()];
        BitSet freeStones = playground.getFreePositionBitSet();
        BitSet[] muehlen = Position.getMuehlenMask();
        int i = freeStones.nextSetBit(0);
        while (i >= 0) {
            int[] muehlenAround = Position.getMuehlen(i);
            if ((playersStones.get(muehlenAround[0]) || playersStones.get(muehlenAround[1]) && freeStones.get(muehlenAround[0]) || freeStones.get(muehlenAround[1])) && (playersStones.get(muehlenAround[2]) || playersStones.get(muehlenAround[3]) && freeStones.get(muehlenAround[2]) || freeStones.get(muehlenAround[3]))) {
                actions.add(new SetAction(aktPlayer, i));
            }
            i = freeStones.nextSetBit(i + 1);
        }
        return actions;
    }
}

