/*
 * Decompiled with CFR 0.152.
 */
package muehle.thinking;

import java.util.ArrayList;
import java.util.BitSet;
import muehle.logic.Action;
import muehle.logic.MoveAction;
import muehle.logic.Playground;
import muehle.logic.Position;
import muehle.logic.SetAction;
import muehle.player.Player;
import muehle.thinking.QuiescentSearch;

public class QuietOpenMuehlen
extends QuiescentSearch {
    public QuietOpenMuehlen(int quiescentDepth) {
        super(quiescentDepth);
    }

    public ArrayList getStillingActions(Playground playground, Player aktPlayer) {
        return this.getActionsToCloseMuehlen(playground, aktPlayer);
    }

    private ArrayList getActionsToCloseMuehlen(Playground playground, Player aktPlayer) {
        ArrayList<Action> actions = new ArrayList<Action>();
        BitSet playersStones = playground.getStones()[aktPlayer.getStone().getId()];
        BitSet opponentsStones = playground.getStones()[1 - aktPlayer.getStone().getId()];
        BitSet freeStones = playground.getFreePositionBitSet();
        BitSet[] muehlen = Position.getMuehlenMask();
        BitSet tempM1 = new BitSet(24);
        BitSet tempM2 = new BitSet(24);
        int muehlenLength = muehlen.length;
        int i = 0;
        while (i < muehlenLength) {
            tempM1.clear();
            tempM1.or(muehlen[i]);
            tempM1.and(playersStones);
            int cardinality = tempM1.cardinality();
            if (cardinality == 2) {
                int j = muehlen[i].nextSetBit(0);
                while (j >= 0) {
                    if (freeStones.get(j)) {
                        if (aktPlayer.canSet()) {
                            actions.add(new SetAction(aktPlayer, j));
                        } else if (aktPlayer.canJump()) {
                            int myStonesIndex = playersStones.nextSetBit(0);
                            while (myStonesIndex >= 0) {
                                actions.add(new MoveAction(aktPlayer, j, myStonesIndex));
                                myStonesIndex = playersStones.nextSetBit(myStonesIndex + 1);
                            }
                        } else {
                            tempM2.clear();
                            tempM2.or(playersStones);
                            tempM2.andNot(tempM1);
                            int[] neighbours = Position.getNeighbours(j);
                            int k = 0;
                            while (k < neighbours.length) {
                                if (tempM2.get(neighbours[k])) {
                                    actions.add(new MoveAction(aktPlayer, j, neighbours[k]));
                                }
                                ++k;
                            }
                        }
                    }
                    j = muehlen[i].nextSetBit(j + 1);
                }
            }
            ++i;
        }
        return actions;
    }
}

