/*
 * Decompiled with CFR 0.152.
 */
package mln;

import java.util.BitSet;
import mln.DiffFunction;
import mln.Neuron;

public class Layer {
    private Neuron[] neurons;
    private int numberOfNeurons;

    public Layer() {
    }

    public Layer(int numberOfNeurons, int sizeOfLastLayer, DiffFunction activationFunction, double learningRateStart) {
        this.numberOfNeurons = numberOfNeurons;
        this.neurons = new Neuron[numberOfNeurons];
        int i = 0;
        while (i < numberOfNeurons) {
            this.neurons[i] = new Neuron(sizeOfLastLayer, activationFunction, learningRateStart);
            ++i;
        }
    }

    public int size() {
        return this.numberOfNeurons;
    }

    public double[] getLastOutputs() {
        double[] lastOutputs = new double[this.numberOfNeurons];
        int i = 0;
        while (i < this.numberOfNeurons) {
            lastOutputs[i] = this.neurons[i].getLastOutput();
            ++i;
        }
        return lastOutputs;
    }

    public double[] getOutput(double[] inputs) {
        double[] output = new double[this.numberOfNeurons];
        int i = 0;
        while (i < this.numberOfNeurons) {
            output[i] = this.neurons[i].getOutput(inputs);
            ++i;
        }
        return output;
    }

    public double[] getOutput(BitSet inputs) {
        double[] output = new double[this.numberOfNeurons];
        int i = 0;
        while (i < this.numberOfNeurons) {
            output[i] = this.neurons[i].getOutput(inputs);
            ++i;
        }
        return output;
    }

    public Neuron[] getNeurons() {
        return this.neurons;
    }

    public void setNeurons(Neuron[] neurons) {
        this.neurons = neurons;
    }

    public int getNumberOfNeurons() {
        return this.numberOfNeurons;
    }

    public void setNumberOfNeurons(int numberOfNeurons) {
        this.numberOfNeurons = numberOfNeurons;
    }
}

