/*
 * Decompiled with CFR 0.152.
 */
package muehle.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import muehle.logic.Playground;

public class PermutationCreator {
    private static int[][] basicPermutations = PermutationCreator.getBasicPermutations();
    public static int[][] allPermutations = PermutationCreator.allPermutations();

    private static int[][] allPermutations() {
        int[][] result = new int[16][24];
        ArrayList<int[]> permutationList = new ArrayList<int[]>();
        int[] nArray = new int[24];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        nArray[18] = 18;
        nArray[19] = 19;
        nArray[20] = 20;
        nArray[21] = 21;
        nArray[22] = 22;
        nArray[23] = 23;
        int[] identity = nArray;
        result[0] = identity;
        permutationList.add(identity);
        int i = 0;
        while (i < permutationList.size()) {
            int j = 0;
            while (j < 4) {
                int[] newPerm = PermutationCreator.usePermutation((int[])permutationList.get(i), j);
                if (!PermutationCreator.containsArray(permutationList, newPerm)) {
                    permutationList.add(newPerm);
                    result[permutationList.size() - 1] = newPerm;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static int[][] getBasicPermutations() {
        int[] nArray = new int[24];
        nArray[0] = 21;
        nArray[1] = 22;
        nArray[2] = 23;
        nArray[3] = 18;
        nArray[4] = 19;
        nArray[5] = 20;
        nArray[6] = 15;
        nArray[7] = 16;
        nArray[8] = 17;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 6;
        nArray[16] = 7;
        nArray[17] = 8;
        nArray[18] = 3;
        nArray[19] = 4;
        nArray[20] = 5;
        nArray[22] = 1;
        nArray[23] = 2;
        int[] perm1 = nArray;
        int[] nArray2 = new int[24];
        nArray2[0] = 2;
        nArray2[1] = 1;
        nArray2[3] = 5;
        nArray2[4] = 4;
        nArray2[5] = 3;
        nArray2[6] = 8;
        nArray2[7] = 7;
        nArray2[8] = 6;
        nArray2[9] = 14;
        nArray2[10] = 13;
        nArray2[11] = 12;
        nArray2[12] = 11;
        nArray2[13] = 10;
        nArray2[14] = 9;
        nArray2[15] = 17;
        nArray2[16] = 16;
        nArray2[17] = 15;
        nArray2[18] = 20;
        nArray2[19] = 19;
        nArray2[20] = 18;
        nArray2[21] = 23;
        nArray2[22] = 22;
        nArray2[23] = 21;
        int[] perm2 = nArray2;
        int[] nArray3 = new int[24];
        nArray3[0] = 23;
        nArray3[1] = 14;
        nArray3[2] = 2;
        nArray3[3] = 20;
        nArray3[4] = 13;
        nArray3[5] = 5;
        nArray3[6] = 17;
        nArray3[7] = 12;
        nArray3[8] = 8;
        nArray3[9] = 22;
        nArray3[10] = 19;
        nArray3[11] = 16;
        nArray3[12] = 7;
        nArray3[13] = 4;
        nArray3[14] = 1;
        nArray3[15] = 15;
        nArray3[16] = 11;
        nArray3[17] = 6;
        nArray3[18] = 18;
        nArray3[19] = 10;
        nArray3[20] = 3;
        nArray3[21] = 21;
        nArray3[22] = 9;
        int[] perm3 = nArray3;
        int[] nArray4 = new int[24];
        nArray4[0] = 6;
        nArray4[1] = 7;
        nArray4[2] = 8;
        nArray4[3] = 3;
        nArray4[4] = 4;
        nArray4[5] = 5;
        nArray4[7] = 1;
        nArray4[8] = 2;
        nArray4[9] = 11;
        nArray4[10] = 10;
        nArray4[11] = 9;
        nArray4[12] = 14;
        nArray4[13] = 13;
        nArray4[14] = 12;
        nArray4[15] = 21;
        nArray4[16] = 22;
        nArray4[17] = 23;
        nArray4[18] = 18;
        nArray4[19] = 19;
        nArray4[20] = 20;
        nArray4[21] = 15;
        nArray4[22] = 16;
        nArray4[23] = 17;
        int[] perm4 = nArray4;
        int[][] perms = new int[][]{perm1, perm2, perm3, perm4};
        return perms;
    }

    private static int[] usePermutation(int[] source, int numberOfBasicPermutation) {
        int[] result = new int[24];
        int[] perm = basicPermutations[numberOfBasicPermutation];
        int i = 0;
        while (i < source.length) {
            result[source[i]] = perm[i];
            ++i;
        }
        return result;
    }

    private static boolean containsArray(ArrayList v, int[] intArray) {
        int i = 0;
        while (i < v.size()) {
            if (Arrays.equals((int[])v.get(i), intArray)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static BitSet[][] getPlaygroundPermutations(BitSet[] stones) {
        BitSet[][] result = new BitSet[16][2];
        int i = 0;
        while (i < 16) {
            result[i][0] = new BitSet(24);
            result[i][1] = new BitSet(24);
            int j = 0;
            while (j < 24) {
                if (stones[0].get(j)) {
                    result[i][0].set(allPermutations[i][j]);
                }
                if (stones[1].get(j)) {
                    result[i][1].set(allPermutations[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static BitSet[] getLowestPlayground(BitSet[] b) {
        int lowestHashcode = Integer.MAX_VALUE;
        int lowestPlayground = 0;
        Playground t = new Playground();
        BitSet[][] perm = PermutationCreator.getPlaygroundPermutations(b);
        int i = 0;
        while (i < perm.length) {
            t.setStonesFromBitSet(perm[i]);
            int aktHashcode = t.perfectHashCode();
            if (aktHashcode < lowestHashcode) {
                lowestHashcode = aktHashcode;
                lowestPlayground = i;
            }
            ++i;
        }
        return perm[lowestPlayground];
    }

    public static Integer getLowestHashCode(BitSet[] b) {
        int lowestHashcode = Integer.MAX_VALUE;
        Playground t = new Playground();
        BitSet[][] perm = PermutationCreator.getPlaygroundPermutations(b);
        int i = 0;
        while (i < perm.length) {
            t.setStonesFromBitSet(perm[i]);
            int aktHashcode = t.perfectHashCode();
            if (aktHashcode < lowestHashcode) {
                lowestHashcode = aktHashcode;
            }
            ++i;
        }
        return new Integer(lowestHashcode);
    }
}

