/*
 * Decompiled with CFR 0.152.
 */
package muehle.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import mln.DiffFunction;
import mln.IdentityFunction;
import mln.LearningParameter;
import mln.ModifiedSigmoidFunction;
import mln.NeuralNetwork;
import mln.SigmoidFunction;
import mln.TanhFunction;
import muehle.thinking.CombinedHeuristic;
import muehle.thinking.SimpleHeuristic;
import muehle.thinking.SmallHeuristic;
import muehle.thinking.StandardHeuristic;
import muehle.thinking.VerySmallHeuristic;

public class HeuristikCreationDialog
extends JDialog {
    private byte button;
    private Component owner;
    private JPanel jPanel = null;
    private JLabel lMomentum = null;
    private JLabel lLearningRateStart = null;
    private JLabel lLearningRatePlus = null;
    private JLabel lLearningRateMinus = null;
    private JLabel lNumberOfLayers = null;
    private JLabel lNumberOfNeuronsOnLayers = null;
    private JTextField tMomentum = null;
    private JTextField tLearningRateStart = null;
    private JTextField tLearningRatePlus = null;
    private JTextField tLearningRateMinus = null;
    private JTextField tNumberOfLayers = null;
    private JButton ok = null;
    private JButton abbrechen = null;
    private JRadioButton rCombinedHeuristic = null;
    private JRadioButton rNormalHeuristic = null;
    private LineBorder lb = null;
    private JComboBox heuristic = null;
    private JTextField[] tNumberOfNeuronsOnLayer = null;
    private JComboBox[] function = null;

    public HeuristikCreationDialog(Frame owner) {
        super(owner, true);
        this.owner = owner;
        this.setContentPane(this.getJPanel());
        this.setTitle("Heuristik anlegen");
        this.setSize(573, 365);
        this.button = 0;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.lb = new LineBorder(Color.BLACK);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.setName("heuristicPanel");
            this.lLearningRateStart = new JLabel();
            this.lLearningRateStart.setText("Learningrate Startwert");
            this.lLearningRateStart.setBounds(12, 43, 180, 20);
            this.tLearningRateStart = new JTextField("0.05");
            this.tLearningRateStart.setBounds(200, 43, 60, 20);
            this.lLearningRateMinus = new JLabel();
            this.lLearningRateMinus.setText("Learningrate Abnahme-Faktor");
            this.lLearningRateMinus.setBounds(12, 73, 180, 20);
            this.tLearningRateMinus = new JTextField("0.5");
            this.tLearningRateMinus.setBounds(200, 73, 60, 20);
            this.lLearningRatePlus = new JLabel();
            this.lLearningRatePlus.setText("Learningrate Zunahme-Faktor");
            this.lLearningRatePlus.setBounds(12, 103, 180, 20);
            this.tLearningRatePlus = new JTextField("0.05");
            this.tLearningRatePlus.setBounds(200, 103, 60, 20);
            this.lMomentum = new JLabel();
            this.lMomentum.setText("Momentum-Faktor");
            this.lMomentum.setBounds(12, 133, 180, 20);
            this.tMomentum = new JTextField("0.6");
            this.tMomentum.setBounds(200, 133, 60, 20);
            this.lNumberOfLayers = new JLabel();
            this.lNumberOfLayers.setText("Layer:");
            this.lNumberOfLayers.setBounds(300, 43, 120, 20);
            this.tNumberOfLayers = new JTextField("3");
            this.tNumberOfLayers.setBounds(380, 43, 60, 20);
            JLabel lFeatures = new JLabel();
            lFeatures.setText("Features");
            lFeatures.setBounds(300, 73, 120, 20);
            this.heuristic = new JComboBox();
            this.heuristic.addItem("Standard Features");
            this.heuristic.addItem("Quadratische Features");
            this.heuristic.addItem("Feld Features");
            this.heuristic.addItem("Kombinierte Feld-Features");
            this.heuristic.addItem("Small Heuristic");
            this.heuristic.addItem("Very Small Heuristic");
            this.heuristic.setBounds(380, 73, 160, 20);
            this.jPanel.add(lFeatures);
            this.jPanel.add(this.heuristic);
            JLabel lLayerU = new JLabel("Layer");
            lLayerU.setBounds(12, 170, 80, 20);
            JLabel lNeuronU = new JLabel("Neuronen");
            lNeuronU.setBounds(100, 170, 80, 20);
            JLabel lFunctionU = new JLabel("Aktivierungsfunktion");
            lFunctionU.setBounds(200, 170, 200, 20);
            this.jPanel.add(lLayerU);
            this.jPanel.add(lNeuronU);
            this.jPanel.add(lFunctionU);
            DiffFunction[] activationFunctions = new DiffFunction[]{SigmoidFunction.f, ModifiedSigmoidFunction.f, TanhFunction.f, IdentityFunction.f};
            this.tNumberOfNeuronsOnLayer = new JTextField[50];
            this.function = new JComboBox[50];
            int i = 0;
            while (i < Integer.parseInt(this.tNumberOfLayers.getText())) {
                JLabel lLayer = new JLabel(String.valueOf(i + 1) + ". Layer");
                lLayer.setBounds(12, 170 + 30 * (i + 1), 80, 20);
                this.jPanel.add(lLayer);
                this.tNumberOfNeuronsOnLayer[i] = new JTextField("1");
                this.tNumberOfNeuronsOnLayer[i].setBounds(100, 170 + 30 * (i + 1), 60, 20);
                this.jPanel.add(this.tNumberOfNeuronsOnLayer[i]);
                this.function[i] = new JComboBox();
                this.function[i].addItem(activationFunctions[0]);
                this.function[i].addItem(activationFunctions[1]);
                this.function[i].addItem(activationFunctions[2]);
                this.function[i].addItem(activationFunctions[3]);
                this.function[i].setBounds(200, 170 + 30 * (i + 1), 220, 20);
                this.function[i].setSelectedItem(activationFunctions[1]);
                this.jPanel.add(this.function[i]);
                ++i;
            }
            this.tNumberOfNeuronsOnLayer[0].setText("3");
            this.tNumberOfNeuronsOnLayer[0].setEditable(false);
            this.function[0].setSelectedItem(activationFunctions[0]);
            this.ok = new JButton();
            this.ok.setText("Heuristik speichern");
            this.ok.setLocation(5, 294);
            this.ok.setSize(248, 27);
            this.abbrechen = new JButton();
            this.abbrechen.setText("Abbrechen");
            this.abbrechen.setLocation(257, 294);
            this.abbrechen.setSize(108, 27);
            this.jPanel.add(this.lLearningRateMinus);
            this.jPanel.add(this.tLearningRateMinus);
            this.jPanel.add(this.lLearningRatePlus);
            this.jPanel.add(this.tLearningRatePlus);
            this.jPanel.add(this.lLearningRateStart);
            this.jPanel.add(this.tLearningRateStart);
            this.jPanel.add(this.lMomentum);
            this.jPanel.add(this.tMomentum);
            this.jPanel.add(this.lNumberOfLayers);
            this.jPanel.add(this.tNumberOfLayers);
            this.jPanel.add(this.ok);
            this.jPanel.add(this.abbrechen);
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        LearningParameter parameters = new LearningParameter();
                        parameters.setLearningRateMinus(Double.parseDouble(HeuristikCreationDialog.this.tLearningRateMinus.getText()));
                        parameters.setLearningRatePlus(Double.parseDouble(HeuristikCreationDialog.this.tLearningRatePlus.getText()));
                        parameters.setLearningRateStart(Double.parseDouble(HeuristikCreationDialog.this.tLearningRateStart.getText()));
                        parameters.setMomentumFactor(Double.parseDouble(HeuristikCreationDialog.this.tMomentum.getText()));
                        NeuralNetwork nn = new NeuralNetwork();
                        int[] layerSizes = new int[Integer.parseInt(HeuristikCreationDialog.this.tNumberOfLayers.getText())];
                        DiffFunction[] functions = new DiffFunction[Integer.parseInt(HeuristikCreationDialog.this.tNumberOfLayers.getText())];
                        int i = 0;
                        while (i < layerSizes.length) {
                            layerSizes[i] = Integer.parseInt(HeuristikCreationDialog.this.tNumberOfNeuronsOnLayer[i].getText());
                            functions[i] = (DiffFunction)HeuristikCreationDialog.this.function[i].getSelectedItem();
                            ++i;
                        }
                        if (HeuristikCreationDialog.this.heuristic.getSelectedItem().equals("Standard Features")) {
                            nn = new NeuralNetwork(StandardHeuristic.NUMBER_OF_FEATURES, layerSizes, functions, parameters);
                        }
                        if (HeuristikCreationDialog.this.heuristic.getSelectedItem().equals("Quadratische Features")) {
                            nn = new NeuralNetwork(CombinedHeuristic.NUMBER_OF_FEATURES, layerSizes, functions, parameters);
                        }
                        if (HeuristikCreationDialog.this.heuristic.getSelectedItem().equals("Feld Features")) {
                            nn = new NeuralNetwork(SimpleHeuristic.NUMBER_OF_FEATURES, layerSizes, functions, parameters);
                        }
                        if (HeuristikCreationDialog.this.heuristic.getSelectedItem().equals("Kombinierte Feld-Features")) {
                            nn = new NeuralNetwork(CombinedHeuristic.NUMBER_OF_FEATURES, layerSizes, functions, parameters);
                        }
                        if (HeuristikCreationDialog.this.heuristic.getSelectedItem().equals("Small Heuristic")) {
                            nn = new NeuralNetwork(SmallHeuristic.NUMBER_OF_FEATURES, layerSizes, functions, parameters);
                        }
                        if (HeuristikCreationDialog.this.heuristic.getSelectedItem().equals("Very Small Heuristic")) {
                            nn = new NeuralNetwork(VerySmallHeuristic.NUMBER_OF_FEATURES, layerSizes, functions, parameters);
                        }
                        String filename = HeuristikCreationDialog.this.saveHeuristicToFile();
                        nn.writeToFile(filename);
                        HeuristikCreationDialog.this.button = (byte)1;
                        HeuristikCreationDialog.this.dispose();
                    }
                    catch (NumberFormatException e1) {
                        HeuristikCreationDialog.this.button = (byte)-2;
                        HeuristikCreationDialog.this.dispose();
                    }
                    catch (FileNotFoundException e2) {
                        HeuristikCreationDialog.this.button = (byte)-1;
                        HeuristikCreationDialog.this.dispose();
                    }
                }
            });
            this.abbrechen.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    HeuristikCreationDialog.this.button = (byte)-1;
                    HeuristikCreationDialog.this.dispose();
                }
            });
        }
        return this.jPanel;
    }

    public byte getChoice() {
        return this.button;
    }

    public void setToVisible(boolean b) {
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }

    private String saveHeuristicToFile() {
        JFileChooser fc = new JFileChooser("Heuristic");
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith("xml");
            }

            public String getDescription() {
                return "M\u00fchle Heuristic (.xml)";
            }
        });
        int auswahl = fc.showSaveDialog(this);
        if (auswahl == 0) {
            File file = fc.getSelectedFile();
            String flname = file.getAbsolutePath();
            if (!flname.endsWith(".xml") && !flname.equals("")) {
                flname = String.valueOf(flname) + ".xml";
            }
            return flname;
        }
        return "";
    }
}

