/*
 * Decompiled with CFR 0.152.
 */
package muehle.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Random;
import muehle.logic.Action;
import muehle.logic.DeleteAction;
import muehle.logic.MoveAction;
import muehle.logic.Position;
import muehle.logic.SetAction;
import muehle.logic.Stone;
import muehle.logic.UndoDeleteAction;
import muehle.logic.UndoSetAction;
import muehle.player.Player;

public class Playground {
    BitSet[] stones = new BitSet[]{new BitSet(24), new BitSet(24)};
    ArrayList actions;
    int[][] zobristTable = this.generateZobristKeyTable();

    public Playground() {
        this.actions = new ArrayList();
    }

    public boolean executeProofed(Action action) {
        if (action instanceof SetAction) {
            return this.executeProofed((SetAction)action);
        }
        if (action instanceof UndoSetAction) {
            return this.executeProofed((UndoSetAction)action);
        }
        if (action instanceof DeleteAction) {
            return this.executeProofed((DeleteAction)action);
        }
        if (action instanceof UndoDeleteAction) {
            return this.executeProofed((UndoDeleteAction)action);
        }
        if (action instanceof MoveAction) {
            return this.executeProofed((MoveAction)action);
        }
        return false;
    }

    public boolean executeProofed(SetAction action) {
        this.setStone(action.getStone(), action.getDestination());
        action.getPlayer().incrementStones();
        action.getPlayer().decrementInitStones();
        return true;
    }

    public boolean executeProofed(UndoSetAction action) {
        this.removeStone(action.getDestination());
        action.getPlayer().decrementStones();
        action.getPlayer().incrementInitStones();
        return true;
    }

    public boolean executeProofed(DeleteAction action) {
        this.removeStone(action.getDestination());
        action.getPlayer().decrementStones();
        return true;
    }

    public boolean executeProofed(UndoDeleteAction action) {
        this.setStone(action.getStone(), action.getDestination());
        action.getPlayer().incrementStones();
        return true;
    }

    public boolean executeProofed(MoveAction action) {
        this.removeStone(action.getSource());
        this.setStone(action.getStone(), action.getDestination());
        return true;
    }

    public boolean execute(Action action) {
        if (action instanceof SetAction) {
            return this.execute((SetAction)action);
        }
        if (action instanceof UndoSetAction) {
            return this.execute((UndoSetAction)action);
        }
        if (action instanceof DeleteAction) {
            return this.execute((DeleteAction)action);
        }
        if (action instanceof UndoDeleteAction) {
            return this.execute((UndoDeleteAction)action);
        }
        if (action instanceof MoveAction) {
            return this.execute((MoveAction)action);
        }
        return false;
    }

    public boolean execute(SetAction action) {
        if (!this.isLegal(action)) {
            return false;
        }
        return this.executeProofed(action);
    }

    public boolean execute(UndoSetAction action) {
        return this.executeProofed(action);
    }

    public boolean execute(DeleteAction action) {
        if (!this.isLegal(action)) {
            return false;
        }
        return this.executeProofed(action);
    }

    public boolean execute(UndoDeleteAction action) {
        return this.executeProofed(action);
    }

    public boolean execute(MoveAction action) {
        if (!this.isLegal(action)) {
            return false;
        }
        return this.executeProofed(action);
    }

    private boolean isLegal(SetAction action) {
        ArrayList possibleActions = this.getPlayersActions(action.getPlayer());
        return possibleActions.contains(action);
    }

    private boolean isLegal(DeleteAction action) {
        int positionToDelete = action.getDestination();
        ArrayList free = this.getPlayersFreeStones(action.getStone());
        int freeSize = free.size();
        int i = 0;
        while (i < freeSize) {
            int actualPosition = (Integer)free.get(i);
            if (positionToDelete == actualPosition) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isLegal(MoveAction action) {
        ArrayList possibleActions = this.getPlayersActions(action.getPlayer());
        return possibleActions.contains(action);
    }

    private void setStone(Stone s, int position) {
        this.stones[s.getId()].set(position);
    }

    private void removeStone(int p) {
        this.stones[0].clear(p);
        this.stones[1].clear(p);
    }

    public Stone getStone(int p) {
        if (this.stones[0].get(p)) {
            return Stone.O;
        }
        if (this.stones[1].get(p)) {
            return Stone.X;
        }
        return Stone.None;
    }

    public boolean isFree(int position) {
        return !this.stones[0].get(position) && !this.stones[1].get(position);
    }

    public ArrayList getPlayersStones(Stone stone) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = this.stones[stone.getId()].nextSetBit(0);
        while (i >= 0) {
            list.add(new Integer(i));
            i = this.stones[stone.getId()].nextSetBit(i + 1);
        }
        return list;
    }

    public ArrayList getFreePositions() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        BitSet temp = this.getFreePositionBitSet();
        int i = temp.nextSetBit(0);
        while (i >= 0) {
            list.add(new Integer(i));
            i = temp.nextSetBit(i + 1);
        }
        return list;
    }

    public BitSet getFreePositionBitSet() {
        BitSet temp = (BitSet)this.stones[0].clone();
        temp.or(this.stones[1]);
        temp.flip(0, 24);
        return temp;
    }

    public ArrayList getPlayersFreeStones(Stone s) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = this.stones[s.getId()].nextSetBit(0);
        while (i >= 0) {
            if (!this.isMuehle(i, s)) {
                list.add(new Integer(i));
            }
            i = this.stones[s.getId()].nextSetBit(i + 1);
        }
        return list;
    }

    public boolean hasFreeStones(Stone s) {
        int i = this.stones[s.getId()].nextSetBit(0);
        while (i >= 0) {
            if (!this.isMuehle(i, s)) {
                return true;
            }
            i = this.stones[s.getId()].nextSetBit(i + 1);
        }
        return false;
    }

    public boolean hasActions(Player player) {
        if (player.canSet() || player.canJump()) {
            return true;
        }
        int source = this.stones[player.getStone().getId()].nextSetBit(0);
        while (source >= 0) {
            int[] destination = Position.getNeighbours(source);
            int j = 0;
            while (j < Position.getValue(source)) {
                if (this.isFree(destination[j])) {
                    return true;
                }
                ++j;
            }
            source = this.stones[player.getStone().getId()].nextSetBit(source + 1);
        }
        return false;
    }

    public ArrayList getPlayersActions(Player player) {
        ArrayList<Action> list = new ArrayList<Action>();
        if (player.canSet()) {
            BitSet temp = (BitSet)this.stones[0].clone();
            temp.or(this.stones[1]);
            temp.flip(0, 24);
            int i = temp.nextSetBit(0);
            while (i >= 0) {
                SetAction action = player.getSetAction(i);
                list.add(action);
                i = temp.nextSetBit(i + 1);
            }
            return list;
        }
        if (player.canJump()) {
            BitSet freeStones = (BitSet)this.stones[0].clone();
            freeStones.or(this.stones[1]);
            freeStones.flip(0, 24);
            int source = this.stones[player.getStone().getId()].nextSetBit(0);
            while (source >= 0) {
                int destination = freeStones.nextSetBit(0);
                while (destination >= 0) {
                    MoveAction action = player.getMoveAction(destination, source);
                    list.add(action);
                    destination = freeStones.nextSetBit(destination + 1);
                }
                source = this.stones[player.getStone().getId()].nextSetBit(source + 1);
            }
            return list;
        }
        BitSet usedPositions = (BitSet)this.stones[0].clone();
        usedPositions.or(this.stones[1]);
        int source = this.stones[player.getStone().getId()].nextSetBit(0);
        while (source >= 0) {
            int[] destination = Position.getNeighbours(source);
            int j = 0;
            while (j < Position.getValue(source)) {
                if (!usedPositions.get(destination[j])) {
                    list.add(player.getMoveAction(destination[j], source));
                }
                ++j;
            }
            source = this.stones[player.getStone().getId()].nextSetBit(source + 1);
        }
        return list;
    }

    public int getNumberOfPlayersMoveActions(Player player) {
        int counter = 0;
        int source = this.stones[player.getStone().getId()].nextSetBit(0);
        while (source >= 0) {
            int[] sourceNeighbours = Position.getNeighbours(source);
            int valueCount = Position.getValue(source);
            int j = 0;
            while (j < valueCount) {
                if (this.isFree(sourceNeighbours[j])) {
                    ++counter;
                }
                ++j;
            }
            source = this.stones[player.getStone().getId()].nextSetBit(source + 1);
        }
        return counter;
    }

    public boolean isMuehle(Action action) {
        if (action instanceof DeleteAction) {
            return false;
        }
        return this.isMuehle(action.getDestination(), action.getStone());
    }

    private boolean isMuehle(int p, Stone s) {
        if (this.getStone(Position.getMuehlen(p)[0]) == s && this.getStone(Position.getMuehlen(p)[1]) == s) {
            return true;
        }
        return this.getStone(Position.getMuehlen(p)[2]) == s && this.getStone(Position.getMuehlen(p)[3]) == s;
    }

    public Playground getClone() {
        Playground copy = new Playground();
        BitSet[] temp = new BitSet[]{(BitSet)this.stones[0].clone(), (BitSet)this.stones[1].clone()};
        copy.stones = temp;
        return copy;
    }

    public String toString() {
        String out = "";
        int x = 0;
        while (x < 24) {
            out = this.isFree(x) ? String.valueOf(out) + "." : String.valueOf(out) + this.getStone(x).getSign();
            if (x == 0 || x == 1 || x == 21 || x == 22) {
                out = String.valueOf(out) + "-----";
            } else if (x == 3 || x == 4 || x == 18 || x == 19) {
                out = String.valueOf(out) + "---";
            } else if (x == 6 || x == 7 || x == 9 || x == 10 || x == 12 || x == 13 || x == 15 || x == 16) {
                out = String.valueOf(out) + "-";
            } else if (x == 2) {
                out = String.valueOf(out) + "\n| ";
            } else if (x == 5) {
                out = String.valueOf(out) + " |\n| | ";
            } else if (x == 8) {
                out = String.valueOf(out) + " | |\n";
            } else if (x == 14) {
                out = String.valueOf(out) + "\n| | ";
            } else if (x == 17) {
                out = String.valueOf(out) + " | |\n| ";
            } else if (x == 11) {
                out = String.valueOf(out) + "   ";
            } else if (x == 20) {
                out = String.valueOf(out) + " |\n";
            }
            ++x;
        }
        return String.valueOf(out) + "\n";
    }

    public String tertiaerString() {
        String out = "";
        int x = 0;
        while (x < 24) {
            out = String.valueOf(out) + (this.getStone(x).getId() + 1);
            ++x;
        }
        return out;
    }

    public String inversTertiaerString() {
        String out = "";
        int x = 0;
        while (x < 24) {
            if (this.getStone(x) == Stone.None) {
                out = String.valueOf(out) + "0";
            }
            if (this.getStone(x) == Stone.O) {
                out = String.valueOf(out) + "2";
            }
            if (this.getStone(x) == Stone.X) {
                out = String.valueOf(out) + "1";
            }
            ++x;
        }
        return out;
    }

    public void appendAction(Action action) {
        this.actions.add(action);
    }

    public ArrayList getActions() {
        return this.actions;
    }

    public int[] countMuehlen(Player p) {
        int countMuehlen = 0;
        int countOpenMuehlen = 0;
        BitSet playersStones = this.stones[p.getStone().getId()];
        BitSet opponentsStones = this.stones[1 - p.getStone().getId()];
        BitSet freeStones = this.getFreePositionBitSet();
        BitSet[] muehlen = Position.getMuehlenMask();
        BitSet tempM1 = new BitSet(24);
        BitSet tempM2 = new BitSet(24);
        int muehlenLength = muehlen.length;
        int i = 0;
        while (i < muehlenLength) {
            tempM1.clear();
            tempM1.or(muehlen[i]);
            tempM1.and(playersStones);
            int cardinality = tempM1.cardinality();
            if (cardinality == 3) {
                ++countMuehlen;
            } else if (cardinality == 2) {
                int j = muehlen[i].nextSetBit(0);
                while (j >= 0) {
                    if (freeStones.get(j)) {
                        if (p.canSet() || p.canJump()) {
                            ++countOpenMuehlen;
                            break;
                        }
                        tempM2.clear();
                        tempM2.or(playersStones);
                        tempM2.andNot(tempM1);
                        int[] neighbours = Position.getNeighbours(j);
                        int k = 0;
                        while (k < neighbours.length) {
                            if (tempM2.get(neighbours[k])) {
                                ++countOpenMuehlen;
                                break;
                            }
                            ++k;
                        }
                    }
                    j = muehlen[i].nextSetBit(j + 1);
                }
            }
            ++i;
        }
        int[] result = new int[]{countMuehlen, countOpenMuehlen};
        return result;
    }

    public int getSituationValue(Stone s) {
        int value = 0;
        int i = this.stones[s.getId()].nextSetBit(0);
        while (i >= 0) {
            value += Position.getValue(i);
            i = this.stones[s.getId()].nextSetBit(i + 1);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Playground)) {
            return false;
        }
        Playground p = (Playground)o;
        return Arrays.equals(this.stones, p.stones);
    }

    public int hashCode() {
        int key = 0;
        int i = this.stones[0].nextSetBit(0);
        while (i >= 0) {
            key ^= this.zobristTable[0][i];
            i = this.stones[0].nextSetBit(i + 1);
        }
        i = this.stones[1].nextSetBit(0);
        while (i >= 0) {
            key ^= this.zobristTable[1][i];
            i = this.stones[1].nextSetBit(i + 1);
        }
        return key;
    }

    private int[][] generateZobristKeyTable() {
        Random r = new Random();
        int[][] table = new int[2][24];
        int j = 0;
        while (j < 2) {
            int i = 0;
            while (i < 24) {
                table[j][i] = r.nextInt();
                ++i;
            }
            ++j;
        }
        return table;
    }

    public int perfectHashCode() {
        int key = 0;
        BitSet setBits = new BitSet(32);
        setBits.or(this.stones[0]);
        setBits.or(this.stones[1]);
        int setBitsCounter = 24;
        int i = setBits.nextSetBit(0);
        while (i >= 0) {
            if (this.stones[1].get(i)) {
                setBits.set(setBitsCounter);
            }
            ++setBitsCounter;
            i = setBits.nextSetBit(i + 1);
        }
        i = 0;
        while (i <= 31) {
            key <<= 1;
            if (setBits.get(i)) {
                ++key;
            }
            ++i;
        }
        return key;
    }

    public void setStonesFromBitSet(BitSet[] bitset) {
        this.stones = bitset;
    }

    public BitSet[] getStones() {
        return this.stones;
    }
}

