/*
 * Decompiled with CFR 0.152.
 */
package mln;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.BitSet;
import mln.DiffFunction;
import mln.Layer;
import mln.LearningParameter;
import mln.NeuralNetworkReadingException;
import mln.Neuron;

public class NeuralNetwork {
    private Layer[] layers;
    private int numberOfInputs;
    private int numberOfLayers;
    private LearningParameter parameters;

    public NeuralNetwork() {
    }

    public NeuralNetwork(int numberOfInputs, int[] layerSizes, DiffFunction[] functions, LearningParameter parameters) {
        this.numberOfLayers = layerSizes.length;
        this.layers = new Layer[this.numberOfLayers];
        this.numberOfInputs = numberOfInputs;
        this.parameters = parameters;
        int i = 0;
        while (i < this.numberOfLayers - 1) {
            this.layers[i] = new Layer(layerSizes[i], layerSizes[i + 1], functions[i], parameters.getLearningRateStart());
            ++i;
        }
        this.layers[this.numberOfLayers - 1] = new Layer(layerSizes[this.numberOfLayers - 1], numberOfInputs, functions[this.numberOfLayers - 1], parameters.getLearningRateStart());
    }

    public int getNumberOfLayers() {
        return this.numberOfLayers;
    }

    public double[] getOutput(double[] inputs) {
        double[] input_output = inputs;
        int i = this.numberOfLayers - 1;
        while (i >= 0) {
            input_output = this.layers[i].getOutput(input_output);
            --i;
        }
        return input_output;
    }

    public double[] getOutput(BitSet inputs) {
        double[] input_output = this.layers[this.numberOfLayers - 1].getOutput(inputs);
        int i = this.numberOfLayers - 2;
        while (i >= 0) {
            input_output = this.layers[i].getOutput(input_output);
            --i;
        }
        return input_output;
    }

    public void writeToFile(String filename) throws FileNotFoundException {
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(filename)));
        e.writeObject(this);
        e.close();
        System.out.println("NeuralNetwork-Konfiguration gespeichert in Datei: " + filename);
    }

    public static NeuralNetwork readFromFile(String filename) throws NeuralNetworkReadingException {
        NeuralNetwork nn = null;
        try {
            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(filename)));
            nn = (NeuralNetwork)d.readObject();
            d.close();
        }
        catch (Exception e) {
            throw new NeuralNetworkReadingException(String.valueOf(filename) + " (" + e + ")");
        }
        return nn;
    }

    public void learn(double[] outcome, BitSet features) {
        double[] networkOutput = this.getOutput(features);
        double[] error = new double[outcome.length];
        double[] nextLayerError = null;
        double[] nextLayerOutput = null;
        int i = 0;
        while (i < outcome.length) {
            error[i] = outcome[i] - networkOutput[i];
            ++i;
        }
        i = 0;
        while (i < this.numberOfLayers) {
            if (i < this.numberOfLayers - 1) {
                nextLayerError = new double[this.layers[i + 1].getNumberOfNeurons()];
                Arrays.fill(nextLayerError, 0.0);
                nextLayerOutput = new double[this.layers[i + 1].getNumberOfNeurons()];
                nextLayerOutput = this.layers[i + 1].getLastOutputs();
            }
            Neuron[] neuronsOfLayer = this.layers[i].getNeurons();
            int j = 0;
            while (j < neuronsOfLayer.length) {
                Neuron n = neuronsOfLayer[j];
                double delta = n.calculateDelta(error[j]);
                double[] weightsOfNeuron = n.getWeights();
                if (i < this.numberOfLayers - 1) {
                    int k = 0;
                    while (k < nextLayerError.length) {
                        int n2 = k;
                        nextLayerError[n2] = nextLayerError[n2] + delta * weightsOfNeuron[k];
                        ++k;
                    }
                    n.adjustWeights(nextLayerOutput, this.parameters);
                } else {
                    n.adjustWeights(features, this.parameters);
                }
                ++j;
            }
            error = nextLayerError;
            ++i;
        }
    }

    public void learn(double[] outcome, double[] features) {
        double[] networkOutput = this.getOutput(features);
        double[] error = new double[outcome.length];
        double[] nextLayerError = null;
        double[] nextLayerOutput = null;
        int i = 0;
        while (i < outcome.length) {
            error[i] = outcome[i] - networkOutput[i];
            ++i;
        }
        i = 0;
        while (i < this.numberOfLayers) {
            if (i < this.numberOfLayers - 1) {
                nextLayerError = new double[this.layers[i + 1].getNumberOfNeurons()];
                Arrays.fill(nextLayerError, 0.0);
                nextLayerOutput = new double[this.layers[i + 1].getNumberOfNeurons()];
                nextLayerOutput = this.layers[i + 1].getLastOutputs();
            }
            Neuron[] neuronsOfLayer = this.layers[i].getNeurons();
            int j = 0;
            while (j < neuronsOfLayer.length) {
                Neuron n = neuronsOfLayer[j];
                double delta = n.calculateDelta(error[j]);
                double[] weightsOfNeuron = n.getWeights();
                if (i < this.numberOfLayers - 1) {
                    int k = 0;
                    while (k < nextLayerError.length) {
                        int n2 = k;
                        nextLayerError[n2] = nextLayerError[n2] + delta * weightsOfNeuron[k];
                        ++k;
                    }
                    n.adjustWeights(nextLayerOutput, this.parameters);
                } else {
                    n.adjustWeights(features, this.parameters);
                }
                ++j;
            }
            error = nextLayerError;
            ++i;
        }
    }

    public Layer[] getLayers() {
        return this.layers;
    }

    public void setLayers(Layer[] layers) {
        this.layers = layers;
    }

    public int getNumberOfInputs() {
        return this.numberOfInputs;
    }

    public void setNumberOfInputs(int numberOfInputs) {
        this.numberOfInputs = numberOfInputs;
    }

    public void setNumberOfLayers(int numberOfLayers) {
        this.numberOfLayers = numberOfLayers;
    }

    public LearningParameter getParameters() {
        return this.parameters;
    }

    public void setParameters(LearningParameter parameters) {
        this.parameters = parameters;
    }
}

