/*
 * Decompiled with CFR 0.152.
 */
package mln;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Random;
import mln.DiffFunction;
import mln.LearningParameter;

public class Neuron {
    private double[] weights;
    private int numberOfInputs;
    private double activationEnergy;
    private DiffFunction activationFunction;
    private double[] learningRate;
    private double learningRateActivationEnergy;
    private double[] weightChanges;
    private double activationEnergyChange;
    private double weightedSum;
    private double delta;
    private double[] lastError;
    private double lastErrorActivationEnergy;
    private static Random r = new Random();

    public Neuron() {
    }

    public Neuron(int numberofWeights, DiffFunction activationFunction, double learningRateStart) {
        this.activationEnergy = r.nextDouble() - r.nextDouble();
        this.activationFunction = activationFunction;
        this.numberOfInputs = numberofWeights;
        this.learningRate = new double[numberofWeights];
        Arrays.fill(this.learningRate, learningRateStart);
        this.learningRateActivationEnergy = learningRateStart;
        this.lastError = new double[numberofWeights];
        Arrays.fill(this.lastError, 0.0);
        this.lastErrorActivationEnergy = 0.0;
        this.weightChanges = new double[this.numberOfInputs];
        Arrays.fill(this.weightChanges, 0.0);
        this.activationEnergyChange = 0.0;
        this.weights = new double[numberofWeights];
        int i = 0;
        while (i < numberofWeights) {
            this.weights[i] = r.nextDouble() - r.nextDouble();
            ++i;
        }
    }

    public double getOutput(double[] inputs) {
        this.setWeightedSum(inputs);
        return this.activationFunction.calculate(this.weightedSum);
    }

    public double getOutput(BitSet inputs) {
        this.setWeightedSum(inputs);
        return this.activationFunction.calculate(this.weightedSum);
    }

    private void setWeightedSum(double[] inputs) {
        double sum = -this.activationEnergy;
        int i = 0;
        while (i < this.numberOfInputs) {
            sum += inputs[i] * this.weights[i];
            ++i;
        }
        this.weightedSum = sum;
    }

    public void setWeightedSum(BitSet inputs) {
        double sum = -this.activationEnergy;
        int i = inputs.nextSetBit(0);
        while (i >= 0) {
            sum += this.weights[i];
            i = inputs.nextSetBit(i + 1);
        }
        this.weightedSum = sum;
    }

    public double getLastOutput() {
        return this.activationFunction.calculate(this.weightedSum);
    }

    public double calculateDelta(double error) {
        this.delta = this.activationFunction.calculatePrime(this.weightedSum) * error;
        return this.delta;
    }

    public void adjustWeights(double[] inputValues, LearningParameter parameters) {
        double momentumFactor = parameters.getMomentumFactor();
        double currentError = this.delta;
        this.calculateNewLearningRateOfActivationEnergy(currentError, parameters);
        this.activationEnergyChange = this.learningRateActivationEnergy * currentError + momentumFactor * this.activationEnergyChange;
        this.activationEnergy -= this.activationEnergyChange;
        int i = 0;
        while (i < this.numberOfInputs) {
            currentError = this.delta * inputValues[i];
            this.calculateNewLearningRate(currentError, i, parameters);
            this.weightChanges[i] = this.learningRate[i] * currentError + momentumFactor * this.weightChanges[i];
            int n = i;
            this.weights[n] = this.weights[n] + this.weightChanges[i];
            ++i;
        }
    }

    public void adjustWeights(BitSet features, LearningParameter parameters) {
        double momentumFactor = parameters.getMomentumFactor();
        double currentError = this.delta;
        this.calculateNewLearningRateOfActivationEnergy(currentError, parameters);
        this.activationEnergyChange = this.learningRateActivationEnergy * currentError + momentumFactor * this.activationEnergyChange;
        this.activationEnergy -= this.activationEnergyChange;
        int i = features.nextSetBit(0);
        while (i >= 0) {
            this.calculateNewLearningRate(currentError, i, parameters);
            this.weightChanges[i] = this.learningRate[i] * currentError + momentumFactor * this.weightChanges[i];
            int n = i;
            this.weights[n] = this.weights[n] + this.weightChanges[i];
            i = features.nextSetBit(i + 1);
        }
    }

    private void calculateNewLearningRate(double currentError, int weightIndex, LearningParameter parameters) {
        double learningRatePlus = parameters.getLearningRatePlus();
        double learningRateMinus = parameters.getLearningRateMinus();
        if (currentError * this.lastError[weightIndex] < 0.0) {
            int n = weightIndex;
            this.learningRate[n] = this.learningRate[n] * learningRateMinus;
        } else if (currentError * this.lastError[weightIndex] > 0.0) {
            int n = weightIndex;
            this.learningRate[n] = this.learningRate[n] + learningRatePlus;
        }
        this.lastError[weightIndex] = currentError;
    }

    private void calculateNewLearningRateOfActivationEnergy(double currentError, LearningParameter parameters) {
        double learningRatePlus = parameters.getLearningRatePlus();
        double learningRateMinus = parameters.getLearningRateMinus();
        if (currentError * this.lastErrorActivationEnergy < 0.0) {
            this.learningRateActivationEnergy *= learningRateMinus;
        } else if (currentError * this.lastErrorActivationEnergy > 0.0) {
            this.learningRateActivationEnergy += learningRatePlus;
        }
        this.lastErrorActivationEnergy = currentError;
    }

    public int getNumberOfInputs() {
        return this.numberOfInputs;
    }

    public void setNumberOfInputs(int numberOfInputs) {
        this.numberOfInputs = numberOfInputs;
    }

    public double getActivationEnergy() {
        return this.activationEnergy;
    }

    public void setActivationEnergy(double activationEnergy) {
        this.activationEnergy = activationEnergy;
    }

    public DiffFunction getActivationFunction() {
        return this.activationFunction;
    }

    public void setActivationFunction(DiffFunction activationFunction) {
        this.activationFunction = activationFunction;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public double getWeightedSum() {
        return this.weightedSum;
    }

    public double getDelta() {
        return this.delta;
    }

    public double[] getLearningRate() {
        return this.learningRate;
    }

    public void setLearningRate(double[] learningRate) {
        this.learningRate = learningRate;
    }

    public double getLearningRateActivationEnergy() {
        return this.learningRateActivationEnergy;
    }

    public void setLearningRateActivationEnergy(double learningRateActivationEnergy) {
        this.learningRateActivationEnergy = learningRateActivationEnergy;
    }

    public double[] getLastError() {
        return this.lastError;
    }

    public void setLastError(double[] lastError) {
        this.lastError = lastError;
    }

    public double getLastErrorActivationEnergy() {
        return this.lastErrorActivationEnergy;
    }

    public void setLastErrorActivationEnergy(double lastErrorActivationEnergy) {
        this.lastErrorActivationEnergy = lastErrorActivationEnergy;
    }

    public double[] getWeightChanges() {
        return this.weightChanges;
    }

    public void setWeightChanges(double[] weightChanges) {
        this.weightChanges = weightChanges;
    }

    public double getActivationEnergyChange() {
        return this.activationEnergyChange;
    }

    public void setActivationEnergyChange(double activationEnergyChange) {
        this.activationEnergyChange = activationEnergyChange;
    }
}

