/*
 * Decompiled with CFR 0.152.
 */
package muehle;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Random;
import muehle.logic.Playground;
import muehle.logic.Stone;
import muehle.player.ComputerPlayer;
import muehle.player.LearningPlayer;
import muehle.player.Player;

public class LernUmgebung
implements Runnable {
    private Playground p;
    private Player player1;
    private Player player2;
    private Player aktPlayer;
    private Player gameWon;
    private static boolean gestoppt = true;
    private boolean threadEnd = true;
    public static Thread play;
    private Player[] player;
    private int[] playerwon;
    private int[] playerlost;
    private int[] unentschieden;
    private int player1Number;
    private int player2Number;
    private int numberOfGames;
    private int SAVE_INTERVAL = 200;
    private int moveCounter;
    private int numberOfPlayers;

    public LernUmgebung(ArrayList playerList) {
        this.numberOfPlayers = playerList.size();
        this.player = new Player[this.numberOfPlayers];
        this.playerwon = new int[this.numberOfPlayers];
        this.playerlost = new int[this.numberOfPlayers];
        this.unentschieden = new int[this.numberOfPlayers];
        this.numberOfGames = 0;
        int i = 0;
        while (i < this.numberOfPlayers) {
            this.player[i] = (Player)playerList.get(i);
            ++i;
        }
        this.newGame();
    }

    public boolean isGameOver() {
        if (this.aktPlayer.getNumberOfStones() < 3 && this.aktPlayer.getNumberOfInitStones() == 0 || !this.p.hasActions(this.aktPlayer)) {
            this.gameWon = this.aktPlayer.getOpponent();
            return true;
        }
        if (this.aktPlayer.getOpponent().getNumberOfStones() < 3 && this.aktPlayer.getOpponent().getNumberOfInitStones() == 0 || !this.p.hasActions(this.aktPlayer.getOpponent())) {
            this.gameWon = this.aktPlayer;
            return true;
        }
        return false;
    }

    public void newGame() {
        this.p = new Playground();
        this.gameWon = null;
        Random rnd = new Random();
        this.player2Number = this.player1Number = rnd.nextInt(this.numberOfPlayers);
        while (this.player2Number == this.player1Number) {
            this.player2Number = rnd.nextInt(this.numberOfPlayers);
        }
        this.player1 = this.player[this.player1Number].getClone();
        this.player1.setStone(Stone.O);
        this.player1.connect();
        this.player2 = this.player[this.player2Number].getClone();
        this.player2.setStone(Stone.X);
        this.player2.connect();
        this.aktPlayer = this.player1;
        this.player1.setOpponent(this.player2);
        this.player2.setOpponent(this.player1);
        while (!this.threadEnd) {
            System.gc();
        }
        play = new Thread(this);
        this.threadEnd = false;
        play.start();
    }

    public void run() {
        Hashtable<Playground, Integer> remisHash = new Hashtable<Playground, Integer>(5000);
        int localMoveCounter = this.moveCounter;
        while (!this.isGameOver() && this.moveCounter - localMoveCounter < 100) {
            ++this.moveCounter;
            this.player1.saveFeatures(this.p, this.aktPlayer);
            this.player2.saveFeatures(this.p, this.aktPlayer);
            this.aktPlayer.makeMove(this.p);
            this.p.appendAction(this.aktPlayer.getLastAction());
            if (remisHash.containsKey(this.p)) {
                int val = (Integer)remisHash.get(this.p);
                if (val == 2) {
                    play.interrupt();
                }
                remisHash.put(this.p, new Integer(val + 1));
            } else {
                remisHash.put(this.p, new Integer(1));
            }
            if (play.isInterrupted()) break;
            if (this.p.isMuehle(this.aktPlayer.getLastAction()) && !this.p.getPlayersFreeStones(this.aktPlayer.getOpponent().getStone()).isEmpty()) {
                this.aktPlayer.deleteStone(this.p);
                this.p.appendAction(this.aktPlayer.getLastAction());
            }
            this.aktPlayer = this.aktPlayer.getOpponent();
        }
        this.threadEnd = true;
        if (this.gameWon == null) {
            int n = this.player1Number;
            this.unentschieden[n] = this.unentschieden[n] + 1;
            int n2 = this.player2Number;
            this.unentschieden[n2] = this.unentschieden[n2] + 1;
        } else if (this.gameWon == this.player1) {
            int n = this.player1Number;
            this.playerwon[n] = this.playerwon[n] + 1;
            int n3 = this.player2Number;
            this.playerlost[n3] = this.playerlost[n3] + 1;
        } else if (this.gameWon == this.player2) {
            int n = this.player2Number;
            this.playerwon[n] = this.playerwon[n] + 1;
            int n4 = this.player1Number;
            this.playerlost[n4] = this.playerlost[n4] + 1;
        }
        ++this.numberOfGames;
        double outcomeValue = 0.0;
        if (this.gameWon == this.player1) {
            outcomeValue = 1.0;
        }
        if (this.gameWon == this.player2) {
            outcomeValue = -1.0;
        }
        this.player1.learningPhase(outcomeValue, this.numberOfGames % this.SAVE_INTERVAL == 0);
        this.player2.learningPhase(-outcomeValue, this.numberOfGames % this.SAVE_INTERVAL == 0);
        this.player1.disconnect();
        this.player2.disconnect();
        System.out.println("******************************************");
        int i = 0;
        while (i < this.numberOfPlayers) {
            System.out.println(String.valueOf(this.player[i].getName()) + ": Won: " + this.playerwon[i] + "  Lost: " + this.playerlost[i] + "  Remis: " + this.unentschieden[i]);
            ++i;
        }
        System.out.println("MoveCounter: " + this.moveCounter);
        this.newGame();
    }

    public static void main(String[] args) {
        ArrayList<ComputerPlayer> listOfPlayers = new ArrayList<ComputerPlayer>();
        boolean verbose = false;
        int depth = 6;
        int time = 5000;
        int quiescentDepth = 0;
        boolean useTime = false;
        double randomRadius = 0.05;
        double lambda = 0.0;
        boolean learn = true;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-v")) {
                verbose = true;
            } else if (args[i].equals("-test")) {
                learn = false;
            } else if (args[i].startsWith("-d=")) {
                depth = Integer.parseInt(args[i].substring(3, args[i].length()));
                useTime = false;
            } else if (args[i].startsWith("-t=")) {
                time = Integer.parseInt(args[i].substring(3, args[i].length()));
                useTime = true;
            } else if (args[i].startsWith("-r=")) {
                randomRadius = Double.parseDouble(args[i].substring(3, args[i].length()));
            } else if (args[i].startsWith("-l=")) {
                lambda = Double.parseDouble(args[i].substring(3, args[i].length()));
            } else if (args[i].startsWith("-q=")) {
                quiescentDepth = Integer.parseInt(args[i].substring(3, args[i].length()));
            } else {
                ComputerPlayer player = learn ? new LearningPlayer(args[i], Stone.O, "../Heuristic/" + args[i] + ".xml") : new ComputerPlayer(args[i], Stone.O, "../Heuristic/" + args[i] + ".xml");
                player.setVerbose(verbose);
                player.setUseTimeToBreak(useTime);
                player.setDepthToThink(depth);
                player.setTimeToThink(time);
                player.setRandomRadius(randomRadius);
                player.setLambda(lambda);
                player.getQs().setQuiescentDepth(quiescentDepth);
                listOfPlayers.add(player);
            }
            ++i;
        }
        LernUmgebung m = new LernUmgebung(listOfPlayers);
    }
}

