/*
 * Decompiled with CFR 0.152.
 */
package muehle;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import muehle.gui.AboutDialog;
import muehle.gui.HeuristikCreationDialog;
import muehle.gui.OptionDialog;
import muehle.gui.PlayerPanel;
import muehle.gui.PlaygroundPanel;
import muehle.gui.StatusPanel;
import muehle.logic.Action;
import muehle.logic.DeleteAction;
import muehle.logic.Playground;
import muehle.player.ComputerPlayer;
import muehle.player.HumanPlayer;
import muehle.player.NetClientPlayer;
import muehle.player.NetPlayer;
import muehle.player.Player;

public class Muehle
extends JFrame
implements Runnable,
ActionListener {
    private String VERSION_NUMBER = "2.45";
    private Playground p;
    private StatusPanel statuspanel;
    private PlayerPanel playerpanel;
    private PlaygroundPanel playgroundpanel;
    private Player player1;
    private Player player2;
    private Player aktPlayer;
    private Player gameWon;
    private JCheckBoxMenuItem m_power_1;
    private JCheckBoxMenuItem m_power_2;
    private JCheckBoxMenuItem m_power_3;
    private JMenuItem m_neu;
    private JMenuItem m_moveProposal;
    private JMenuItem m_offerDraw;
    private JMenuItem m_giveUp;
    private Image img = this.getToolkit().createImage("Resources/icon.jpg");
    private OptionDialog optionDialog;
    private AboutDialog aboutDialog;
    private HeuristikCreationDialog heuristicDialog;
    private boolean netGame = false;
    private boolean savedGame = false;
    private boolean verbose = false;
    private boolean threadEnd = true;
    private Thread play;
    private final double POWER_1 = 0.4;
    private final double POWER_2 = 0.2;
    private final double POWER_3 = 0.0;

    public Muehle(boolean verbose) {
        this.setTitle("M\u00fchle V. " + this.VERSION_NUMBER);
        this.setSize(650, 650);
        this.setIconImage(this.img);
        this.setLocation(550, 50);
        this.verbose = verbose;
        Muehle.getAudioClips();
        this.optionDialog = new OptionDialog(this);
        this.aboutDialog = new AboutDialog(this);
        this.heuristicDialog = new HeuristikCreationDialog(this);
        this.getContentPane().setLayout(new BorderLayout());
        JMenuBar m = new JMenuBar();
        JMenu m1 = new JMenu("Spiel");
        JMenu m2 = new JMenu("Einstellungen");
        JMenu m3 = new JMenu("Hilfe");
        m1.setMnemonic('S');
        m2.setMnemonic('E');
        m3.setMnemonic('H');
        this.m_neu = new JMenuItem("Neues Spiel", 78);
        this.m_offerDraw = new JMenuItem("Remis anbieten", 82);
        this.m_giveUp = new JMenuItem("Aufgeben", 65);
        this.m_moveProposal = new JMenuItem("Zugvorschlag", 90);
        JMenuItem m_saveGame = new JMenuItem("Spiel speichern", 83);
        JMenuItem m_loadGame = new JMenuItem("Spiel laden", 76);
        JMenuItem m_print = new JMenuItem("Drucken ...", 68);
        JMenuItem m_ende = new JMenuItem("Beenden", 66);
        JMenuItem m_player = new JMenuItem("Spieler", 83);
        JMenuItem m_newHeuristik = new JMenuItem("Heuristik anlegen", 72);
        JMenuItem m_help = new JMenuItem("Hilfe", 72);
        JMenuItem m_about = new JMenuItem("\u00dcber M\u00fchle", 77);
        JCheckBoxMenuItem m_sound = new JCheckBoxMenuItem("Soundeffekte");
        JCheckBoxMenuItem m_markLastAction = new JCheckBoxMenuItem("letzten Zug markieren");
        JCheckBoxMenuItem m_coordinates = new JCheckBoxMenuItem("Koordinaten anzeigen");
        JMenu m_power = new JMenu("Spielst\u00e4rke");
        m_power.setMnemonic('k');
        this.m_power_1 = new JCheckBoxMenuItem("Anf\u00e4nger");
        this.m_power_2 = new JCheckBoxMenuItem("Fortgeschrittener");
        this.m_power_3 = new JCheckBoxMenuItem("Profi");
        m_power.add(this.m_power_1);
        m_power.add(this.m_power_2);
        m_power.add(this.m_power_3);
        this.m_power_3.setState(true);
        m_sound.setState(true);
        m_markLastAction.setState(true);
        m_coordinates.setState(true);
        this.m_neu.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        m_ende.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        m_player.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.m_offerDraw.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.m_giveUp.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.m_moveProposal.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        m1.add(this.m_neu);
        m1.add(m_loadGame);
        m1.add(m_saveGame);
        m1.add(m_print);
        m1.addSeparator();
        m1.add(this.m_offerDraw);
        m1.add(this.m_giveUp);
        m1.add(this.m_moveProposal);
        m1.addSeparator();
        m1.add(m_ende);
        m2.add(m_player);
        m2.add(m_newHeuristik);
        m2.add(m_power);
        m2.addSeparator();
        m2.add(m_sound);
        m2.add(m_markLastAction);
        m2.add(m_coordinates);
        m3.add(m_help);
        m3.add(m_about);
        m.add(m1);
        m.add(m2);
        m.add(m3);
        this.setJMenuBar(m);
        this.m_neu.addActionListener(this);
        m_ende.addActionListener(this);
        m_help.addActionListener(this);
        this.m_offerDraw.addActionListener(this);
        this.m_giveUp.addActionListener(this);
        m_saveGame.addActionListener(this);
        m_loadGame.addActionListener(this);
        m_print.addActionListener(this);
        m_player.addActionListener(this);
        m_newHeuristik.addActionListener(this);
        m_power.addActionListener(this);
        m_about.addActionListener(this);
        this.m_power_1.addActionListener(this);
        this.m_power_2.addActionListener(this);
        this.m_power_3.addActionListener(this);
        m_sound.addActionListener(this);
        m_markLastAction.addActionListener(this);
        m_coordinates.addActionListener(this);
        this.m_moveProposal.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Muehle.this.player1.notice("QUIT");
                Muehle.this.player2.notice("QUIT");
                Muehle.this.player1.disconnect();
                Muehle.this.player2.disconnect();
                Muehle.this.dispose();
                System.exit(0);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int newWidth = Math.min(((Muehle)e.getSource()).getWidth(), ((Muehle)e.getSource()).getHeight());
                e.getComponent().setSize(newWidth, newWidth);
                Muehle.this.playerpanel.setPreferredSize(new Dimension((int)((double)newWidth * 0.25), 0));
                Muehle.this.statuspanel.setPreferredSize(new Dimension(0, (int)((double)newWidth * 0.15)));
            }
        });
        this.newGame();
    }

    public void newGame() {
        this.p = new Playground();
        this.gameWon = null;
        this.player1 = this.optionDialog.getPlayer1();
        this.player2 = this.optionDialog.getPlayer2();
        this.netGame = this.optionDialog.getGameStatus();
        this.aktPlayer = this.player1;
        this.player1.setOpponent(this.player2);
        this.player2.setOpponent(this.player1);
        this.player1.setVerbose(this.verbose);
        this.player2.setVerbose(this.verbose);
        this.statuspanel = new StatusPanel(this.player1, this.player2);
        this.playerpanel = new PlayerPanel(this.player1, this.player2);
        this.playgroundpanel = new PlaygroundPanel(this.p);
        this.playgroundpanel.setPlayer(this.aktPlayer);
        this.playerpanel.setPreferredSize(new Dimension((int)((double)this.getWidth() * 0.24), 0));
        this.statuspanel.setPreferredSize(new Dimension(0, (int)((double)this.getHeight() * 0.15)));
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.playgroundpanel, "Center");
        this.getContentPane().add((Component)this.playerpanel, "East");
        this.getContentPane().add((Component)this.statuspanel, "South");
        this.getContentPane().validate();
        while (!this.threadEnd) {
            System.gc();
        }
        if (this.savedGame) {
            this.loadFromFile();
            this.repaint();
        }
        this.savedGame = false;
        if (this.player1 instanceof ComputerPlayer) {
            if (this.player2 instanceof ComputerPlayer) {
                this.m_offerDraw.setEnabled(false);
                this.m_giveUp.setEnabled(false);
                this.m_moveProposal.setEnabled(false);
                this.m_neu.setEnabled(true);
            } else if (this.player2 instanceof NetPlayer) {
                this.m_offerDraw.setEnabled(false);
                this.m_giveUp.setEnabled(true);
                this.m_moveProposal.setEnabled(false);
                this.m_neu.setEnabled(false);
            } else if (this.player2 instanceof HumanPlayer) {
                this.m_offerDraw.setEnabled(true);
                this.m_giveUp.setEnabled(true);
                this.m_moveProposal.setEnabled(true);
                this.m_neu.setEnabled(true);
            }
        }
        if (this.player1 instanceof HumanPlayer) {
            if (this.player2 instanceof ComputerPlayer) {
                this.m_offerDraw.setEnabled(true);
                this.m_giveUp.setEnabled(true);
                this.m_moveProposal.setEnabled(true);
                this.m_neu.setEnabled(true);
            } else if (this.player2 instanceof NetPlayer) {
                this.m_offerDraw.setEnabled(true);
                this.m_giveUp.setEnabled(true);
                this.m_moveProposal.setEnabled(false);
                this.m_neu.setEnabled(false);
            } else if (this.player2 instanceof HumanPlayer) {
                this.m_offerDraw.setEnabled(false);
                this.m_giveUp.setEnabled(false);
                this.m_moveProposal.setEnabled(false);
                this.m_neu.setEnabled(true);
            }
        }
        if (this.player1 instanceof NetPlayer) {
            if (this.player2 instanceof ComputerPlayer) {
                this.m_offerDraw.setEnabled(false);
                this.m_giveUp.setEnabled(true);
                this.m_moveProposal.setEnabled(false);
                this.m_neu.setEnabled(false);
            } else if (this.player2 instanceof HumanPlayer) {
                this.m_offerDraw.setEnabled(true);
                this.m_giveUp.setEnabled(true);
                this.m_moveProposal.setEnabled(false);
                this.m_neu.setEnabled(false);
            }
        }
        if (this.m_power_1.getState()) {
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.4);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.4);
            }
        } else if (this.m_power_2.getState()) {
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.2);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.2);
            }
        } else if (this.m_power_3.getState()) {
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.0);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.0);
            }
        }
        this.play = new Thread(this);
        this.threadEnd = false;
        this.play.start();
    }

    public void run() {
        if (this.netGame) {
            this.statuspanel.showMsgArea();
            this.player1.getStatusPanel(this.statuspanel);
            this.player2.getStatusPanel(this.statuspanel);
            this.player1.getThread(this.play);
            this.player2.getThread(this.play);
            this.player1.connect();
            this.player2.connect();
        }
        this.statuspanel.setText("Das Spiel beginnt!");
        Hashtable<Playground, Integer> remisHash = new Hashtable<Playground, Integer>();
        int moveCounter = 0;
        while (!this.isGameOver()) {
            this.playerpanel.setAktPlayer(this.aktPlayer);
            this.playerpanel.repaint();
            this.playgroundpanel.setPlayer(this.aktPlayer);
            this.player1.saveFeatures(this.p, this.aktPlayer);
            this.player2.saveFeatures(this.p, this.aktPlayer);
            this.aktPlayer.getThread(this.play);
            this.aktPlayer.makeMove(this.p);
            this.p.appendAction(this.aktPlayer.getLastAction());
            if (++moveCounter == 100) {
                this.player1.soundPlayback(2);
                this.statuspanel.setText("Remis durch 100 Z\u00fcge-Regel! Das Spiel endet unentschieden!");
                this.player1.learningPhase(0.0, true);
                this.player2.learningPhase(0.0, true);
                this.play.interrupt();
            }
            if (remisHash.containsKey(this.p)) {
                int val = (Integer)remisHash.get(this.p);
                if (val == 2) {
                    this.aktPlayer.soundPlayback(2);
                    this.statuspanel.setText("Remis durch Zugwiederholung! Das Spiel endet unentschieden!");
                    this.player1.learningPhase(0.0, true);
                    this.player2.learningPhase(0.0, true);
                    this.play.interrupt();
                }
                remisHash.put(this.p, new Integer(val + 1));
            } else {
                remisHash.put(this.p, new Integer(1));
            }
            this.playgroundpanel.repaint();
            if (this.play.isInterrupted()) {
                this.gameEndConfig();
                this.threadEnd = true;
                return;
            }
            this.statuspanel.setText("Zug von " + this.aktPlayer.getName() + ": " + this.aktPlayer.getLastAction().toString());
            if (this.p.isMuehle(this.aktPlayer.getLastAction()) && !this.p.getPlayersFreeStones(this.aktPlayer.getOpponent().getStone()).isEmpty()) {
                this.aktPlayer.deleteStone(this.p);
                this.p.appendAction(this.aktPlayer.getLastAction());
                this.playgroundpanel.repaint();
                this.statuspanel.setText(this.aktPlayer.getLastAction().toString());
            }
            this.aktPlayer = this.aktPlayer.getOpponent();
        }
        this.statuspanel.setText("Spielende: " + this.gameWon.getName() + " hat gewonnen!");
        this.gameWon.soundPlayback(2);
        this.playerpanel.repaint();
        this.gameEndConfig();
        double outcomeValue = 0.0;
        if (this.gameWon == this.player1) {
            outcomeValue = 1.0;
        }
        if (this.gameWon == this.player2) {
            outcomeValue = -1.0;
        }
        this.player1.learningPhase(outcomeValue, true);
        this.player2.learningPhase(-outcomeValue, true);
        this.threadEnd = true;
    }

    private void gameEndConfig() {
        this.m_neu.setEnabled(true);
        this.m_giveUp.setEnabled(false);
        this.m_offerDraw.setEnabled(false);
        this.m_moveProposal.setEnabled(false);
    }

    public boolean isGameOver() {
        if (this.aktPlayer.getNumberOfStones() < 3 && this.aktPlayer.getNumberOfInitStones() == 0 || !this.p.hasActions(this.aktPlayer)) {
            this.gameWon = this.aktPlayer.getOpponent();
            return true;
        }
        if (this.aktPlayer.getOpponent().getNumberOfStones() < 3 && this.aktPlayer.getOpponent().getNumberOfInitStones() == 0 || !this.p.hasActions(this.aktPlayer.getOpponent())) {
            this.gameWon = this.aktPlayer;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        PrintJob printJob;
        JMenuItem source = (JMenuItem)e.getSource();
        String item = source.getText();
        if ("Neues Spiel".equals(item)) {
            if (!this.threadEnd) {
                this.play.interrupt();
                this.notifyThread();
            }
            this.player1.notice("NG");
            this.player2.notice("NG");
            this.player1.disconnect();
            this.player2.disconnect();
            this.newGame();
        }
        if ("Spiel speichern".equals(item)) {
            this.saveToFile();
        }
        if ("Drucken ...".equals(item) && (printJob = this.getToolkit().getPrintJob(this, "M\u00fchle - Spielfeld und Z\u00fcge ausdrucken", null)) != null) {
            Graphics printg = printJob.getGraphics();
            Dimension page = printJob.getPageDimension();
            int resolution = printJob.getPageResolution();
            this.playgroundpanel.toPrinter(printg, page, resolution);
            printg.dispose();
            printJob.end();
        }
        if ("letzten Zug markieren".equals(item)) {
            this.playgroundpanel.flipMarkLastAction();
            this.repaint();
        }
        if ("Koordinaten anzeigen".equals(item)) {
            this.playgroundpanel.flipShowCoordinates();
            this.repaint();
        }
        if ("Soundeffekte".equals(item)) {
            Player.flipSound();
            this.repaint();
        }
        if ("Zugvorschlag".equals(item) && this.aktPlayer instanceof HumanPlayer && this.aktPlayer.getOpponent() instanceof ComputerPlayer) {
            this.statuspanel.setText("Berechne Zugvorschlag...");
            this.repaint();
            ((HumanPlayer)this.aktPlayer).moveProposal(this.p, this.statuspanel, ((ComputerPlayer)this.aktPlayer.getOpponent()).getHeuristic());
            this.repaint();
        }
        if ("Spiel laden".equals(item)) {
            this.play.interrupt();
            this.notifyThread();
            this.player1.notice("QUIT");
            this.player2.notice("QUIT");
            this.player1.disconnect();
            this.player2.disconnect();
            this.savedGame = true;
            this.newGame();
        }
        if ("Remis anbieten".equals(item)) {
            String remisAswerName;
            boolean remis;
            if (this.player1 instanceof NetClientPlayer || this.player2 instanceof HumanPlayer) {
                this.statuspanel.setText(String.valueOf(this.player2.getName()) + " bietet Remis an!");
                remis = this.player1.acceptDraw(this.p);
                remisAswerName = this.player1.getName();
            } else {
                this.statuspanel.setText(String.valueOf(this.player1.getName()) + " bietet Remis an!");
                remis = this.player2.acceptDraw(this.p);
                remisAswerName = this.player2.getName();
            }
            if (this.player1 instanceof NetPlayer || this.player2 instanceof NetPlayer) {
                return;
            }
            if (remis) {
                this.player1.soundPlayback(2);
                this.play.interrupt();
                this.notifyThread();
                this.statuspanel.setText(String.valueOf(remisAswerName) + " akzeptiert Remis!");
                this.statuspanel.setText("Das Spiel endet unentschieden!");
            } else {
                this.statuspanel.setText(String.valueOf(remisAswerName) + " lehnt Remis ab!");
                this.player1.soundPlayback(0);
            }
        }
        if ("Aufgeben".equals(item)) {
            this.play.interrupt();
            this.notifyThread();
            if (this.player1 instanceof NetClientPlayer || this.player2 instanceof HumanPlayer) {
                this.gameWon = this.player1;
                this.player1.notice("GU");
                this.statuspanel.setText(String.valueOf(this.player2.getName()) + " gibt auf!");
            } else {
                this.gameWon = this.player2;
                this.player2.notice("GU");
                this.statuspanel.setText(String.valueOf(this.player1.getName()) + " gibt auf!");
            }
            this.gameEndConfig();
            this.player1.soundPlayback(2);
            this.statuspanel.setText("Spielende: " + this.gameWon.getName() + " hat gewonnen!");
        }
        if ("Beenden".equals(item)) {
            this.player1.notice("QUIT");
            this.player2.notice("QUIT");
            this.player1.disconnect();
            this.player2.disconnect();
            this.dispose();
            System.exit(0);
        }
        if ("Spieler".equals(item)) {
            this.optionDialog.setToVisible(true);
            if (this.optionDialog.getChoice() == 1) {
                this.play.interrupt();
                this.notifyThread();
                this.player1.notice("QUIT");
                this.player2.notice("QUIT");
                this.player1.disconnect();
                this.player2.disconnect();
                this.newGame();
            }
            if (this.optionDialog.getChoice() == -2) {
                this.statuspanel.setText("Fehlerhafte Eingabe im Dialog!");
            }
        }
        if ("Heuristik anlegen".equals(item)) {
            this.heuristicDialog.setToVisible(true);
            if (this.heuristicDialog.getChoice() == -2) {
                this.statuspanel.setText("Fehlerhafte Eingabe im Dialog!");
            }
        }
        if ("Anf\u00e4nger".equals(item)) {
            this.m_power_2.setState(false);
            this.m_power_3.setState(false);
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.4);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.4);
            }
        }
        if ("Fortgeschrittener".equals(item)) {
            this.m_power_1.setState(false);
            this.m_power_3.setState(false);
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.2);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.2);
            }
        }
        if ("Profi".equals(item)) {
            this.m_power_1.setState(false);
            this.m_power_2.setState(false);
            if (this.player1 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player1).setRandomRadius(0.0);
            }
            if (this.player2 instanceof ComputerPlayer) {
                ((ComputerPlayer)this.player2).setRandomRadius(0.0);
            }
        }
        if ("\u00dcber M\u00fchle".equals(item)) {
            this.aboutDialog.setToVisible(true);
        }
        if ("Hilfe".equals(item)) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler anleitung.html");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Runtime.getRuntime().exec("netscape anleitung.html");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void notifyThread() {
        Thread thread = this.play;
        synchronized (thread) {
            this.play.notify();
        }
    }

    public static AudioClip[] getAudioClips() {
        try {
            AudioClip[] ac = new AudioClip[3];
            String url_header = "file:" + new File(".").getCanonicalPath();
            ac[0] = Applet.newAudioClip(new URL(String.valueOf(url_header) + "/Resources/ding.wav"));
            ac[1] = Applet.newAudioClip(new URL(String.valueOf(url_header) + "/Resources/set.wav"));
            ac[2] = Applet.newAudioClip(new URL(String.valueOf(url_header) + "/Resources/win.wav"));
            Player.setAudio(ac);
            return ac;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void saveToFile() {
        ArrayList gameActions = this.p.getActions();
        JFileChooser fc = new JFileChooser("Saves");
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".mhl");
            }

            public String getDescription() {
                return "M\u00fchle Savegame (.mhl)";
            }
        });
        int auswahl = fc.showSaveDialog(this);
        if (auswahl == 0) {
            String filename = fc.getSelectedFile().getAbsolutePath();
            if (!filename.endsWith(".mhl")) {
                filename = String.valueOf(filename) + ".mhl";
            }
            try {
                XMLEncoder e = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(filename)));
                int i = 0;
                while (i < gameActions.size()) {
                    ((Action)gameActions.get(i)).setPlayer(null);
                    ++i;
                }
                e.writeObject(gameActions);
                e.close();
                this.statuspanel.setText("Das Spiel wurde unter dem Namen " + filename + " gespeichert!");
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                this.statuspanel.setText("Das Speichern ist fehlgeschlagen!");
            }
        }
    }

    private void loadFromFile() {
        JFileChooser fc = new JFileChooser("Saves");
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".mhl");
            }

            public String getDescription() {
                return "M\u00fchle Savegame (.mhl)";
            }
        });
        int auswahl = fc.showOpenDialog(this);
        if (auswahl == 0) {
            String filename = fc.getSelectedFile().getAbsolutePath();
            try {
                XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream(filename)));
                ArrayList actions = (ArrayList)d.readObject();
                d.close();
                int i = 0;
                while (i < actions.size()) {
                    Action aktAction = (Action)actions.get(i);
                    aktAction.setPlayer(this.aktPlayer);
                    this.p.executeProofed(aktAction);
                    this.p.appendAction(aktAction);
                    this.aktPlayer.appendLastAction(aktAction);
                    this.statuspanel.setText("Zug von " + this.aktPlayer.getName() + ": " + this.aktPlayer.getLastAction().toString());
                    if (i < actions.size() - 1 && !(actions.get(i + 1) instanceof DeleteAction)) {
                        this.aktPlayer = this.aktPlayer.getOpponent();
                    }
                    if (i == actions.size() - 1) {
                        this.aktPlayer = this.aktPlayer.getOpponent();
                    }
                    ++i;
                }
                this.statuspanel.setText("Das Spiel wurde erfolgreich geladen!");
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                this.statuspanel.setText("Das Laden ist fehlgeschlagen!");
            }
        }
    }

    public StatusPanel getStatusPanel() {
        return this.statuspanel;
    }

    public static void main(String[] args) {
        boolean verbose = false;
        if (args.length != 0 && args[0].equals("-v")) {
            verbose = true;
        }
        Muehle m = new Muehle(verbose);
        m.setVisible(true);
    }
}

