/*
 * Decompiled with CFR 0.152.
 */
package muehle.database;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import muehle.database.DatabaseEntry;
import muehle.database.PermutationCreator;
import muehle.logic.Playground;
import muehle.logic.Stone;
import muehle.player.Player;

public class Database {
    private static Database database = new Database();
    private ArrayList[][] winVector;
    private ArrayList[][] lossVector;
    private boolean ready = false;

    public void load() {
        this.winVector = new ArrayList[6][6];
        this.lossVector = new ArrayList[6][6];
        try {
            this.winVector[3][3] = this.buildListFromFile("Database/win3-3.dat");
            this.winVector[3][4] = this.buildListFromFile("Database/win3-4.dat");
            this.winVector[3][5] = this.buildListFromFile("Database/win3-5.dat");
            this.winVector[4][3] = this.buildListFromFile("Database/win4-3.dat");
            this.winVector[4][4] = this.buildListFromFile("Database/win4-4.dat");
            this.winVector[5][3] = this.buildListFromFile("Database/win5-3.dat");
            this.lossVector[3][3] = this.buildListFromFile("Database/loss3-3.dat");
            this.lossVector[3][4] = this.buildListFromFile("Database/loss3-4.dat");
            this.lossVector[3][5] = new ArrayList();
            this.lossVector[4][3] = new ArrayList();
            this.lossVector[4][4] = this.buildListFromFile("Database/loss4-4.dat");
            this.lossVector[5][3] = this.buildListFromFile("Database/loss5-3.dat");
            this.ready = true;
        }
        catch (IOException e) {
            System.out.println("Fehler beim Lesen der Endspiel-Datenbank!");
        }
    }

    public void reset() {
        this.winVector = null;
        this.lossVector = null;
    }

    public static Database getDatabase() {
        return database;
    }

    private ArrayList buildListFromFile(String filename) throws IOException {
        ArrayList<DatabaseEntry> vec = new ArrayList<DatabaseEntry>();
        FileInputStream fis = new FileInputStream(filename);
        byte[] buf = new byte[(int)new File(filename).length()];
        byte[] nextEntry = new byte[4];
        fis.read(buf);
        fis.close();
        int endPosition = buf.length;
        int position = 0;
        while (position < endPosition) {
            System.arraycopy(buf, position, nextEntry, 0, 4);
            vec.add(new DatabaseEntry(this.bytes2Int(nextEntry), buf[position + 4]));
            position += 5;
        }
        return vec;
    }

    public double getValue(Playground pg, Player player) throws NullPointerException {
        int aktPlayerStones = player.getNumberOfStones();
        int oppPlayerStones = player.getOpponent().getNumberOfStones();
        if (player.getStone() == Stone.O) {
            DatabaseEntry de = new DatabaseEntry(this.getLowestHashcode(pg));
            int de_index = this.winVector[aktPlayerStones][oppPlayerStones].indexOf(de);
            if (de_index >= 0) {
                return 1.0 - (double)((DatabaseEntry)this.winVector[aktPlayerStones][oppPlayerStones].get(de_index)).getDepth() * 1.0E-10;
            }
            de = new DatabaseEntry(this.getInverseLowestHashcode(pg));
            de_index = this.lossVector[oppPlayerStones][aktPlayerStones].indexOf(de);
            if (de_index >= 0) {
                return -1.0 + (double)((DatabaseEntry)this.lossVector[oppPlayerStones][aktPlayerStones].get(de_index)).getDepth() * 1.0E-10;
            }
        } else {
            DatabaseEntry de = new DatabaseEntry(this.getInverseLowestHashcode(pg));
            int de_index = this.winVector[aktPlayerStones][oppPlayerStones].indexOf(de);
            if (de_index >= 0) {
                return 1.0 - (double)((DatabaseEntry)this.winVector[aktPlayerStones][oppPlayerStones].get(de_index)).getDepth() * 1.0E-10;
            }
            de = new DatabaseEntry(this.getLowestHashcode(pg));
            de_index = this.lossVector[oppPlayerStones][aktPlayerStones].indexOf(de);
            if (de_index >= 0) {
                return -1.0 + (double)((DatabaseEntry)this.lossVector[oppPlayerStones][aktPlayerStones].get(de_index)).getDepth() * 1.0E-10;
            }
        }
        return 0.0;
    }

    private int getLowestHashcode(Playground pg) {
        return PermutationCreator.getLowestHashCode(pg.getStones());
    }

    private int getInverseLowestHashcode(Playground pg) {
        BitSet[] bs = pg.getStones();
        BitSet[] inverseBS = new BitSet[]{bs[1], bs[0]};
        return PermutationCreator.getLowestHashCode(inverseBS);
    }

    private int bytes2Int(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public boolean isReady() {
        return this.ready;
    }
}

