/*
 * Decompiled with CFR 0.152.
 */
package muehle.player;

import muehle.gui.StatusPanel;
import muehle.logic.Action;
import muehle.logic.DeleteAction;
import muehle.logic.MoveAction;
import muehle.logic.Playground;
import muehle.logic.SetAction;
import muehle.logic.Stone;
import muehle.player.ComputerPlayer;
import muehle.player.Player;
import muehle.thinking.EvaluatedAction;
import muehle.thinking.Heuristic;

public class HumanPlayer
extends Player {
    private int destination;
    private int source;
    private Action proposalAction;
    private Action proposalDrop;

    public HumanPlayer(String name, Stone s) {
        super(name, s);
    }

    public void getThread(Thread play) {
        this.play = play;
    }

    public void makeMove(Playground p) {
        long time1 = System.currentTimeMillis();
        this.stopGameThread();
        this.time += System.currentTimeMillis() - time1;
        if (this.play.isInterrupted()) {
            return;
        }
        this.proposalAction = null;
        this.proposalDrop = null;
        if (this.canSet()) {
            SetAction action = new SetAction(this, this.destination);
            if (p.execute(action)) {
                this.appendLastAction(action);
                this.informOpponent(action);
                this.soundPlayback(1);
            } else {
                this.makeMove(p);
            }
        } else {
            MoveAction action = new MoveAction(this, this.destination, this.source);
            if (p.execute(action)) {
                this.appendLastAction(action);
                this.informOpponent(action);
                this.soundPlayback(1);
            } else {
                this.makeMove(p);
            }
        }
    }

    public void deleteStone(Playground p) {
        long time1 = System.currentTimeMillis();
        this.stopGameThread();
        this.time += System.currentTimeMillis() - time1;
        DeleteAction action = new DeleteAction(this.getOpponent(), this.destination);
        if (p.execute(action)) {
            this.appendLastAction(action);
            this.informOpponent(action);
        } else {
            this.deleteStone(p);
        }
    }

    public boolean acceptDraw(Playground p) {
        return true;
    }

    public void pressedAt(int source) {
        this.source = source;
    }

    public void releasedAt(int destination) {
        this.destination = destination;
        if (this.play == null) {
            return;
        }
        Thread thread = this.play;
        synchronized (thread) {
            this.gestoppt = false;
            this.play.notify();
        }
    }

    public Player getClone() {
        HumanPlayer temp = new HumanPlayer(this.name, this.s);
        temp.setNumberOfStones(this.numberOfStones);
        temp.setNumberOfInitStones(this.initStones);
        temp.setOpponent(this.getOpponent());
        return temp;
    }

    public ComputerPlayer getComputerClone(Heuristic h) {
        ComputerPlayer temp = new ComputerPlayer(this.name, this.s, h);
        temp.setNumberOfStones(this.numberOfStones);
        temp.setNumberOfInitStones(this.initStones);
        temp.setOpponent(this.getOpponent());
        return temp;
    }

    public void moveProposal(Playground p, StatusPanel sp, Heuristic h) {
        EvaluatedAction ea = this.getComputerClone(h).calculateBestAction(p);
        sp.setText("Vorgeschlagener Zug: " + ea.getMove());
        if (ea.getDrop() != null) {
            sp.setText("Vorgeschlagener Zug: " + ea.getDrop());
        }
        this.proposalAction = ea.getMove();
        this.proposalDrop = ea.getDrop();
    }

    public Action getProposalAction() {
        return this.proposalAction;
    }

    public Action getProposalDrop() {
        return this.proposalDrop;
    }
}

