package jpp.tv;

import java.util.Comparator;

/**
 * Ein Komparator zum Vergleich zweier Telecast-Objekte.
 * 
 * @author Andreas Bauer, a.bauer@uni-wuerzburg.de
 * 
 */
public class TelecastComparator implements Comparator<Telecast> {

	/**
	 * Gibt eine Zahl < 0 zurueck, wenn Parameter t1 kleiner als Parameter t2
	 * eingeordnet werden soll, eine Zahl >0 wenn t1 groesser als t2 eingeordnet
	 * werden soll und 0, wenn t1 und t2 gleich sind.
	 * 
	 * @param t1
	 *            Das erste zu vergleichende Objekt der Klasse Telecast.
	 * @param t2
	 *            Das zweite zu vergleichende Objekt der Klasse Telecast.
	 */
	public int compare(Telecast t1, Telecast t2) {
		if (!t1.getEnd().equals(t2.getEnd())) // Zuerst wird nach Endzeitpunkten
												// verglichen
			return t1.getEnd().compareTo(t2.getEnd());
		else if (!t1.getStart().equals(t2.getStart())) // Dann nach den
														// Startzeitpunkten
			return t1.getStart().compareTo(t2.getStart());
		else if (!t1.getName().equals(t2.getName())) // Dann nach Namen
			return t1.getName().compareTo(t2.getName());
		else if (!t1.getChannel().equals(t1.getChannel())) // Und zuletzt nach
															// dem Channel
			return t1.getChannel().compareTo(t2.getChannel());
		else
			// Sind alle Attribute gleich, muss 0 zurueckgegeben werden.
			return 0;
	}

}
