package jpp.tv;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;

/**
 * Klasse, mit der man eine sich nicht ueberschneidende Liste von
 * Telecast-Objekten erstellen kann.
 * 
 * @author Andreas Bauer, a.bauer@uni-wuerzburg.de
 * @author Marco Nehmeier
 * 
 */
public class TelecastSelector {

	/**
	 * Gibt bei Eingabe einer Liste mit Objekten der Klasse Telecast eine Liste
	 * von sich nicht ueberschneidenden Telecast-Objekten zurueck.
	 * 
	 * @param list
	 *            Die Liste der verfuegbaren Telecast-Objekte.
	 * @return Eine Liste mit sich nicht ueberschneidenden Telecast-Objekten.
	 */
	public static List<Telecast> select(List<? extends Telecast> list) {

        // sortieren
        TreeSet<Telecast> set = new TreeSet<Telecast>(Collections
                .reverseOrder(new TelecastComparator()));
        set.addAll(list);

        // Ergebnisliste
        LinkedList<Telecast> resultList = new LinkedList<Telecast>();

        Iterator<Telecast> iter = set.descendingIterator();

        while (iter.hasNext()) {
            Telecast current = iter.next();

            // Wenn nicht ueberschneidend dann in die liste
            if (resultList.isEmpty()
                    || !current.getStart()
                            .before(resultList.getLast().getEnd()))
                resultList.add(current);
        }

        return resultList;
	}

	/**
	 * Stellt die Nutzerinteraktion mit dem Programm ueber die Standard-Konsole
	 * dar.
	 * 
	 * @param args
	 *            Keine Funktion.
	 */
	public static void main(String[] args) {
		// Mit dem Scanner wird auf der Standardeingabe gelesen
		Scanner sc = new Scanner(System.in);

		SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy hh:mm");

		LinkedList<Telecast> list = new LinkedList<Telecast>();

		System.out.println("You have " + list.size()
				+ " telecasts in your list...");
		System.out
				.println("Do you want to [a]dd another telecast, [s]how a selection of non-overlapping telecasts or [q]uit the programm?");

		while (sc.hasNextLine()) {
			String command = sc.nextLine();
			try {
				if ("a".equals(command)) {
					try {
						System.out.println("Name:");
						String name = sc.nextLine();

						if (name == null) {
							System.out.println("Invalid input!");
							continue;
						}

						System.out.println("Channel:");
						Channel channel = Channel.valueOf(sc.nextLine());

						System.out.println("Start:");
						Date start = dateFormat.parse(sc.nextLine());

						System.out.println("End:");
						Date end = dateFormat.parse(sc.nextLine());

						list.add(new Telecast(name, channel, start, end));
					} catch (IllegalArgumentException e) { // Um Fehleingaben
															// abzufangen
						System.out.println("Invalid input!");
						continue;

					} catch (ParseException e) { // Um Fehleingaben abzufangen
						System.out.println("Invalid input!");
						continue;
					}
				} else if ("s".equals(command)) {
					System.out.println(">>>");
					for (Telecast t : select(list)) {
						System.out.println(t);
					}
					System.out.println(">>>");
				} else if ("q".equals(command)) {
					break;
				} else {
					System.out.println("Invalid input!");
				}

			} finally {
				if (!"q".equals(command)) {
					System.out.println("You have " + list.size()
							+ " telecasts in your list...");
					System.out
							.println("Do you want to [a]dd another telecast, [s]how a selection of non-overlapping telecasts or [q]uit the programm?");
				}
			}
		}
	}
}
