% 2025 Prof. Dr. Matthias Jung, VDE Bayern
\ProvidesClass{vde}[2025/09/24 VDE klasse basierend auf scrartcl]

% Pass Options to scrartcl and process them
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{scrartcl}}
\ProcessOptions\relax

% Load base class:
\LoadClass[
    paper=a4,
    fontsize=10pt,
    titlepage=false,
    twocolumn
]{scrartcl}

% Packages:
\RequirePackage{geometry}
\RequirePackage{fontspec}
\RequirePackage{scrletter}
\RequirePackage{etoolbox}
\RequirePackage{graphicx}

% Settings:
\geometry{
    a4paper,
    left=2cm,
    right=2cm,
    top=2cm,
    bottom=2.5cm,
}

% Fonts:
\setmainfont{Times New Roman}
\setkomafont{section}{\normalfont\bfseries\fontsize{14pt}{14pt}\selectfont}
\setkomafont{subsection}{\normalfont\bfseries\fontsize{12pt}{12pt}\selectfont}
\setkomafont{subsubsection}{\normalfont\bfseries\fontsize{10pt}{10pt}\selectfont}

% Variables:
\newkomavar{affiliation}
\newcommand{\affiliation}[1]{\setkomavar{affiliation}{#1}}
\newkomavar{email}
\newcommand{\email}[1]{\setkomavar{email}{#1}}

% Title:
\makeatletter
\newcommand{\@abstract}{} % Save Abstract
\RenewDocumentEnvironment{abstract}{+b}{%
    \gdef\@abstract{#1}%
}{}
\renewcommand*{\@maketitle}{%
    \begin{flushleft}%
        {\fontsize{16pt}{16pt}\selectfont\bfseries \@title \par}%
        \vskip 1\baselineskip%
        {\normalsize \@author \par}%
        \Ifkomavarempty{affiliation}{}{%
            {\normalsize \usekomavar{affiliation}\par}%
        }\Ifkomavarempty{email}{}{%
            {\normalsize \usekomavar{email}\par}%
        }%
    \end{flushleft}
    \ifdefempty{\@abstract}{}{%
        \addsec*{\abstractname}%
        {\normalsize \@abstract\par}%
    }
    \par
    \vskip 2\baselineskip
}%
\def\ps@plain{\ps@empty}
\makeatother

\KOMAoptions{plainfootsepline=false,plainheadsepline=false}
\AtBeginDocument{\thispagestyle{empty}\pagestyle{empty}}